<?php

namespace dgsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Viewership StructType
 * @package Dg
 * @subpackage Structs
 */
class DgViewership extends AbstractStructBase
{
    /**
     * The ViewershipCodes
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgViewershipCodes
     */
    public $ViewershipCodes;
    /**
     * The SystemCodes
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgSystemCodes
     */
    public $SystemCodes;
    /**
     * The ProfileTypes
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\ArrayType\DgArrayOfViewershipsTypeViewershipProfileType
     */
    public $ProfileTypes;
    /**
     * The ProfileRefs
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\ArrayType\DgArrayOfUniqueID_Type
     */
    public $ProfileRefs;
    /**
     * The Profiles
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\ArrayType\DgArrayOfProfileType
     */
    public $Profiles;
    /**
     * The LocationCodes
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgLocationCodes
     */
    public $LocationCodes;
    /**
     * The BookingChannelCodes
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgBookingChannelCodes
     */
    public $BookingChannelCodes;
    /**
     * The DistributorTypes
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\ArrayType\DgArrayOfViewershipsTypeViewershipDistributorType
     */
    public $DistributorTypes;
    /**
     * The ViewershipRPH
     * @var string
     */
    public $ViewershipRPH;
    /**
     * The ViewOnly
     * @var bool
     */
    public $ViewOnly;
    /**
     * Constructor method for Viewership
     * @uses DgViewership::setViewershipCodes()
     * @uses DgViewership::setSystemCodes()
     * @uses DgViewership::setProfileTypes()
     * @uses DgViewership::setProfileRefs()
     * @uses DgViewership::setProfiles()
     * @uses DgViewership::setLocationCodes()
     * @uses DgViewership::setBookingChannelCodes()
     * @uses DgViewership::setDistributorTypes()
     * @uses DgViewership::setViewershipRPH()
     * @uses DgViewership::setViewOnly()
     * @param \dgsoft\StructType\DgViewershipCodes $viewershipCodes
     * @param \dgsoft\StructType\DgSystemCodes $systemCodes
     * @param \dgsoft\ArrayType\DgArrayOfViewershipsTypeViewershipProfileType $profileTypes
     * @param \dgsoft\ArrayType\DgArrayOfUniqueID_Type $profileRefs
     * @param \dgsoft\ArrayType\DgArrayOfProfileType $profiles
     * @param \dgsoft\StructType\DgLocationCodes $locationCodes
     * @param \dgsoft\StructType\DgBookingChannelCodes $bookingChannelCodes
     * @param \dgsoft\ArrayType\DgArrayOfViewershipsTypeViewershipDistributorType $distributorTypes
     * @param string $viewershipRPH
     * @param bool $viewOnly
     */
    public function __construct(\dgsoft\StructType\DgViewershipCodes $viewershipCodes = null, \dgsoft\StructType\DgSystemCodes $systemCodes = null, \dgsoft\ArrayType\DgArrayOfViewershipsTypeViewershipProfileType $profileTypes = null, \dgsoft\ArrayType\DgArrayOfUniqueID_Type $profileRefs = null, \dgsoft\ArrayType\DgArrayOfProfileType $profiles = null, \dgsoft\StructType\DgLocationCodes $locationCodes = null, \dgsoft\StructType\DgBookingChannelCodes $bookingChannelCodes = null, \dgsoft\ArrayType\DgArrayOfViewershipsTypeViewershipDistributorType $distributorTypes = null, $viewershipRPH = null, $viewOnly = null)
    {
        $this
            ->setViewershipCodes($viewershipCodes)
            ->setSystemCodes($systemCodes)
            ->setProfileTypes($profileTypes)
            ->setProfileRefs($profileRefs)
            ->setProfiles($profiles)
            ->setLocationCodes($locationCodes)
            ->setBookingChannelCodes($bookingChannelCodes)
            ->setDistributorTypes($distributorTypes)
            ->setViewershipRPH($viewershipRPH)
            ->setViewOnly($viewOnly);
    }
    /**
     * Get ViewershipCodes value
     * @return \dgsoft\StructType\DgViewershipCodes|null
     */
    public function getViewershipCodes()
    {
        return $this->ViewershipCodes;
    }
    /**
     * Set ViewershipCodes value
     * @param \dgsoft\StructType\DgViewershipCodes $viewershipCodes
     * @return \dgsoft\StructType\DgViewership
     */
    public function setViewershipCodes(\dgsoft\StructType\DgViewershipCodes $viewershipCodes = null)
    {
        $this->ViewershipCodes = $viewershipCodes;
        return $this;
    }
    /**
     * Get SystemCodes value
     * @return \dgsoft\StructType\DgSystemCodes|null
     */
    public function getSystemCodes()
    {
        return $this->SystemCodes;
    }
    /**
     * Set SystemCodes value
     * @param \dgsoft\StructType\DgSystemCodes $systemCodes
     * @return \dgsoft\StructType\DgViewership
     */
    public function setSystemCodes(\dgsoft\StructType\DgSystemCodes $systemCodes = null)
    {
        $this->SystemCodes = $systemCodes;
        return $this;
    }
    /**
     * Get ProfileTypes value
     * @return \dgsoft\ArrayType\DgArrayOfViewershipsTypeViewershipProfileType|null
     */
    public function getProfileTypes()
    {
        return $this->ProfileTypes;
    }
    /**
     * Set ProfileTypes value
     * @param \dgsoft\ArrayType\DgArrayOfViewershipsTypeViewershipProfileType $profileTypes
     * @return \dgsoft\StructType\DgViewership
     */
    public function setProfileTypes(\dgsoft\ArrayType\DgArrayOfViewershipsTypeViewershipProfileType $profileTypes = null)
    {
        $this->ProfileTypes = $profileTypes;
        return $this;
    }
    /**
     * Get ProfileRefs value
     * @return \dgsoft\ArrayType\DgArrayOfUniqueID_Type|null
     */
    public function getProfileRefs()
    {
        return $this->ProfileRefs;
    }
    /**
     * Set ProfileRefs value
     * @param \dgsoft\ArrayType\DgArrayOfUniqueID_Type $profileRefs
     * @return \dgsoft\StructType\DgViewership
     */
    public function setProfileRefs(\dgsoft\ArrayType\DgArrayOfUniqueID_Type $profileRefs = null)
    {
        $this->ProfileRefs = $profileRefs;
        return $this;
    }
    /**
     * Get Profiles value
     * @return \dgsoft\ArrayType\DgArrayOfProfileType|null
     */
    public function getProfiles()
    {
        return $this->Profiles;
    }
    /**
     * Set Profiles value
     * @param \dgsoft\ArrayType\DgArrayOfProfileType $profiles
     * @return \dgsoft\StructType\DgViewership
     */
    public function setProfiles(\dgsoft\ArrayType\DgArrayOfProfileType $profiles = null)
    {
        $this->Profiles = $profiles;
        return $this;
    }
    /**
     * Get LocationCodes value
     * @return \dgsoft\StructType\DgLocationCodes|null
     */
    public function getLocationCodes()
    {
        return $this->LocationCodes;
    }
    /**
     * Set LocationCodes value
     * @param \dgsoft\StructType\DgLocationCodes $locationCodes
     * @return \dgsoft\StructType\DgViewership
     */
    public function setLocationCodes(\dgsoft\StructType\DgLocationCodes $locationCodes = null)
    {
        $this->LocationCodes = $locationCodes;
        return $this;
    }
    /**
     * Get BookingChannelCodes value
     * @return \dgsoft\StructType\DgBookingChannelCodes|null
     */
    public function getBookingChannelCodes()
    {
        return $this->BookingChannelCodes;
    }
    /**
     * Set BookingChannelCodes value
     * @param \dgsoft\StructType\DgBookingChannelCodes $bookingChannelCodes
     * @return \dgsoft\StructType\DgViewership
     */
    public function setBookingChannelCodes(\dgsoft\StructType\DgBookingChannelCodes $bookingChannelCodes = null)
    {
        $this->BookingChannelCodes = $bookingChannelCodes;
        return $this;
    }
    /**
     * Get DistributorTypes value
     * @return \dgsoft\ArrayType\DgArrayOfViewershipsTypeViewershipDistributorType|null
     */
    public function getDistributorTypes()
    {
        return $this->DistributorTypes;
    }
    /**
     * Set DistributorTypes value
     * @param \dgsoft\ArrayType\DgArrayOfViewershipsTypeViewershipDistributorType $distributorTypes
     * @return \dgsoft\StructType\DgViewership
     */
    public function setDistributorTypes(\dgsoft\ArrayType\DgArrayOfViewershipsTypeViewershipDistributorType $distributorTypes = null)
    {
        $this->DistributorTypes = $distributorTypes;
        return $this;
    }
    /**
     * Get ViewershipRPH value
     * @return string|null
     */
    public function getViewershipRPH()
    {
        return $this->ViewershipRPH;
    }
    /**
     * Set ViewershipRPH value
     * @param string $viewershipRPH
     * @return \dgsoft\StructType\DgViewership
     */
    public function setViewershipRPH($viewershipRPH = null)
    {
        // validation for constraint: string
        if (!is_null($viewershipRPH) && !is_string($viewershipRPH)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($viewershipRPH)), __LINE__);
        }
        $this->ViewershipRPH = $viewershipRPH;
        return $this;
    }
    /**
     * Get ViewOnly value
     * @return bool|null
     */
    public function getViewOnly()
    {
        return $this->ViewOnly;
    }
    /**
     * Set ViewOnly value
     * @param bool $viewOnly
     * @return \dgsoft\StructType\DgViewership
     */
    public function setViewOnly($viewOnly = null)
    {
        // validation for constraint: boolean
        if (!is_null($viewOnly) && !is_bool($viewOnly)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($viewOnly)), __LINE__);
        }
        $this->ViewOnly = $viewOnly;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\StructType\DgViewership
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
