<?php

namespace dgsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for VerificationType StructType
 * @package Dg
 * @subpackage Structs
 */
class DgVerificationType extends AbstractStructBase
{
    /**
     * The PersonName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgPersonName
     */
    public $PersonName;
    /**
     * The Email
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgEmailType
     */
    public $Email;
    /**
     * The TelephoneInfo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgTelephoneInfo
     */
    public $TelephoneInfo;
    /**
     * The PaymentCard
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgPaymentCardType
     */
    public $PaymentCard;
    /**
     * The AddressInfo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgAddressInfoType
     */
    public $AddressInfo;
    /**
     * The CustLoyalty
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgCustLoyalty[]
     */
    public $CustLoyalty;
    /**
     * The Vendor
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgCompanyNameType[]
     */
    public $Vendor;
    /**
     * The ReservationTimeSpan
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgReservationTimeSpan
     */
    public $ReservationTimeSpan;
    /**
     * The AssociatedQuantity
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgAssociatedQuantity[]
     */
    public $AssociatedQuantity;
    /**
     * The StartLocation
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgStartLocation
     */
    public $StartLocation;
    /**
     * The EndLocation
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgEndLocation
     */
    public $EndLocation;
    /**
     * The TPA_Extensions
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgTPA_ExtensionsType
     */
    public $TPA_Extensions;
    /**
     * Constructor method for VerificationType
     * @uses DgVerificationType::setPersonName()
     * @uses DgVerificationType::setEmail()
     * @uses DgVerificationType::setTelephoneInfo()
     * @uses DgVerificationType::setPaymentCard()
     * @uses DgVerificationType::setAddressInfo()
     * @uses DgVerificationType::setCustLoyalty()
     * @uses DgVerificationType::setVendor()
     * @uses DgVerificationType::setReservationTimeSpan()
     * @uses DgVerificationType::setAssociatedQuantity()
     * @uses DgVerificationType::setStartLocation()
     * @uses DgVerificationType::setEndLocation()
     * @uses DgVerificationType::setTPA_Extensions()
     * @param \dgsoft\StructType\DgPersonName $personName
     * @param \dgsoft\StructType\DgEmailType $email
     * @param \dgsoft\StructType\DgTelephoneInfo $telephoneInfo
     * @param \dgsoft\StructType\DgPaymentCardType $paymentCard
     * @param \dgsoft\StructType\DgAddressInfoType $addressInfo
     * @param \dgsoft\StructType\DgCustLoyalty[] $custLoyalty
     * @param \dgsoft\StructType\DgCompanyNameType[] $vendor
     * @param \dgsoft\StructType\DgReservationTimeSpan $reservationTimeSpan
     * @param \dgsoft\StructType\DgAssociatedQuantity[] $associatedQuantity
     * @param \dgsoft\StructType\DgStartLocation $startLocation
     * @param \dgsoft\StructType\DgEndLocation $endLocation
     * @param \dgsoft\StructType\DgTPA_ExtensionsType $tPA_Extensions
     */
    public function __construct(\dgsoft\StructType\DgPersonName $personName = null, \dgsoft\StructType\DgEmailType $email = null, \dgsoft\StructType\DgTelephoneInfo $telephoneInfo = null, \dgsoft\StructType\DgPaymentCardType $paymentCard = null, \dgsoft\StructType\DgAddressInfoType $addressInfo = null, array $custLoyalty = array(), array $vendor = array(), \dgsoft\StructType\DgReservationTimeSpan $reservationTimeSpan = null, array $associatedQuantity = array(), \dgsoft\StructType\DgStartLocation $startLocation = null, \dgsoft\StructType\DgEndLocation $endLocation = null, \dgsoft\StructType\DgTPA_ExtensionsType $tPA_Extensions = null)
    {
        $this
            ->setPersonName($personName)
            ->setEmail($email)
            ->setTelephoneInfo($telephoneInfo)
            ->setPaymentCard($paymentCard)
            ->setAddressInfo($addressInfo)
            ->setCustLoyalty($custLoyalty)
            ->setVendor($vendor)
            ->setReservationTimeSpan($reservationTimeSpan)
            ->setAssociatedQuantity($associatedQuantity)
            ->setStartLocation($startLocation)
            ->setEndLocation($endLocation)
            ->setTPA_Extensions($tPA_Extensions);
    }
    /**
     * Get PersonName value
     * @return \dgsoft\StructType\DgPersonName|null
     */
    public function getPersonName()
    {
        return $this->PersonName;
    }
    /**
     * Set PersonName value
     * @param \dgsoft\StructType\DgPersonName $personName
     * @return \dgsoft\StructType\DgVerificationType
     */
    public function setPersonName(\dgsoft\StructType\DgPersonName $personName = null)
    {
        $this->PersonName = $personName;
        return $this;
    }
    /**
     * Get Email value
     * @return \dgsoft\StructType\DgEmailType|null
     */
    public function getEmail()
    {
        return $this->Email;
    }
    /**
     * Set Email value
     * @param \dgsoft\StructType\DgEmailType $email
     * @return \dgsoft\StructType\DgVerificationType
     */
    public function setEmail(\dgsoft\StructType\DgEmailType $email = null)
    {
        $this->Email = $email;
        return $this;
    }
    /**
     * Get TelephoneInfo value
     * @return \dgsoft\StructType\DgTelephoneInfo|null
     */
    public function getTelephoneInfo()
    {
        return $this->TelephoneInfo;
    }
    /**
     * Set TelephoneInfo value
     * @param \dgsoft\StructType\DgTelephoneInfo $telephoneInfo
     * @return \dgsoft\StructType\DgVerificationType
     */
    public function setTelephoneInfo(\dgsoft\StructType\DgTelephoneInfo $telephoneInfo = null)
    {
        $this->TelephoneInfo = $telephoneInfo;
        return $this;
    }
    /**
     * Get PaymentCard value
     * @return \dgsoft\StructType\DgPaymentCardType|null
     */
    public function getPaymentCard()
    {
        return $this->PaymentCard;
    }
    /**
     * Set PaymentCard value
     * @param \dgsoft\StructType\DgPaymentCardType $paymentCard
     * @return \dgsoft\StructType\DgVerificationType
     */
    public function setPaymentCard(\dgsoft\StructType\DgPaymentCardType $paymentCard = null)
    {
        $this->PaymentCard = $paymentCard;
        return $this;
    }
    /**
     * Get AddressInfo value
     * @return \dgsoft\StructType\DgAddressInfoType|null
     */
    public function getAddressInfo()
    {
        return $this->AddressInfo;
    }
    /**
     * Set AddressInfo value
     * @param \dgsoft\StructType\DgAddressInfoType $addressInfo
     * @return \dgsoft\StructType\DgVerificationType
     */
    public function setAddressInfo(\dgsoft\StructType\DgAddressInfoType $addressInfo = null)
    {
        $this->AddressInfo = $addressInfo;
        return $this;
    }
    /**
     * Get CustLoyalty value
     * @return \dgsoft\StructType\DgCustLoyalty[]|null
     */
    public function getCustLoyalty()
    {
        return $this->CustLoyalty;
    }
    /**
     * Set CustLoyalty value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgCustLoyalty[] $custLoyalty
     * @return \dgsoft\StructType\DgVerificationType
     */
    public function setCustLoyalty(array $custLoyalty = array())
    {
        foreach ($custLoyalty as $verificationTypeCustLoyaltyItem) {
            // validation for constraint: itemType
            if (!$verificationTypeCustLoyaltyItem instanceof \dgsoft\StructType\DgCustLoyalty) {
                throw new \InvalidArgumentException(sprintf('The CustLoyalty property can only contain items of \dgsoft\StructType\DgCustLoyalty, "%s" given', is_object($verificationTypeCustLoyaltyItem) ? get_class($verificationTypeCustLoyaltyItem) : gettype($verificationTypeCustLoyaltyItem)), __LINE__);
            }
        }
        $this->CustLoyalty = $custLoyalty;
        return $this;
    }
    /**
     * Add item to CustLoyalty value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgCustLoyalty $item
     * @return \dgsoft\StructType\DgVerificationType
     */
    public function addToCustLoyalty(\dgsoft\StructType\DgCustLoyalty $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \dgsoft\StructType\DgCustLoyalty) {
            throw new \InvalidArgumentException(sprintf('The CustLoyalty property can only contain items of \dgsoft\StructType\DgCustLoyalty, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->CustLoyalty[] = $item;
        return $this;
    }
    /**
     * Get Vendor value
     * @return \dgsoft\StructType\DgCompanyNameType[]|null
     */
    public function getVendor()
    {
        return $this->Vendor;
    }
    /**
     * Set Vendor value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgCompanyNameType[] $vendor
     * @return \dgsoft\StructType\DgVerificationType
     */
    public function setVendor(array $vendor = array())
    {
        foreach ($vendor as $verificationTypeVendorItem) {
            // validation for constraint: itemType
            if (!$verificationTypeVendorItem instanceof \dgsoft\StructType\DgCompanyNameType) {
                throw new \InvalidArgumentException(sprintf('The Vendor property can only contain items of \dgsoft\StructType\DgCompanyNameType, "%s" given', is_object($verificationTypeVendorItem) ? get_class($verificationTypeVendorItem) : gettype($verificationTypeVendorItem)), __LINE__);
            }
        }
        $this->Vendor = $vendor;
        return $this;
    }
    /**
     * Add item to Vendor value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgCompanyNameType $item
     * @return \dgsoft\StructType\DgVerificationType
     */
    public function addToVendor(\dgsoft\StructType\DgCompanyNameType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \dgsoft\StructType\DgCompanyNameType) {
            throw new \InvalidArgumentException(sprintf('The Vendor property can only contain items of \dgsoft\StructType\DgCompanyNameType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Vendor[] = $item;
        return $this;
    }
    /**
     * Get ReservationTimeSpan value
     * @return \dgsoft\StructType\DgReservationTimeSpan|null
     */
    public function getReservationTimeSpan()
    {
        return $this->ReservationTimeSpan;
    }
    /**
     * Set ReservationTimeSpan value
     * @param \dgsoft\StructType\DgReservationTimeSpan $reservationTimeSpan
     * @return \dgsoft\StructType\DgVerificationType
     */
    public function setReservationTimeSpan(\dgsoft\StructType\DgReservationTimeSpan $reservationTimeSpan = null)
    {
        $this->ReservationTimeSpan = $reservationTimeSpan;
        return $this;
    }
    /**
     * Get AssociatedQuantity value
     * @return \dgsoft\StructType\DgAssociatedQuantity[]|null
     */
    public function getAssociatedQuantity()
    {
        return $this->AssociatedQuantity;
    }
    /**
     * Set AssociatedQuantity value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgAssociatedQuantity[] $associatedQuantity
     * @return \dgsoft\StructType\DgVerificationType
     */
    public function setAssociatedQuantity(array $associatedQuantity = array())
    {
        foreach ($associatedQuantity as $verificationTypeAssociatedQuantityItem) {
            // validation for constraint: itemType
            if (!$verificationTypeAssociatedQuantityItem instanceof \dgsoft\StructType\DgAssociatedQuantity) {
                throw new \InvalidArgumentException(sprintf('The AssociatedQuantity property can only contain items of \dgsoft\StructType\DgAssociatedQuantity, "%s" given', is_object($verificationTypeAssociatedQuantityItem) ? get_class($verificationTypeAssociatedQuantityItem) : gettype($verificationTypeAssociatedQuantityItem)), __LINE__);
            }
        }
        $this->AssociatedQuantity = $associatedQuantity;
        return $this;
    }
    /**
     * Add item to AssociatedQuantity value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgAssociatedQuantity $item
     * @return \dgsoft\StructType\DgVerificationType
     */
    public function addToAssociatedQuantity(\dgsoft\StructType\DgAssociatedQuantity $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \dgsoft\StructType\DgAssociatedQuantity) {
            throw new \InvalidArgumentException(sprintf('The AssociatedQuantity property can only contain items of \dgsoft\StructType\DgAssociatedQuantity, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->AssociatedQuantity[] = $item;
        return $this;
    }
    /**
     * Get StartLocation value
     * @return \dgsoft\StructType\DgStartLocation|null
     */
    public function getStartLocation()
    {
        return $this->StartLocation;
    }
    /**
     * Set StartLocation value
     * @param \dgsoft\StructType\DgStartLocation $startLocation
     * @return \dgsoft\StructType\DgVerificationType
     */
    public function setStartLocation(\dgsoft\StructType\DgStartLocation $startLocation = null)
    {
        $this->StartLocation = $startLocation;
        return $this;
    }
    /**
     * Get EndLocation value
     * @return \dgsoft\StructType\DgEndLocation|null
     */
    public function getEndLocation()
    {
        return $this->EndLocation;
    }
    /**
     * Set EndLocation value
     * @param \dgsoft\StructType\DgEndLocation $endLocation
     * @return \dgsoft\StructType\DgVerificationType
     */
    public function setEndLocation(\dgsoft\StructType\DgEndLocation $endLocation = null)
    {
        $this->EndLocation = $endLocation;
        return $this;
    }
    /**
     * Get TPA_Extensions value
     * @return \dgsoft\StructType\DgTPA_ExtensionsType|null
     */
    public function getTPA_Extensions()
    {
        return $this->TPA_Extensions;
    }
    /**
     * Set TPA_Extensions value
     * @param \dgsoft\StructType\DgTPA_ExtensionsType $tPA_Extensions
     * @return \dgsoft\StructType\DgVerificationType
     */
    public function setTPA_Extensions(\dgsoft\StructType\DgTPA_ExtensionsType $tPA_Extensions = null)
    {
        $this->TPA_Extensions = $tPA_Extensions;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\StructType\DgVerificationType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
