<?php

namespace dgsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for VehicleTypeVehIdentity StructType
 * @package Dg
 * @subpackage Structs
 */
class DgVehicleTypeVehIdentity extends AbstractStructBase
{
    /**
     * The VehicleAssetNumber
     * @var string
     */
    public $VehicleAssetNumber;
    /**
     * The LicensePlateNumber
     * @var string
     */
    public $LicensePlateNumber;
    /**
     * The StateProvCode
     * @var string
     */
    public $StateProvCode;
    /**
     * The CountryCode
     * @var string
     */
    public $CountryCode;
    /**
     * The VehicleID_Number
     * @var string
     */
    public $VehicleID_Number;
    /**
     * The VehicleColor
     * @var string
     */
    public $VehicleColor;
    /**
     * Constructor method for VehicleTypeVehIdentity
     * @uses DgVehicleTypeVehIdentity::setVehicleAssetNumber()
     * @uses DgVehicleTypeVehIdentity::setLicensePlateNumber()
     * @uses DgVehicleTypeVehIdentity::setStateProvCode()
     * @uses DgVehicleTypeVehIdentity::setCountryCode()
     * @uses DgVehicleTypeVehIdentity::setVehicleID_Number()
     * @uses DgVehicleTypeVehIdentity::setVehicleColor()
     * @param string $vehicleAssetNumber
     * @param string $licensePlateNumber
     * @param string $stateProvCode
     * @param string $countryCode
     * @param string $vehicleID_Number
     * @param string $vehicleColor
     */
    public function __construct($vehicleAssetNumber = null, $licensePlateNumber = null, $stateProvCode = null, $countryCode = null, $vehicleID_Number = null, $vehicleColor = null)
    {
        $this
            ->setVehicleAssetNumber($vehicleAssetNumber)
            ->setLicensePlateNumber($licensePlateNumber)
            ->setStateProvCode($stateProvCode)
            ->setCountryCode($countryCode)
            ->setVehicleID_Number($vehicleID_Number)
            ->setVehicleColor($vehicleColor);
    }
    /**
     * Get VehicleAssetNumber value
     * @return string|null
     */
    public function getVehicleAssetNumber()
    {
        return $this->VehicleAssetNumber;
    }
    /**
     * Set VehicleAssetNumber value
     * @param string $vehicleAssetNumber
     * @return \dgsoft\StructType\DgVehicleTypeVehIdentity
     */
    public function setVehicleAssetNumber($vehicleAssetNumber = null)
    {
        // validation for constraint: string
        if (!is_null($vehicleAssetNumber) && !is_string($vehicleAssetNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($vehicleAssetNumber)), __LINE__);
        }
        $this->VehicleAssetNumber = $vehicleAssetNumber;
        return $this;
    }
    /**
     * Get LicensePlateNumber value
     * @return string|null
     */
    public function getLicensePlateNumber()
    {
        return $this->LicensePlateNumber;
    }
    /**
     * Set LicensePlateNumber value
     * @param string $licensePlateNumber
     * @return \dgsoft\StructType\DgVehicleTypeVehIdentity
     */
    public function setLicensePlateNumber($licensePlateNumber = null)
    {
        // validation for constraint: string
        if (!is_null($licensePlateNumber) && !is_string($licensePlateNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($licensePlateNumber)), __LINE__);
        }
        $this->LicensePlateNumber = $licensePlateNumber;
        return $this;
    }
    /**
     * Get StateProvCode value
     * @return string|null
     */
    public function getStateProvCode()
    {
        return $this->StateProvCode;
    }
    /**
     * Set StateProvCode value
     * @param string $stateProvCode
     * @return \dgsoft\StructType\DgVehicleTypeVehIdentity
     */
    public function setStateProvCode($stateProvCode = null)
    {
        // validation for constraint: string
        if (!is_null($stateProvCode) && !is_string($stateProvCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($stateProvCode)), __LINE__);
        }
        $this->StateProvCode = $stateProvCode;
        return $this;
    }
    /**
     * Get CountryCode value
     * @return string|null
     */
    public function getCountryCode()
    {
        return $this->CountryCode;
    }
    /**
     * Set CountryCode value
     * @param string $countryCode
     * @return \dgsoft\StructType\DgVehicleTypeVehIdentity
     */
    public function setCountryCode($countryCode = null)
    {
        // validation for constraint: string
        if (!is_null($countryCode) && !is_string($countryCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($countryCode)), __LINE__);
        }
        $this->CountryCode = $countryCode;
        return $this;
    }
    /**
     * Get VehicleID_Number value
     * @return string|null
     */
    public function getVehicleID_Number()
    {
        return $this->VehicleID_Number;
    }
    /**
     * Set VehicleID_Number value
     * @param string $vehicleID_Number
     * @return \dgsoft\StructType\DgVehicleTypeVehIdentity
     */
    public function setVehicleID_Number($vehicleID_Number = null)
    {
        // validation for constraint: string
        if (!is_null($vehicleID_Number) && !is_string($vehicleID_Number)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($vehicleID_Number)), __LINE__);
        }
        $this->VehicleID_Number = $vehicleID_Number;
        return $this;
    }
    /**
     * Get VehicleColor value
     * @return string|null
     */
    public function getVehicleColor()
    {
        return $this->VehicleColor;
    }
    /**
     * Set VehicleColor value
     * @param string $vehicleColor
     * @return \dgsoft\StructType\DgVehicleTypeVehIdentity
     */
    public function setVehicleColor($vehicleColor = null)
    {
        // validation for constraint: string
        if (!is_null($vehicleColor) && !is_string($vehicleColor)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($vehicleColor)), __LINE__);
        }
        $this->VehicleColor = $vehicleColor;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\StructType\DgVehicleTypeVehIdentity
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
