<?php

namespace dgsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for VehicleType StructType
 * @package Dg
 * @subpackage Structs
 */
class DgVehicleType extends DgVehicleCoreType
{
    /**
     * The NumberOfSeats
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $NumberOfSeats;
    /**
     * The NumberOfDoor
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $NumberOfDoor;
    /**
     * The ModelName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ModelName;
    /**
     * The VehMakeModel
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgVehicleTypeVehMakeModel
     */
    public $VehMakeModel;
    /**
     * The PictureURL
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PictureURL;
    /**
     * The VehIdentity
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgVehicleTypeVehIdentity
     */
    public $VehIdentity;
    /**
     * The PassengerQuantity
     * @var string
     */
    public $PassengerQuantity;
    /**
     * The BaggageQuantity
     * @var int
     */
    public $BaggageQuantity;
    /**
     * The VendorCarType
     * @var string
     */
    public $VendorCarType;
    /**
     * The Code
     * @var string
     */
    public $Code;
    /**
     * The CodeContext
     * @var string
     */
    public $CodeContext;
    /**
     * The UnitOfMeasureQuantity
     * @var float
     */
    public $UnitOfMeasureQuantity;
    /**
     * The UnitOfMeasure
     * @var string
     */
    public $UnitOfMeasure;
    /**
     * The UnitOfMeasureCode
     * @var string
     */
    public $UnitOfMeasureCode;
    /**
     * The Start
     * @var string
     */
    public $Start;
    /**
     * The Duration
     * @var string
     */
    public $Duration;
    /**
     * The End
     * @var string
     */
    public $End;
    /**
     * The OdometerUnitOfMeasure
     * @var string
     */
    public $OdometerUnitOfMeasure;
    /**
     * Constructor method for VehicleType
     * @uses DgVehicleType::setNumberOfSeats()
     * @uses DgVehicleType::setNumberOfDoor()
     * @uses DgVehicleType::setModelName()
     * @uses DgVehicleType::setVehMakeModel()
     * @uses DgVehicleType::setPictureURL()
     * @uses DgVehicleType::setVehIdentity()
     * @uses DgVehicleType::setPassengerQuantity()
     * @uses DgVehicleType::setBaggageQuantity()
     * @uses DgVehicleType::setVendorCarType()
     * @uses DgVehicleType::setCode()
     * @uses DgVehicleType::setCodeContext()
     * @uses DgVehicleType::setUnitOfMeasureQuantity()
     * @uses DgVehicleType::setUnitOfMeasure()
     * @uses DgVehicleType::setUnitOfMeasureCode()
     * @uses DgVehicleType::setStart()
     * @uses DgVehicleType::setDuration()
     * @uses DgVehicleType::setEnd()
     * @uses DgVehicleType::setOdometerUnitOfMeasure()
     * @param string $numberOfSeats
     * @param string $numberOfDoor
     * @param string $modelName
     * @param \dgsoft\StructType\DgVehicleTypeVehMakeModel $vehMakeModel
     * @param string $pictureURL
     * @param \dgsoft\StructType\DgVehicleTypeVehIdentity $vehIdentity
     * @param string $passengerQuantity
     * @param int $baggageQuantity
     * @param string $vendorCarType
     * @param string $code
     * @param string $codeContext
     * @param float $unitOfMeasureQuantity
     * @param string $unitOfMeasure
     * @param string $unitOfMeasureCode
     * @param string $start
     * @param string $duration
     * @param string $end
     * @param string $odometerUnitOfMeasure
     */
    public function __construct($numberOfSeats = null, $numberOfDoor = null, $modelName = null, \dgsoft\StructType\DgVehicleTypeVehMakeModel $vehMakeModel = null, $pictureURL = null, \dgsoft\StructType\DgVehicleTypeVehIdentity $vehIdentity = null, $passengerQuantity = null, $baggageQuantity = null, $vendorCarType = null, $code = null, $codeContext = null, $unitOfMeasureQuantity = null, $unitOfMeasure = null, $unitOfMeasureCode = null, $start = null, $duration = null, $end = null, $odometerUnitOfMeasure = null)
    {
        $this
            ->setNumberOfSeats($numberOfSeats)
            ->setNumberOfDoor($numberOfDoor)
            ->setModelName($modelName)
            ->setVehMakeModel($vehMakeModel)
            ->setPictureURL($pictureURL)
            ->setVehIdentity($vehIdentity)
            ->setPassengerQuantity($passengerQuantity)
            ->setBaggageQuantity($baggageQuantity)
            ->setVendorCarType($vendorCarType)
            ->setCode($code)
            ->setCodeContext($codeContext)
            ->setUnitOfMeasureQuantity($unitOfMeasureQuantity)
            ->setUnitOfMeasure($unitOfMeasure)
            ->setUnitOfMeasureCode($unitOfMeasureCode)
            ->setStart($start)
            ->setDuration($duration)
            ->setEnd($end)
            ->setOdometerUnitOfMeasure($odometerUnitOfMeasure);
    }
    /**
     * Get NumberOfSeats value
     * @return string|null
     */
    public function getNumberOfSeats()
    {
        return $this->NumberOfSeats;
    }
    /**
     * Set NumberOfSeats value
     * @param string $numberOfSeats
     * @return \dgsoft\StructType\DgVehicleType
     */
    public function setNumberOfSeats($numberOfSeats = null)
    {
        // validation for constraint: string
        if (!is_null($numberOfSeats) && !is_string($numberOfSeats)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($numberOfSeats)), __LINE__);
        }
        $this->NumberOfSeats = $numberOfSeats;
        return $this;
    }
    /**
     * Get NumberOfDoor value
     * @return string|null
     */
    public function getNumberOfDoor()
    {
        return $this->NumberOfDoor;
    }
    /**
     * Set NumberOfDoor value
     * @param string $numberOfDoor
     * @return \dgsoft\StructType\DgVehicleType
     */
    public function setNumberOfDoor($numberOfDoor = null)
    {
        // validation for constraint: string
        if (!is_null($numberOfDoor) && !is_string($numberOfDoor)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($numberOfDoor)), __LINE__);
        }
        $this->NumberOfDoor = $numberOfDoor;
        return $this;
    }
    /**
     * Get ModelName value
     * @return string|null
     */
    public function getModelName()
    {
        return $this->ModelName;
    }
    /**
     * Set ModelName value
     * @param string $modelName
     * @return \dgsoft\StructType\DgVehicleType
     */
    public function setModelName($modelName = null)
    {
        // validation for constraint: string
        if (!is_null($modelName) && !is_string($modelName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($modelName)), __LINE__);
        }
        $this->ModelName = $modelName;
        return $this;
    }
    /**
     * Get VehMakeModel value
     * @return \dgsoft\StructType\DgVehicleTypeVehMakeModel|null
     */
    public function getVehMakeModel()
    {
        return $this->VehMakeModel;
    }
    /**
     * Set VehMakeModel value
     * @param \dgsoft\StructType\DgVehicleTypeVehMakeModel $vehMakeModel
     * @return \dgsoft\StructType\DgVehicleType
     */
    public function setVehMakeModel(\dgsoft\StructType\DgVehicleTypeVehMakeModel $vehMakeModel = null)
    {
        $this->VehMakeModel = $vehMakeModel;
        return $this;
    }
    /**
     * Get PictureURL value
     * @return string|null
     */
    public function getPictureURL()
    {
        return $this->PictureURL;
    }
    /**
     * Set PictureURL value
     * @param string $pictureURL
     * @return \dgsoft\StructType\DgVehicleType
     */
    public function setPictureURL($pictureURL = null)
    {
        // validation for constraint: string
        if (!is_null($pictureURL) && !is_string($pictureURL)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($pictureURL)), __LINE__);
        }
        $this->PictureURL = $pictureURL;
        return $this;
    }
    /**
     * Get VehIdentity value
     * @return \dgsoft\StructType\DgVehicleTypeVehIdentity|null
     */
    public function getVehIdentity()
    {
        return $this->VehIdentity;
    }
    /**
     * Set VehIdentity value
     * @param \dgsoft\StructType\DgVehicleTypeVehIdentity $vehIdentity
     * @return \dgsoft\StructType\DgVehicleType
     */
    public function setVehIdentity(\dgsoft\StructType\DgVehicleTypeVehIdentity $vehIdentity = null)
    {
        $this->VehIdentity = $vehIdentity;
        return $this;
    }
    /**
     * Get PassengerQuantity value
     * @return string|null
     */
    public function getPassengerQuantity()
    {
        return $this->PassengerQuantity;
    }
    /**
     * Set PassengerQuantity value
     * @param string $passengerQuantity
     * @return \dgsoft\StructType\DgVehicleType
     */
    public function setPassengerQuantity($passengerQuantity = null)
    {
        // validation for constraint: string
        if (!is_null($passengerQuantity) && !is_string($passengerQuantity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($passengerQuantity)), __LINE__);
        }
        $this->PassengerQuantity = $passengerQuantity;
        return $this;
    }
    /**
     * Get BaggageQuantity value
     * @return int|null
     */
    public function getBaggageQuantity()
    {
        return $this->BaggageQuantity;
    }
    /**
     * Set BaggageQuantity value
     * @param int $baggageQuantity
     * @return \dgsoft\StructType\DgVehicleType
     */
    public function setBaggageQuantity($baggageQuantity = null)
    {
        // validation for constraint: int
        if (!is_null($baggageQuantity) && !is_numeric($baggageQuantity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($baggageQuantity)), __LINE__);
        }
        $this->BaggageQuantity = $baggageQuantity;
        return $this;
    }
    /**
     * Get VendorCarType value
     * @return string|null
     */
    public function getVendorCarType()
    {
        return $this->VendorCarType;
    }
    /**
     * Set VendorCarType value
     * @param string $vendorCarType
     * @return \dgsoft\StructType\DgVehicleType
     */
    public function setVendorCarType($vendorCarType = null)
    {
        // validation for constraint: string
        if (!is_null($vendorCarType) && !is_string($vendorCarType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($vendorCarType)), __LINE__);
        }
        $this->VendorCarType = $vendorCarType;
        return $this;
    }
    /**
     * Get Code value
     * @return string|null
     */
    public function getCode()
    {
        return $this->Code;
    }
    /**
     * Set Code value
     * @param string $code
     * @return \dgsoft\StructType\DgVehicleType
     */
    public function setCode($code = null)
    {
        // validation for constraint: string
        if (!is_null($code) && !is_string($code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($code)), __LINE__);
        }
        $this->Code = $code;
        return $this;
    }
    /**
     * Get CodeContext value
     * @return string|null
     */
    public function getCodeContext()
    {
        return $this->CodeContext;
    }
    /**
     * Set CodeContext value
     * @param string $codeContext
     * @return \dgsoft\StructType\DgVehicleType
     */
    public function setCodeContext($codeContext = null)
    {
        // validation for constraint: string
        if (!is_null($codeContext) && !is_string($codeContext)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($codeContext)), __LINE__);
        }
        $this->CodeContext = $codeContext;
        return $this;
    }
    /**
     * Get UnitOfMeasureQuantity value
     * @return float|null
     */
    public function getUnitOfMeasureQuantity()
    {
        return $this->UnitOfMeasureQuantity;
    }
    /**
     * Set UnitOfMeasureQuantity value
     * @param float $unitOfMeasureQuantity
     * @return \dgsoft\StructType\DgVehicleType
     */
    public function setUnitOfMeasureQuantity($unitOfMeasureQuantity = null)
    {
        $this->UnitOfMeasureQuantity = $unitOfMeasureQuantity;
        return $this;
    }
    /**
     * Get UnitOfMeasure value
     * @return string|null
     */
    public function getUnitOfMeasure()
    {
        return $this->UnitOfMeasure;
    }
    /**
     * Set UnitOfMeasure value
     * @param string $unitOfMeasure
     * @return \dgsoft\StructType\DgVehicleType
     */
    public function setUnitOfMeasure($unitOfMeasure = null)
    {
        // validation for constraint: string
        if (!is_null($unitOfMeasure) && !is_string($unitOfMeasure)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($unitOfMeasure)), __LINE__);
        }
        $this->UnitOfMeasure = $unitOfMeasure;
        return $this;
    }
    /**
     * Get UnitOfMeasureCode value
     * @return string|null
     */
    public function getUnitOfMeasureCode()
    {
        return $this->UnitOfMeasureCode;
    }
    /**
     * Set UnitOfMeasureCode value
     * @param string $unitOfMeasureCode
     * @return \dgsoft\StructType\DgVehicleType
     */
    public function setUnitOfMeasureCode($unitOfMeasureCode = null)
    {
        // validation for constraint: string
        if (!is_null($unitOfMeasureCode) && !is_string($unitOfMeasureCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($unitOfMeasureCode)), __LINE__);
        }
        $this->UnitOfMeasureCode = $unitOfMeasureCode;
        return $this;
    }
    /**
     * Get Start value
     * @return string|null
     */
    public function getStart()
    {
        return $this->Start;
    }
    /**
     * Set Start value
     * @param string $start
     * @return \dgsoft\StructType\DgVehicleType
     */
    public function setStart($start = null)
    {
        // validation for constraint: string
        if (!is_null($start) && !is_string($start)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($start)), __LINE__);
        }
        $this->Start = $start;
        return $this;
    }
    /**
     * Get Duration value
     * @return string|null
     */
    public function getDuration()
    {
        return $this->Duration;
    }
    /**
     * Set Duration value
     * @param string $duration
     * @return \dgsoft\StructType\DgVehicleType
     */
    public function setDuration($duration = null)
    {
        // validation for constraint: string
        if (!is_null($duration) && !is_string($duration)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($duration)), __LINE__);
        }
        $this->Duration = $duration;
        return $this;
    }
    /**
     * Get End value
     * @return string|null
     */
    public function getEnd()
    {
        return $this->End;
    }
    /**
     * Set End value
     * @param string $end
     * @return \dgsoft\StructType\DgVehicleType
     */
    public function setEnd($end = null)
    {
        // validation for constraint: string
        if (!is_null($end) && !is_string($end)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($end)), __LINE__);
        }
        $this->End = $end;
        return $this;
    }
    /**
     * Get OdometerUnitOfMeasure value
     * @return string|null
     */
    public function getOdometerUnitOfMeasure()
    {
        return $this->OdometerUnitOfMeasure;
    }
    /**
     * Set OdometerUnitOfMeasure value
     * @uses \dgsoft\EnumType\DgDistanceUnitNameType::valueIsValid()
     * @uses \dgsoft\EnumType\DgDistanceUnitNameType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $odometerUnitOfMeasure
     * @return \dgsoft\StructType\DgVehicleType
     */
    public function setOdometerUnitOfMeasure($odometerUnitOfMeasure = null)
    {
        // validation for constraint: enumeration
        if (!\dgsoft\EnumType\DgDistanceUnitNameType::valueIsValid($odometerUnitOfMeasure)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $odometerUnitOfMeasure, implode(', ', \dgsoft\EnumType\DgDistanceUnitNameType::getValidValues())), __LINE__);
        }
        $this->OdometerUnitOfMeasure = $odometerUnitOfMeasure;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\StructType\DgVehicleType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
