<?php

namespace dgsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for VehicleReservationType StructType
 * @package Dg
 * @subpackage Structs
 */
class DgVehicleReservationType extends AbstractStructBase
{
    /**
     * The Customer
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgCustomerPrimaryAdditionalType
     */
    public $Customer;
    /**
     * The VehSegmentCore
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgVehicleReservationTypeVehSegmentCore
     */
    public $VehSegmentCore;
    /**
     * The VehSegmentInfo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgVehicleSegmentAdditionalInfoType
     */
    public $VehSegmentInfo;
    /**
     * The CreateDateTime
     * @var string
     */
    public $CreateDateTime;
    /**
     * The CreatorID
     * @var string
     */
    public $CreatorID;
    /**
     * The LastModifyDateTime
     * @var string
     */
    public $LastModifyDateTime;
    /**
     * The LastModifierID
     * @var string
     */
    public $LastModifierID;
    /**
     * The PurgeDate
     * @var string
     */
    public $PurgeDate;
    /**
     * Constructor method for VehicleReservationType
     * @uses DgVehicleReservationType::setCustomer()
     * @uses DgVehicleReservationType::setVehSegmentCore()
     * @uses DgVehicleReservationType::setVehSegmentInfo()
     * @uses DgVehicleReservationType::setCreateDateTime()
     * @uses DgVehicleReservationType::setCreatorID()
     * @uses DgVehicleReservationType::setLastModifyDateTime()
     * @uses DgVehicleReservationType::setLastModifierID()
     * @uses DgVehicleReservationType::setPurgeDate()
     * @param \dgsoft\StructType\DgCustomerPrimaryAdditionalType $customer
     * @param \dgsoft\StructType\DgVehicleReservationTypeVehSegmentCore $vehSegmentCore
     * @param \dgsoft\StructType\DgVehicleSegmentAdditionalInfoType $vehSegmentInfo
     * @param string $createDateTime
     * @param string $creatorID
     * @param string $lastModifyDateTime
     * @param string $lastModifierID
     * @param string $purgeDate
     */
    public function __construct(\dgsoft\StructType\DgCustomerPrimaryAdditionalType $customer = null, \dgsoft\StructType\DgVehicleReservationTypeVehSegmentCore $vehSegmentCore = null, \dgsoft\StructType\DgVehicleSegmentAdditionalInfoType $vehSegmentInfo = null, $createDateTime = null, $creatorID = null, $lastModifyDateTime = null, $lastModifierID = null, $purgeDate = null)
    {
        $this
            ->setCustomer($customer)
            ->setVehSegmentCore($vehSegmentCore)
            ->setVehSegmentInfo($vehSegmentInfo)
            ->setCreateDateTime($createDateTime)
            ->setCreatorID($creatorID)
            ->setLastModifyDateTime($lastModifyDateTime)
            ->setLastModifierID($lastModifierID)
            ->setPurgeDate($purgeDate);
    }
    /**
     * Get Customer value
     * @return \dgsoft\StructType\DgCustomerPrimaryAdditionalType|null
     */
    public function getCustomer()
    {
        return $this->Customer;
    }
    /**
     * Set Customer value
     * @param \dgsoft\StructType\DgCustomerPrimaryAdditionalType $customer
     * @return \dgsoft\StructType\DgVehicleReservationType
     */
    public function setCustomer(\dgsoft\StructType\DgCustomerPrimaryAdditionalType $customer = null)
    {
        $this->Customer = $customer;
        return $this;
    }
    /**
     * Get VehSegmentCore value
     * @return \dgsoft\StructType\DgVehicleReservationTypeVehSegmentCore|null
     */
    public function getVehSegmentCore()
    {
        return $this->VehSegmentCore;
    }
    /**
     * Set VehSegmentCore value
     * @param \dgsoft\StructType\DgVehicleReservationTypeVehSegmentCore $vehSegmentCore
     * @return \dgsoft\StructType\DgVehicleReservationType
     */
    public function setVehSegmentCore(\dgsoft\StructType\DgVehicleReservationTypeVehSegmentCore $vehSegmentCore = null)
    {
        $this->VehSegmentCore = $vehSegmentCore;
        return $this;
    }
    /**
     * Get VehSegmentInfo value
     * @return \dgsoft\StructType\DgVehicleSegmentAdditionalInfoType|null
     */
    public function getVehSegmentInfo()
    {
        return $this->VehSegmentInfo;
    }
    /**
     * Set VehSegmentInfo value
     * @param \dgsoft\StructType\DgVehicleSegmentAdditionalInfoType $vehSegmentInfo
     * @return \dgsoft\StructType\DgVehicleReservationType
     */
    public function setVehSegmentInfo(\dgsoft\StructType\DgVehicleSegmentAdditionalInfoType $vehSegmentInfo = null)
    {
        $this->VehSegmentInfo = $vehSegmentInfo;
        return $this;
    }
    /**
     * Get CreateDateTime value
     * @return string|null
     */
    public function getCreateDateTime()
    {
        return $this->CreateDateTime;
    }
    /**
     * Set CreateDateTime value
     * @param string $createDateTime
     * @return \dgsoft\StructType\DgVehicleReservationType
     */
    public function setCreateDateTime($createDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($createDateTime) && !is_string($createDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($createDateTime)), __LINE__);
        }
        $this->CreateDateTime = $createDateTime;
        return $this;
    }
    /**
     * Get CreatorID value
     * @return string|null
     */
    public function getCreatorID()
    {
        return $this->CreatorID;
    }
    /**
     * Set CreatorID value
     * @param string $creatorID
     * @return \dgsoft\StructType\DgVehicleReservationType
     */
    public function setCreatorID($creatorID = null)
    {
        // validation for constraint: string
        if (!is_null($creatorID) && !is_string($creatorID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($creatorID)), __LINE__);
        }
        $this->CreatorID = $creatorID;
        return $this;
    }
    /**
     * Get LastModifyDateTime value
     * @return string|null
     */
    public function getLastModifyDateTime()
    {
        return $this->LastModifyDateTime;
    }
    /**
     * Set LastModifyDateTime value
     * @param string $lastModifyDateTime
     * @return \dgsoft\StructType\DgVehicleReservationType
     */
    public function setLastModifyDateTime($lastModifyDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($lastModifyDateTime) && !is_string($lastModifyDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($lastModifyDateTime)), __LINE__);
        }
        $this->LastModifyDateTime = $lastModifyDateTime;
        return $this;
    }
    /**
     * Get LastModifierID value
     * @return string|null
     */
    public function getLastModifierID()
    {
        return $this->LastModifierID;
    }
    /**
     * Set LastModifierID value
     * @param string $lastModifierID
     * @return \dgsoft\StructType\DgVehicleReservationType
     */
    public function setLastModifierID($lastModifierID = null)
    {
        // validation for constraint: string
        if (!is_null($lastModifierID) && !is_string($lastModifierID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($lastModifierID)), __LINE__);
        }
        $this->LastModifierID = $lastModifierID;
        return $this;
    }
    /**
     * Get PurgeDate value
     * @return string|null
     */
    public function getPurgeDate()
    {
        return $this->PurgeDate;
    }
    /**
     * Set PurgeDate value
     * @param string $purgeDate
     * @return \dgsoft\StructType\DgVehicleReservationType
     */
    public function setPurgeDate($purgeDate = null)
    {
        // validation for constraint: string
        if (!is_null($purgeDate) && !is_string($purgeDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($purgeDate)), __LINE__);
        }
        $this->PurgeDate = $purgeDate;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\StructType\DgVehicleReservationType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
