<?php

namespace dgsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for VehicleReservationRQCoreTypeQueue StructType
 * @package Dg
 * @subpackage Structs
 */
class DgVehicleReservationRQCoreTypeQueue extends AbstractStructBase
{
    /**
     * The PseudoCityCode
     * @var string
     */
    public $PseudoCityCode;
    /**
     * The QueueNumber
     * @var string
     */
    public $QueueNumber;
    /**
     * The QueueCategory
     * @var string
     */
    public $QueueCategory;
    /**
     * The SystemCode
     * @var string
     */
    public $SystemCode;
    /**
     * The QueueID
     * @var string
     */
    public $QueueID;
    /**
     * Constructor method for VehicleReservationRQCoreTypeQueue
     * @uses DgVehicleReservationRQCoreTypeQueue::setPseudoCityCode()
     * @uses DgVehicleReservationRQCoreTypeQueue::setQueueNumber()
     * @uses DgVehicleReservationRQCoreTypeQueue::setQueueCategory()
     * @uses DgVehicleReservationRQCoreTypeQueue::setSystemCode()
     * @uses DgVehicleReservationRQCoreTypeQueue::setQueueID()
     * @param string $pseudoCityCode
     * @param string $queueNumber
     * @param string $queueCategory
     * @param string $systemCode
     * @param string $queueID
     */
    public function __construct($pseudoCityCode = null, $queueNumber = null, $queueCategory = null, $systemCode = null, $queueID = null)
    {
        $this
            ->setPseudoCityCode($pseudoCityCode)
            ->setQueueNumber($queueNumber)
            ->setQueueCategory($queueCategory)
            ->setSystemCode($systemCode)
            ->setQueueID($queueID);
    }
    /**
     * Get PseudoCityCode value
     * @return string|null
     */
    public function getPseudoCityCode()
    {
        return $this->PseudoCityCode;
    }
    /**
     * Set PseudoCityCode value
     * @param string $pseudoCityCode
     * @return \dgsoft\StructType\DgVehicleReservationRQCoreTypeQueue
     */
    public function setPseudoCityCode($pseudoCityCode = null)
    {
        // validation for constraint: string
        if (!is_null($pseudoCityCode) && !is_string($pseudoCityCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($pseudoCityCode)), __LINE__);
        }
        $this->PseudoCityCode = $pseudoCityCode;
        return $this;
    }
    /**
     * Get QueueNumber value
     * @return string|null
     */
    public function getQueueNumber()
    {
        return $this->QueueNumber;
    }
    /**
     * Set QueueNumber value
     * @param string $queueNumber
     * @return \dgsoft\StructType\DgVehicleReservationRQCoreTypeQueue
     */
    public function setQueueNumber($queueNumber = null)
    {
        // validation for constraint: string
        if (!is_null($queueNumber) && !is_string($queueNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($queueNumber)), __LINE__);
        }
        $this->QueueNumber = $queueNumber;
        return $this;
    }
    /**
     * Get QueueCategory value
     * @return string|null
     */
    public function getQueueCategory()
    {
        return $this->QueueCategory;
    }
    /**
     * Set QueueCategory value
     * @param string $queueCategory
     * @return \dgsoft\StructType\DgVehicleReservationRQCoreTypeQueue
     */
    public function setQueueCategory($queueCategory = null)
    {
        // validation for constraint: string
        if (!is_null($queueCategory) && !is_string($queueCategory)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($queueCategory)), __LINE__);
        }
        $this->QueueCategory = $queueCategory;
        return $this;
    }
    /**
     * Get SystemCode value
     * @return string|null
     */
    public function getSystemCode()
    {
        return $this->SystemCode;
    }
    /**
     * Set SystemCode value
     * @param string $systemCode
     * @return \dgsoft\StructType\DgVehicleReservationRQCoreTypeQueue
     */
    public function setSystemCode($systemCode = null)
    {
        // validation for constraint: string
        if (!is_null($systemCode) && !is_string($systemCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($systemCode)), __LINE__);
        }
        $this->SystemCode = $systemCode;
        return $this;
    }
    /**
     * Get QueueID value
     * @return string|null
     */
    public function getQueueID()
    {
        return $this->QueueID;
    }
    /**
     * Set QueueID value
     * @param string $queueID
     * @return \dgsoft\StructType\DgVehicleReservationRQCoreTypeQueue
     */
    public function setQueueID($queueID = null)
    {
        // validation for constraint: string
        if (!is_null($queueID) && !is_string($queueID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($queueID)), __LINE__);
        }
        $this->QueueID = $queueID;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\StructType\DgVehicleReservationRQCoreTypeQueue
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
