<?php

namespace dgsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for VehicleReservationRQCoreType StructType
 * @package Dg
 * @subpackage Structs
 */
class DgVehicleReservationRQCoreType extends AbstractStructBase
{
    /**
     * The UniqueID
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgUniqueID_Type[]
     */
    public $UniqueID;
    /**
     * The VehRentalCore
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgVehicleRentalCoreType
     */
    public $VehRentalCore;
    /**
     * The Customer
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgCustomerPrimaryAdditionalType
     */
    public $Customer;
    /**
     * The VendorPref
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgCompanyNamePrefType
     */
    public $VendorPref;
    /**
     * The VehPref
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgVehiclePrefType
     */
    public $VehPref;
    /**
     * The DriverType
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgVehicleReservationRQCoreTypeDriverType[]
     */
    public $DriverType;
    /**
     * The RateQualifier
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgRateQualifierType
     */
    public $RateQualifier;
    /**
     * The Fees
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\ArrayType\DgArrayOfVehicleChargePurposeType1
     */
    public $Fees;
    /**
     * The VehicleCharges
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\ArrayType\DgArrayOfVehicleChargePurposeType
     */
    public $VehicleCharges;
    /**
     * The SpecialEquipPrefs
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgVehicleReservationRQCoreTypeSpecialEquipPrefs
     */
    public $SpecialEquipPrefs;
    /**
     * The RateDistance
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgVehicleReservationRQCoreTypeRateDistance[]
     */
    public $RateDistance;
    /**
     * The TotalCharge
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgVehicleReservationRQCoreTypeTotalCharge
     */
    public $TotalCharge;
    /**
     * The Queue
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgVehicleReservationRQCoreTypeQueue
     */
    public $Queue;
    /**
     * The TPA_Extensions
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgTPA_ExtensionsType
     */
    public $TPA_Extensions;
    /**
     * The Status
     * @var string
     */
    public $Status;
    /**
     * Constructor method for VehicleReservationRQCoreType
     * @uses DgVehicleReservationRQCoreType::setUniqueID()
     * @uses DgVehicleReservationRQCoreType::setVehRentalCore()
     * @uses DgVehicleReservationRQCoreType::setCustomer()
     * @uses DgVehicleReservationRQCoreType::setVendorPref()
     * @uses DgVehicleReservationRQCoreType::setVehPref()
     * @uses DgVehicleReservationRQCoreType::setDriverType()
     * @uses DgVehicleReservationRQCoreType::setRateQualifier()
     * @uses DgVehicleReservationRQCoreType::setFees()
     * @uses DgVehicleReservationRQCoreType::setVehicleCharges()
     * @uses DgVehicleReservationRQCoreType::setSpecialEquipPrefs()
     * @uses DgVehicleReservationRQCoreType::setRateDistance()
     * @uses DgVehicleReservationRQCoreType::setTotalCharge()
     * @uses DgVehicleReservationRQCoreType::setQueue()
     * @uses DgVehicleReservationRQCoreType::setTPA_Extensions()
     * @uses DgVehicleReservationRQCoreType::setStatus()
     * @param \dgsoft\StructType\DgUniqueID_Type[] $uniqueID
     * @param \dgsoft\StructType\DgVehicleRentalCoreType $vehRentalCore
     * @param \dgsoft\StructType\DgCustomerPrimaryAdditionalType $customer
     * @param \dgsoft\StructType\DgCompanyNamePrefType $vendorPref
     * @param \dgsoft\StructType\DgVehiclePrefType $vehPref
     * @param \dgsoft\StructType\DgVehicleReservationRQCoreTypeDriverType[] $driverType
     * @param \dgsoft\StructType\DgRateQualifierType $rateQualifier
     * @param \dgsoft\ArrayType\DgArrayOfVehicleChargePurposeType1 $fees
     * @param \dgsoft\ArrayType\DgArrayOfVehicleChargePurposeType $vehicleCharges
     * @param \dgsoft\StructType\DgVehicleReservationRQCoreTypeSpecialEquipPrefs $specialEquipPrefs
     * @param \dgsoft\StructType\DgVehicleReservationRQCoreTypeRateDistance[] $rateDistance
     * @param \dgsoft\StructType\DgVehicleReservationRQCoreTypeTotalCharge $totalCharge
     * @param \dgsoft\StructType\DgVehicleReservationRQCoreTypeQueue $queue
     * @param \dgsoft\StructType\DgTPA_ExtensionsType $tPA_Extensions
     * @param string $status
     */
    public function __construct(array $uniqueID = array(), \dgsoft\StructType\DgVehicleRentalCoreType $vehRentalCore = null, \dgsoft\StructType\DgCustomerPrimaryAdditionalType $customer = null, \dgsoft\StructType\DgCompanyNamePrefType $vendorPref = null, \dgsoft\StructType\DgVehiclePrefType $vehPref = null, array $driverType = array(), \dgsoft\StructType\DgRateQualifierType $rateQualifier = null, \dgsoft\ArrayType\DgArrayOfVehicleChargePurposeType1 $fees = null, \dgsoft\ArrayType\DgArrayOfVehicleChargePurposeType $vehicleCharges = null, \dgsoft\StructType\DgVehicleReservationRQCoreTypeSpecialEquipPrefs $specialEquipPrefs = null, array $rateDistance = array(), \dgsoft\StructType\DgVehicleReservationRQCoreTypeTotalCharge $totalCharge = null, \dgsoft\StructType\DgVehicleReservationRQCoreTypeQueue $queue = null, \dgsoft\StructType\DgTPA_ExtensionsType $tPA_Extensions = null, $status = null)
    {
        $this
            ->setUniqueID($uniqueID)
            ->setVehRentalCore($vehRentalCore)
            ->setCustomer($customer)
            ->setVendorPref($vendorPref)
            ->setVehPref($vehPref)
            ->setDriverType($driverType)
            ->setRateQualifier($rateQualifier)
            ->setFees($fees)
            ->setVehicleCharges($vehicleCharges)
            ->setSpecialEquipPrefs($specialEquipPrefs)
            ->setRateDistance($rateDistance)
            ->setTotalCharge($totalCharge)
            ->setQueue($queue)
            ->setTPA_Extensions($tPA_Extensions)
            ->setStatus($status);
    }
    /**
     * Get UniqueID value
     * @return \dgsoft\StructType\DgUniqueID_Type[]|null
     */
    public function getUniqueID()
    {
        return $this->UniqueID;
    }
    /**
     * Set UniqueID value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgUniqueID_Type[] $uniqueID
     * @return \dgsoft\StructType\DgVehicleReservationRQCoreType
     */
    public function setUniqueID(array $uniqueID = array())
    {
        foreach ($uniqueID as $vehicleReservationRQCoreTypeUniqueIDItem) {
            // validation for constraint: itemType
            if (!$vehicleReservationRQCoreTypeUniqueIDItem instanceof \dgsoft\StructType\DgUniqueID_Type) {
                throw new \InvalidArgumentException(sprintf('The UniqueID property can only contain items of \dgsoft\StructType\DgUniqueID_Type, "%s" given', is_object($vehicleReservationRQCoreTypeUniqueIDItem) ? get_class($vehicleReservationRQCoreTypeUniqueIDItem) : gettype($vehicleReservationRQCoreTypeUniqueIDItem)), __LINE__);
            }
        }
        $this->UniqueID = $uniqueID;
        return $this;
    }
    /**
     * Add item to UniqueID value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgUniqueID_Type $item
     * @return \dgsoft\StructType\DgVehicleReservationRQCoreType
     */
    public function addToUniqueID(\dgsoft\StructType\DgUniqueID_Type $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \dgsoft\StructType\DgUniqueID_Type) {
            throw new \InvalidArgumentException(sprintf('The UniqueID property can only contain items of \dgsoft\StructType\DgUniqueID_Type, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->UniqueID[] = $item;
        return $this;
    }
    /**
     * Get VehRentalCore value
     * @return \dgsoft\StructType\DgVehicleRentalCoreType|null
     */
    public function getVehRentalCore()
    {
        return $this->VehRentalCore;
    }
    /**
     * Set VehRentalCore value
     * @param \dgsoft\StructType\DgVehicleRentalCoreType $vehRentalCore
     * @return \dgsoft\StructType\DgVehicleReservationRQCoreType
     */
    public function setVehRentalCore(\dgsoft\StructType\DgVehicleRentalCoreType $vehRentalCore = null)
    {
        $this->VehRentalCore = $vehRentalCore;
        return $this;
    }
    /**
     * Get Customer value
     * @return \dgsoft\StructType\DgCustomerPrimaryAdditionalType|null
     */
    public function getCustomer()
    {
        return $this->Customer;
    }
    /**
     * Set Customer value
     * @param \dgsoft\StructType\DgCustomerPrimaryAdditionalType $customer
     * @return \dgsoft\StructType\DgVehicleReservationRQCoreType
     */
    public function setCustomer(\dgsoft\StructType\DgCustomerPrimaryAdditionalType $customer = null)
    {
        $this->Customer = $customer;
        return $this;
    }
    /**
     * Get VendorPref value
     * @return \dgsoft\StructType\DgCompanyNamePrefType|null
     */
    public function getVendorPref()
    {
        return $this->VendorPref;
    }
    /**
     * Set VendorPref value
     * @param \dgsoft\StructType\DgCompanyNamePrefType $vendorPref
     * @return \dgsoft\StructType\DgVehicleReservationRQCoreType
     */
    public function setVendorPref(\dgsoft\StructType\DgCompanyNamePrefType $vendorPref = null)
    {
        $this->VendorPref = $vendorPref;
        return $this;
    }
    /**
     * Get VehPref value
     * @return \dgsoft\StructType\DgVehiclePrefType|null
     */
    public function getVehPref()
    {
        return $this->VehPref;
    }
    /**
     * Set VehPref value
     * @param \dgsoft\StructType\DgVehiclePrefType $vehPref
     * @return \dgsoft\StructType\DgVehicleReservationRQCoreType
     */
    public function setVehPref(\dgsoft\StructType\DgVehiclePrefType $vehPref = null)
    {
        $this->VehPref = $vehPref;
        return $this;
    }
    /**
     * Get DriverType value
     * @return \dgsoft\StructType\DgVehicleReservationRQCoreTypeDriverType[]|null
     */
    public function getDriverType()
    {
        return $this->DriverType;
    }
    /**
     * Set DriverType value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgVehicleReservationRQCoreTypeDriverType[] $driverType
     * @return \dgsoft\StructType\DgVehicleReservationRQCoreType
     */
    public function setDriverType(array $driverType = array())
    {
        foreach ($driverType as $vehicleReservationRQCoreTypeDriverTypeItem) {
            // validation for constraint: itemType
            if (!$vehicleReservationRQCoreTypeDriverTypeItem instanceof \dgsoft\StructType\DgVehicleReservationRQCoreTypeDriverType) {
                throw new \InvalidArgumentException(sprintf('The DriverType property can only contain items of \dgsoft\StructType\DgVehicleReservationRQCoreTypeDriverType, "%s" given', is_object($vehicleReservationRQCoreTypeDriverTypeItem) ? get_class($vehicleReservationRQCoreTypeDriverTypeItem) : gettype($vehicleReservationRQCoreTypeDriverTypeItem)), __LINE__);
            }
        }
        $this->DriverType = $driverType;
        return $this;
    }
    /**
     * Add item to DriverType value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgVehicleReservationRQCoreTypeDriverType $item
     * @return \dgsoft\StructType\DgVehicleReservationRQCoreType
     */
    public function addToDriverType(\dgsoft\StructType\DgVehicleReservationRQCoreTypeDriverType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \dgsoft\StructType\DgVehicleReservationRQCoreTypeDriverType) {
            throw new \InvalidArgumentException(sprintf('The DriverType property can only contain items of \dgsoft\StructType\DgVehicleReservationRQCoreTypeDriverType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->DriverType[] = $item;
        return $this;
    }
    /**
     * Get RateQualifier value
     * @return \dgsoft\StructType\DgRateQualifierType|null
     */
    public function getRateQualifier()
    {
        return $this->RateQualifier;
    }
    /**
     * Set RateQualifier value
     * @param \dgsoft\StructType\DgRateQualifierType $rateQualifier
     * @return \dgsoft\StructType\DgVehicleReservationRQCoreType
     */
    public function setRateQualifier(\dgsoft\StructType\DgRateQualifierType $rateQualifier = null)
    {
        $this->RateQualifier = $rateQualifier;
        return $this;
    }
    /**
     * Get Fees value
     * @return \dgsoft\ArrayType\DgArrayOfVehicleChargePurposeType1|null
     */
    public function getFees()
    {
        return $this->Fees;
    }
    /**
     * Set Fees value
     * @param \dgsoft\ArrayType\DgArrayOfVehicleChargePurposeType1 $fees
     * @return \dgsoft\StructType\DgVehicleReservationRQCoreType
     */
    public function setFees(\dgsoft\ArrayType\DgArrayOfVehicleChargePurposeType1 $fees = null)
    {
        $this->Fees = $fees;
        return $this;
    }
    /**
     * Get VehicleCharges value
     * @return \dgsoft\ArrayType\DgArrayOfVehicleChargePurposeType|null
     */
    public function getVehicleCharges()
    {
        return $this->VehicleCharges;
    }
    /**
     * Set VehicleCharges value
     * @param \dgsoft\ArrayType\DgArrayOfVehicleChargePurposeType $vehicleCharges
     * @return \dgsoft\StructType\DgVehicleReservationRQCoreType
     */
    public function setVehicleCharges(\dgsoft\ArrayType\DgArrayOfVehicleChargePurposeType $vehicleCharges = null)
    {
        $this->VehicleCharges = $vehicleCharges;
        return $this;
    }
    /**
     * Get SpecialEquipPrefs value
     * @return \dgsoft\StructType\DgVehicleReservationRQCoreTypeSpecialEquipPrefs|null
     */
    public function getSpecialEquipPrefs()
    {
        return $this->SpecialEquipPrefs;
    }
    /**
     * Set SpecialEquipPrefs value
     * @param \dgsoft\StructType\DgVehicleReservationRQCoreTypeSpecialEquipPrefs $specialEquipPrefs
     * @return \dgsoft\StructType\DgVehicleReservationRQCoreType
     */
    public function setSpecialEquipPrefs(\dgsoft\StructType\DgVehicleReservationRQCoreTypeSpecialEquipPrefs $specialEquipPrefs = null)
    {
        $this->SpecialEquipPrefs = $specialEquipPrefs;
        return $this;
    }
    /**
     * Get RateDistance value
     * @return \dgsoft\StructType\DgVehicleReservationRQCoreTypeRateDistance[]|null
     */
    public function getRateDistance()
    {
        return $this->RateDistance;
    }
    /**
     * Set RateDistance value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgVehicleReservationRQCoreTypeRateDistance[] $rateDistance
     * @return \dgsoft\StructType\DgVehicleReservationRQCoreType
     */
    public function setRateDistance(array $rateDistance = array())
    {
        foreach ($rateDistance as $vehicleReservationRQCoreTypeRateDistanceItem) {
            // validation for constraint: itemType
            if (!$vehicleReservationRQCoreTypeRateDistanceItem instanceof \dgsoft\StructType\DgVehicleReservationRQCoreTypeRateDistance) {
                throw new \InvalidArgumentException(sprintf('The RateDistance property can only contain items of \dgsoft\StructType\DgVehicleReservationRQCoreTypeRateDistance, "%s" given', is_object($vehicleReservationRQCoreTypeRateDistanceItem) ? get_class($vehicleReservationRQCoreTypeRateDistanceItem) : gettype($vehicleReservationRQCoreTypeRateDistanceItem)), __LINE__);
            }
        }
        $this->RateDistance = $rateDistance;
        return $this;
    }
    /**
     * Add item to RateDistance value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgVehicleReservationRQCoreTypeRateDistance $item
     * @return \dgsoft\StructType\DgVehicleReservationRQCoreType
     */
    public function addToRateDistance(\dgsoft\StructType\DgVehicleReservationRQCoreTypeRateDistance $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \dgsoft\StructType\DgVehicleReservationRQCoreTypeRateDistance) {
            throw new \InvalidArgumentException(sprintf('The RateDistance property can only contain items of \dgsoft\StructType\DgVehicleReservationRQCoreTypeRateDistance, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->RateDistance[] = $item;
        return $this;
    }
    /**
     * Get TotalCharge value
     * @return \dgsoft\StructType\DgVehicleReservationRQCoreTypeTotalCharge|null
     */
    public function getTotalCharge()
    {
        return $this->TotalCharge;
    }
    /**
     * Set TotalCharge value
     * @param \dgsoft\StructType\DgVehicleReservationRQCoreTypeTotalCharge $totalCharge
     * @return \dgsoft\StructType\DgVehicleReservationRQCoreType
     */
    public function setTotalCharge(\dgsoft\StructType\DgVehicleReservationRQCoreTypeTotalCharge $totalCharge = null)
    {
        $this->TotalCharge = $totalCharge;
        return $this;
    }
    /**
     * Get Queue value
     * @return \dgsoft\StructType\DgVehicleReservationRQCoreTypeQueue|null
     */
    public function getQueue()
    {
        return $this->Queue;
    }
    /**
     * Set Queue value
     * @param \dgsoft\StructType\DgVehicleReservationRQCoreTypeQueue $queue
     * @return \dgsoft\StructType\DgVehicleReservationRQCoreType
     */
    public function setQueue(\dgsoft\StructType\DgVehicleReservationRQCoreTypeQueue $queue = null)
    {
        $this->Queue = $queue;
        return $this;
    }
    /**
     * Get TPA_Extensions value
     * @return \dgsoft\StructType\DgTPA_ExtensionsType|null
     */
    public function getTPA_Extensions()
    {
        return $this->TPA_Extensions;
    }
    /**
     * Set TPA_Extensions value
     * @param \dgsoft\StructType\DgTPA_ExtensionsType $tPA_Extensions
     * @return \dgsoft\StructType\DgVehicleReservationRQCoreType
     */
    public function setTPA_Extensions(\dgsoft\StructType\DgTPA_ExtensionsType $tPA_Extensions = null)
    {
        $this->TPA_Extensions = $tPA_Extensions;
        return $this;
    }
    /**
     * Get Status value
     * @return string|null
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @param string $status
     * @return \dgsoft\StructType\DgVehicleReservationRQCoreType
     */
    public function setStatus($status = null)
    {
        // validation for constraint: string
        if (!is_null($status) && !is_string($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($status)), __LINE__);
        }
        $this->Status = $status;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\StructType\DgVehicleReservationRQCoreType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
