<?php

namespace dgsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for VehicleReservationRQAdditionalInfoType StructType
 * @package Dg
 * @subpackage Structs
 */
class DgVehicleReservationRQAdditionalInfoType extends AbstractStructBase
{
    /**
     * The SpecialReqPref
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgVehicleSpecialReqPrefType[]
     */
    public $SpecialReqPref;
    /**
     * The CoveragePrefs
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\ArrayType\DgArrayOfVehicleReservationRQAdditionalInfoTypeCoveragePref
     */
    public $CoveragePrefs;
    /**
     * The OffLocService
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgOffLocationServiceType[]
     */
    public $OffLocService;
    /**
     * The ArrivalDetails
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgVehicleArrivalDetailsType
     */
    public $ArrivalDetails;
    /**
     * The RentalPaymentPref
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgVehicleReservationRQAdditionalInfoTypeRentalPaymentPref[]
     */
    public $RentalPaymentPref;
    /**
     * The Reference
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgVehicleReservationRQAdditionalInfoTypeReference
     */
    public $Reference;
    /**
     * The TourInfo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgVehicleTourInfoType
     */
    public $TourInfo;
    /**
     * The WrittenConfInst
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgWrittenConfInstType
     */
    public $WrittenConfInst;
    /**
     * The TPA_Extensions
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgTPA_ExtensionsType
     */
    public $TPA_Extensions;
    /**
     * The LuggageQty
     * @var int
     */
    public $LuggageQty;
    /**
     * The PassengerQty
     * @var int
     */
    public $PassengerQty;
    /**
     * The SmokingAllowed
     * Meta informations extracted from the WSDL
     * - default: false
     * @var bool
     */
    public $SmokingAllowed;
    /**
     * The GasPrePay
     * Meta informations extracted from the WSDL
     * - default: false
     * @var bool
     */
    public $GasPrePay;
    /**
     * Constructor method for VehicleReservationRQAdditionalInfoType
     * @uses DgVehicleReservationRQAdditionalInfoType::setSpecialReqPref()
     * @uses DgVehicleReservationRQAdditionalInfoType::setCoveragePrefs()
     * @uses DgVehicleReservationRQAdditionalInfoType::setOffLocService()
     * @uses DgVehicleReservationRQAdditionalInfoType::setArrivalDetails()
     * @uses DgVehicleReservationRQAdditionalInfoType::setRentalPaymentPref()
     * @uses DgVehicleReservationRQAdditionalInfoType::setReference()
     * @uses DgVehicleReservationRQAdditionalInfoType::setTourInfo()
     * @uses DgVehicleReservationRQAdditionalInfoType::setWrittenConfInst()
     * @uses DgVehicleReservationRQAdditionalInfoType::setTPA_Extensions()
     * @uses DgVehicleReservationRQAdditionalInfoType::setLuggageQty()
     * @uses DgVehicleReservationRQAdditionalInfoType::setPassengerQty()
     * @uses DgVehicleReservationRQAdditionalInfoType::setSmokingAllowed()
     * @uses DgVehicleReservationRQAdditionalInfoType::setGasPrePay()
     * @param \dgsoft\StructType\DgVehicleSpecialReqPrefType[] $specialReqPref
     * @param \dgsoft\ArrayType\DgArrayOfVehicleReservationRQAdditionalInfoTypeCoveragePref $coveragePrefs
     * @param \dgsoft\StructType\DgOffLocationServiceType[] $offLocService
     * @param \dgsoft\StructType\DgVehicleArrivalDetailsType $arrivalDetails
     * @param \dgsoft\StructType\DgVehicleReservationRQAdditionalInfoTypeRentalPaymentPref[] $rentalPaymentPref
     * @param \dgsoft\StructType\DgVehicleReservationRQAdditionalInfoTypeReference $reference
     * @param \dgsoft\StructType\DgVehicleTourInfoType $tourInfo
     * @param \dgsoft\StructType\DgWrittenConfInstType $writtenConfInst
     * @param \dgsoft\StructType\DgTPA_ExtensionsType $tPA_Extensions
     * @param int $luggageQty
     * @param int $passengerQty
     * @param bool $smokingAllowed
     * @param bool $gasPrePay
     */
    public function __construct(array $specialReqPref = array(), \dgsoft\ArrayType\DgArrayOfVehicleReservationRQAdditionalInfoTypeCoveragePref $coveragePrefs = null, array $offLocService = array(), \dgsoft\StructType\DgVehicleArrivalDetailsType $arrivalDetails = null, array $rentalPaymentPref = array(), \dgsoft\StructType\DgVehicleReservationRQAdditionalInfoTypeReference $reference = null, \dgsoft\StructType\DgVehicleTourInfoType $tourInfo = null, \dgsoft\StructType\DgWrittenConfInstType $writtenConfInst = null, \dgsoft\StructType\DgTPA_ExtensionsType $tPA_Extensions = null, $luggageQty = null, $passengerQty = null, $smokingAllowed = false, $gasPrePay = false)
    {
        $this
            ->setSpecialReqPref($specialReqPref)
            ->setCoveragePrefs($coveragePrefs)
            ->setOffLocService($offLocService)
            ->setArrivalDetails($arrivalDetails)
            ->setRentalPaymentPref($rentalPaymentPref)
            ->setReference($reference)
            ->setTourInfo($tourInfo)
            ->setWrittenConfInst($writtenConfInst)
            ->setTPA_Extensions($tPA_Extensions)
            ->setLuggageQty($luggageQty)
            ->setPassengerQty($passengerQty)
            ->setSmokingAllowed($smokingAllowed)
            ->setGasPrePay($gasPrePay);
    }
    /**
     * Get SpecialReqPref value
     * @return \dgsoft\StructType\DgVehicleSpecialReqPrefType[]|null
     */
    public function getSpecialReqPref()
    {
        return $this->SpecialReqPref;
    }
    /**
     * Set SpecialReqPref value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgVehicleSpecialReqPrefType[] $specialReqPref
     * @return \dgsoft\StructType\DgVehicleReservationRQAdditionalInfoType
     */
    public function setSpecialReqPref(array $specialReqPref = array())
    {
        foreach ($specialReqPref as $vehicleReservationRQAdditionalInfoTypeSpecialReqPrefItem) {
            // validation for constraint: itemType
            if (!$vehicleReservationRQAdditionalInfoTypeSpecialReqPrefItem instanceof \dgsoft\StructType\DgVehicleSpecialReqPrefType) {
                throw new \InvalidArgumentException(sprintf('The SpecialReqPref property can only contain items of \dgsoft\StructType\DgVehicleSpecialReqPrefType, "%s" given', is_object($vehicleReservationRQAdditionalInfoTypeSpecialReqPrefItem) ? get_class($vehicleReservationRQAdditionalInfoTypeSpecialReqPrefItem) : gettype($vehicleReservationRQAdditionalInfoTypeSpecialReqPrefItem)), __LINE__);
            }
        }
        $this->SpecialReqPref = $specialReqPref;
        return $this;
    }
    /**
     * Add item to SpecialReqPref value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgVehicleSpecialReqPrefType $item
     * @return \dgsoft\StructType\DgVehicleReservationRQAdditionalInfoType
     */
    public function addToSpecialReqPref(\dgsoft\StructType\DgVehicleSpecialReqPrefType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \dgsoft\StructType\DgVehicleSpecialReqPrefType) {
            throw new \InvalidArgumentException(sprintf('The SpecialReqPref property can only contain items of \dgsoft\StructType\DgVehicleSpecialReqPrefType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->SpecialReqPref[] = $item;
        return $this;
    }
    /**
     * Get CoveragePrefs value
     * @return \dgsoft\ArrayType\DgArrayOfVehicleReservationRQAdditionalInfoTypeCoveragePref|null
     */
    public function getCoveragePrefs()
    {
        return $this->CoveragePrefs;
    }
    /**
     * Set CoveragePrefs value
     * @param \dgsoft\ArrayType\DgArrayOfVehicleReservationRQAdditionalInfoTypeCoveragePref $coveragePrefs
     * @return \dgsoft\StructType\DgVehicleReservationRQAdditionalInfoType
     */
    public function setCoveragePrefs(\dgsoft\ArrayType\DgArrayOfVehicleReservationRQAdditionalInfoTypeCoveragePref $coveragePrefs = null)
    {
        $this->CoveragePrefs = $coveragePrefs;
        return $this;
    }
    /**
     * Get OffLocService value
     * @return \dgsoft\StructType\DgOffLocationServiceType[]|null
     */
    public function getOffLocService()
    {
        return $this->OffLocService;
    }
    /**
     * Set OffLocService value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgOffLocationServiceType[] $offLocService
     * @return \dgsoft\StructType\DgVehicleReservationRQAdditionalInfoType
     */
    public function setOffLocService(array $offLocService = array())
    {
        foreach ($offLocService as $vehicleReservationRQAdditionalInfoTypeOffLocServiceItem) {
            // validation for constraint: itemType
            if (!$vehicleReservationRQAdditionalInfoTypeOffLocServiceItem instanceof \dgsoft\StructType\DgOffLocationServiceType) {
                throw new \InvalidArgumentException(sprintf('The OffLocService property can only contain items of \dgsoft\StructType\DgOffLocationServiceType, "%s" given', is_object($vehicleReservationRQAdditionalInfoTypeOffLocServiceItem) ? get_class($vehicleReservationRQAdditionalInfoTypeOffLocServiceItem) : gettype($vehicleReservationRQAdditionalInfoTypeOffLocServiceItem)), __LINE__);
            }
        }
        $this->OffLocService = $offLocService;
        return $this;
    }
    /**
     * Add item to OffLocService value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgOffLocationServiceType $item
     * @return \dgsoft\StructType\DgVehicleReservationRQAdditionalInfoType
     */
    public function addToOffLocService(\dgsoft\StructType\DgOffLocationServiceType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \dgsoft\StructType\DgOffLocationServiceType) {
            throw new \InvalidArgumentException(sprintf('The OffLocService property can only contain items of \dgsoft\StructType\DgOffLocationServiceType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->OffLocService[] = $item;
        return $this;
    }
    /**
     * Get ArrivalDetails value
     * @return \dgsoft\StructType\DgVehicleArrivalDetailsType|null
     */
    public function getArrivalDetails()
    {
        return $this->ArrivalDetails;
    }
    /**
     * Set ArrivalDetails value
     * @param \dgsoft\StructType\DgVehicleArrivalDetailsType $arrivalDetails
     * @return \dgsoft\StructType\DgVehicleReservationRQAdditionalInfoType
     */
    public function setArrivalDetails(\dgsoft\StructType\DgVehicleArrivalDetailsType $arrivalDetails = null)
    {
        $this->ArrivalDetails = $arrivalDetails;
        return $this;
    }
    /**
     * Get RentalPaymentPref value
     * @return \dgsoft\StructType\DgVehicleReservationRQAdditionalInfoTypeRentalPaymentPref[]|null
     */
    public function getRentalPaymentPref()
    {
        return $this->RentalPaymentPref;
    }
    /**
     * Set RentalPaymentPref value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgVehicleReservationRQAdditionalInfoTypeRentalPaymentPref[] $rentalPaymentPref
     * @return \dgsoft\StructType\DgVehicleReservationRQAdditionalInfoType
     */
    public function setRentalPaymentPref(array $rentalPaymentPref = array())
    {
        foreach ($rentalPaymentPref as $vehicleReservationRQAdditionalInfoTypeRentalPaymentPrefItem) {
            // validation for constraint: itemType
            if (!$vehicleReservationRQAdditionalInfoTypeRentalPaymentPrefItem instanceof \dgsoft\StructType\DgVehicleReservationRQAdditionalInfoTypeRentalPaymentPref) {
                throw new \InvalidArgumentException(sprintf('The RentalPaymentPref property can only contain items of \dgsoft\StructType\DgVehicleReservationRQAdditionalInfoTypeRentalPaymentPref, "%s" given', is_object($vehicleReservationRQAdditionalInfoTypeRentalPaymentPrefItem) ? get_class($vehicleReservationRQAdditionalInfoTypeRentalPaymentPrefItem) : gettype($vehicleReservationRQAdditionalInfoTypeRentalPaymentPrefItem)), __LINE__);
            }
        }
        $this->RentalPaymentPref = $rentalPaymentPref;
        return $this;
    }
    /**
     * Add item to RentalPaymentPref value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgVehicleReservationRQAdditionalInfoTypeRentalPaymentPref $item
     * @return \dgsoft\StructType\DgVehicleReservationRQAdditionalInfoType
     */
    public function addToRentalPaymentPref(\dgsoft\StructType\DgVehicleReservationRQAdditionalInfoTypeRentalPaymentPref $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \dgsoft\StructType\DgVehicleReservationRQAdditionalInfoTypeRentalPaymentPref) {
            throw new \InvalidArgumentException(sprintf('The RentalPaymentPref property can only contain items of \dgsoft\StructType\DgVehicleReservationRQAdditionalInfoTypeRentalPaymentPref, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->RentalPaymentPref[] = $item;
        return $this;
    }
    /**
     * Get Reference value
     * @return \dgsoft\StructType\DgVehicleReservationRQAdditionalInfoTypeReference|null
     */
    public function getReference()
    {
        return $this->Reference;
    }
    /**
     * Set Reference value
     * @param \dgsoft\StructType\DgVehicleReservationRQAdditionalInfoTypeReference $reference
     * @return \dgsoft\StructType\DgVehicleReservationRQAdditionalInfoType
     */
    public function setReference(\dgsoft\StructType\DgVehicleReservationRQAdditionalInfoTypeReference $reference = null)
    {
        $this->Reference = $reference;
        return $this;
    }
    /**
     * Get TourInfo value
     * @return \dgsoft\StructType\DgVehicleTourInfoType|null
     */
    public function getTourInfo()
    {
        return $this->TourInfo;
    }
    /**
     * Set TourInfo value
     * @param \dgsoft\StructType\DgVehicleTourInfoType $tourInfo
     * @return \dgsoft\StructType\DgVehicleReservationRQAdditionalInfoType
     */
    public function setTourInfo(\dgsoft\StructType\DgVehicleTourInfoType $tourInfo = null)
    {
        $this->TourInfo = $tourInfo;
        return $this;
    }
    /**
     * Get WrittenConfInst value
     * @return \dgsoft\StructType\DgWrittenConfInstType|null
     */
    public function getWrittenConfInst()
    {
        return $this->WrittenConfInst;
    }
    /**
     * Set WrittenConfInst value
     * @param \dgsoft\StructType\DgWrittenConfInstType $writtenConfInst
     * @return \dgsoft\StructType\DgVehicleReservationRQAdditionalInfoType
     */
    public function setWrittenConfInst(\dgsoft\StructType\DgWrittenConfInstType $writtenConfInst = null)
    {
        $this->WrittenConfInst = $writtenConfInst;
        return $this;
    }
    /**
     * Get TPA_Extensions value
     * @return \dgsoft\StructType\DgTPA_ExtensionsType|null
     */
    public function getTPA_Extensions()
    {
        return $this->TPA_Extensions;
    }
    /**
     * Set TPA_Extensions value
     * @param \dgsoft\StructType\DgTPA_ExtensionsType $tPA_Extensions
     * @return \dgsoft\StructType\DgVehicleReservationRQAdditionalInfoType
     */
    public function setTPA_Extensions(\dgsoft\StructType\DgTPA_ExtensionsType $tPA_Extensions = null)
    {
        $this->TPA_Extensions = $tPA_Extensions;
        return $this;
    }
    /**
     * Get LuggageQty value
     * @return int|null
     */
    public function getLuggageQty()
    {
        return $this->LuggageQty;
    }
    /**
     * Set LuggageQty value
     * @param int $luggageQty
     * @return \dgsoft\StructType\DgVehicleReservationRQAdditionalInfoType
     */
    public function setLuggageQty($luggageQty = null)
    {
        // validation for constraint: int
        if (!is_null($luggageQty) && !is_numeric($luggageQty)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($luggageQty)), __LINE__);
        }
        $this->LuggageQty = $luggageQty;
        return $this;
    }
    /**
     * Get PassengerQty value
     * @return int|null
     */
    public function getPassengerQty()
    {
        return $this->PassengerQty;
    }
    /**
     * Set PassengerQty value
     * @param int $passengerQty
     * @return \dgsoft\StructType\DgVehicleReservationRQAdditionalInfoType
     */
    public function setPassengerQty($passengerQty = null)
    {
        // validation for constraint: int
        if (!is_null($passengerQty) && !is_numeric($passengerQty)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($passengerQty)), __LINE__);
        }
        $this->PassengerQty = $passengerQty;
        return $this;
    }
    /**
     * Get SmokingAllowed value
     * @return bool|null
     */
    public function getSmokingAllowed()
    {
        return $this->SmokingAllowed;
    }
    /**
     * Set SmokingAllowed value
     * @param bool $smokingAllowed
     * @return \dgsoft\StructType\DgVehicleReservationRQAdditionalInfoType
     */
    public function setSmokingAllowed($smokingAllowed = false)
    {
        // validation for constraint: boolean
        if (!is_null($smokingAllowed) && !is_bool($smokingAllowed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($smokingAllowed)), __LINE__);
        }
        $this->SmokingAllowed = $smokingAllowed;
        return $this;
    }
    /**
     * Get GasPrePay value
     * @return bool|null
     */
    public function getGasPrePay()
    {
        return $this->GasPrePay;
    }
    /**
     * Set GasPrePay value
     * @param bool $gasPrePay
     * @return \dgsoft\StructType\DgVehicleReservationRQAdditionalInfoType
     */
    public function setGasPrePay($gasPrePay = false)
    {
        // validation for constraint: boolean
        if (!is_null($gasPrePay) && !is_bool($gasPrePay)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($gasPrePay)), __LINE__);
        }
        $this->GasPrePay = $gasPrePay;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\StructType\DgVehicleReservationRQAdditionalInfoType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
