<?php

namespace dgsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for VehicleRentalRateTypeRateRestrictions StructType
 * @package Dg
 * @subpackage Structs
 */
class DgVehicleRentalRateTypeRateRestrictions extends AbstractStructBase
{
    /**
     * The ArriveByFlight
     * Meta informations extracted from the WSDL
     * - default: false
     * @var bool
     */
    public $ArriveByFlight;
    /**
     * The MinimumDayInd
     * @var bool
     */
    public $MinimumDayInd;
    /**
     * The MaximumDayInd
     * @var bool
     */
    public $MaximumDayInd;
    /**
     * The AdvancedBookingInd
     * @var bool
     */
    public $AdvancedBookingInd;
    /**
     * The RestrictedMileageInd
     * @var bool
     */
    public $RestrictedMileageInd;
    /**
     * The CorporateRateInd
     * @var bool
     */
    public $CorporateRateInd;
    /**
     * The GuaranteeReqInd
     * @var bool
     */
    public $GuaranteeReqInd;
    /**
     * The MaximumVehiclesAllowed
     * @var int
     */
    public $MaximumVehiclesAllowed;
    /**
     * The OvernightInd
     * @var bool
     */
    public $OvernightInd;
    /**
     * The OneWayPolicy
     * @var string
     */
    public $OneWayPolicy;
    /**
     * The CancellationPenaltyInd
     * @var bool
     */
    public $CancellationPenaltyInd;
    /**
     * The ModificationPenaltyInd
     * @var bool
     */
    public $ModificationPenaltyInd;
    /**
     * Constructor method for VehicleRentalRateTypeRateRestrictions
     * @uses DgVehicleRentalRateTypeRateRestrictions::setArriveByFlight()
     * @uses DgVehicleRentalRateTypeRateRestrictions::setMinimumDayInd()
     * @uses DgVehicleRentalRateTypeRateRestrictions::setMaximumDayInd()
     * @uses DgVehicleRentalRateTypeRateRestrictions::setAdvancedBookingInd()
     * @uses DgVehicleRentalRateTypeRateRestrictions::setRestrictedMileageInd()
     * @uses DgVehicleRentalRateTypeRateRestrictions::setCorporateRateInd()
     * @uses DgVehicleRentalRateTypeRateRestrictions::setGuaranteeReqInd()
     * @uses DgVehicleRentalRateTypeRateRestrictions::setMaximumVehiclesAllowed()
     * @uses DgVehicleRentalRateTypeRateRestrictions::setOvernightInd()
     * @uses DgVehicleRentalRateTypeRateRestrictions::setOneWayPolicy()
     * @uses DgVehicleRentalRateTypeRateRestrictions::setCancellationPenaltyInd()
     * @uses DgVehicleRentalRateTypeRateRestrictions::setModificationPenaltyInd()
     * @param bool $arriveByFlight
     * @param bool $minimumDayInd
     * @param bool $maximumDayInd
     * @param bool $advancedBookingInd
     * @param bool $restrictedMileageInd
     * @param bool $corporateRateInd
     * @param bool $guaranteeReqInd
     * @param int $maximumVehiclesAllowed
     * @param bool $overnightInd
     * @param string $oneWayPolicy
     * @param bool $cancellationPenaltyInd
     * @param bool $modificationPenaltyInd
     */
    public function __construct($arriveByFlight = false, $minimumDayInd = null, $maximumDayInd = null, $advancedBookingInd = null, $restrictedMileageInd = null, $corporateRateInd = null, $guaranteeReqInd = null, $maximumVehiclesAllowed = null, $overnightInd = null, $oneWayPolicy = null, $cancellationPenaltyInd = null, $modificationPenaltyInd = null)
    {
        $this
            ->setArriveByFlight($arriveByFlight)
            ->setMinimumDayInd($minimumDayInd)
            ->setMaximumDayInd($maximumDayInd)
            ->setAdvancedBookingInd($advancedBookingInd)
            ->setRestrictedMileageInd($restrictedMileageInd)
            ->setCorporateRateInd($corporateRateInd)
            ->setGuaranteeReqInd($guaranteeReqInd)
            ->setMaximumVehiclesAllowed($maximumVehiclesAllowed)
            ->setOvernightInd($overnightInd)
            ->setOneWayPolicy($oneWayPolicy)
            ->setCancellationPenaltyInd($cancellationPenaltyInd)
            ->setModificationPenaltyInd($modificationPenaltyInd);
    }
    /**
     * Get ArriveByFlight value
     * @return bool|null
     */
    public function getArriveByFlight()
    {
        return $this->ArriveByFlight;
    }
    /**
     * Set ArriveByFlight value
     * @param bool $arriveByFlight
     * @return \dgsoft\StructType\DgVehicleRentalRateTypeRateRestrictions
     */
    public function setArriveByFlight($arriveByFlight = false)
    {
        // validation for constraint: boolean
        if (!is_null($arriveByFlight) && !is_bool($arriveByFlight)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($arriveByFlight)), __LINE__);
        }
        $this->ArriveByFlight = $arriveByFlight;
        return $this;
    }
    /**
     * Get MinimumDayInd value
     * @return bool|null
     */
    public function getMinimumDayInd()
    {
        return $this->MinimumDayInd;
    }
    /**
     * Set MinimumDayInd value
     * @param bool $minimumDayInd
     * @return \dgsoft\StructType\DgVehicleRentalRateTypeRateRestrictions
     */
    public function setMinimumDayInd($minimumDayInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($minimumDayInd) && !is_bool($minimumDayInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($minimumDayInd)), __LINE__);
        }
        $this->MinimumDayInd = $minimumDayInd;
        return $this;
    }
    /**
     * Get MaximumDayInd value
     * @return bool|null
     */
    public function getMaximumDayInd()
    {
        return $this->MaximumDayInd;
    }
    /**
     * Set MaximumDayInd value
     * @param bool $maximumDayInd
     * @return \dgsoft\StructType\DgVehicleRentalRateTypeRateRestrictions
     */
    public function setMaximumDayInd($maximumDayInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($maximumDayInd) && !is_bool($maximumDayInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($maximumDayInd)), __LINE__);
        }
        $this->MaximumDayInd = $maximumDayInd;
        return $this;
    }
    /**
     * Get AdvancedBookingInd value
     * @return bool|null
     */
    public function getAdvancedBookingInd()
    {
        return $this->AdvancedBookingInd;
    }
    /**
     * Set AdvancedBookingInd value
     * @param bool $advancedBookingInd
     * @return \dgsoft\StructType\DgVehicleRentalRateTypeRateRestrictions
     */
    public function setAdvancedBookingInd($advancedBookingInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($advancedBookingInd) && !is_bool($advancedBookingInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($advancedBookingInd)), __LINE__);
        }
        $this->AdvancedBookingInd = $advancedBookingInd;
        return $this;
    }
    /**
     * Get RestrictedMileageInd value
     * @return bool|null
     */
    public function getRestrictedMileageInd()
    {
        return $this->RestrictedMileageInd;
    }
    /**
     * Set RestrictedMileageInd value
     * @param bool $restrictedMileageInd
     * @return \dgsoft\StructType\DgVehicleRentalRateTypeRateRestrictions
     */
    public function setRestrictedMileageInd($restrictedMileageInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($restrictedMileageInd) && !is_bool($restrictedMileageInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($restrictedMileageInd)), __LINE__);
        }
        $this->RestrictedMileageInd = $restrictedMileageInd;
        return $this;
    }
    /**
     * Get CorporateRateInd value
     * @return bool|null
     */
    public function getCorporateRateInd()
    {
        return $this->CorporateRateInd;
    }
    /**
     * Set CorporateRateInd value
     * @param bool $corporateRateInd
     * @return \dgsoft\StructType\DgVehicleRentalRateTypeRateRestrictions
     */
    public function setCorporateRateInd($corporateRateInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($corporateRateInd) && !is_bool($corporateRateInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($corporateRateInd)), __LINE__);
        }
        $this->CorporateRateInd = $corporateRateInd;
        return $this;
    }
    /**
     * Get GuaranteeReqInd value
     * @return bool|null
     */
    public function getGuaranteeReqInd()
    {
        return $this->GuaranteeReqInd;
    }
    /**
     * Set GuaranteeReqInd value
     * @param bool $guaranteeReqInd
     * @return \dgsoft\StructType\DgVehicleRentalRateTypeRateRestrictions
     */
    public function setGuaranteeReqInd($guaranteeReqInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($guaranteeReqInd) && !is_bool($guaranteeReqInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($guaranteeReqInd)), __LINE__);
        }
        $this->GuaranteeReqInd = $guaranteeReqInd;
        return $this;
    }
    /**
     * Get MaximumVehiclesAllowed value
     * @return int|null
     */
    public function getMaximumVehiclesAllowed()
    {
        return $this->MaximumVehiclesAllowed;
    }
    /**
     * Set MaximumVehiclesAllowed value
     * @param int $maximumVehiclesAllowed
     * @return \dgsoft\StructType\DgVehicleRentalRateTypeRateRestrictions
     */
    public function setMaximumVehiclesAllowed($maximumVehiclesAllowed = null)
    {
        // validation for constraint: int
        if (!is_null($maximumVehiclesAllowed) && !is_numeric($maximumVehiclesAllowed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($maximumVehiclesAllowed)), __LINE__);
        }
        $this->MaximumVehiclesAllowed = $maximumVehiclesAllowed;
        return $this;
    }
    /**
     * Get OvernightInd value
     * @return bool|null
     */
    public function getOvernightInd()
    {
        return $this->OvernightInd;
    }
    /**
     * Set OvernightInd value
     * @param bool $overnightInd
     * @return \dgsoft\StructType\DgVehicleRentalRateTypeRateRestrictions
     */
    public function setOvernightInd($overnightInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($overnightInd) && !is_bool($overnightInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($overnightInd)), __LINE__);
        }
        $this->OvernightInd = $overnightInd;
        return $this;
    }
    /**
     * Get OneWayPolicy value
     * @return string|null
     */
    public function getOneWayPolicy()
    {
        return $this->OneWayPolicy;
    }
    /**
     * Set OneWayPolicy value
     * @uses \dgsoft\EnumType\DgVehicleRentalRateTypeRateRestrictionsOneWayPolicy::valueIsValid()
     * @uses \dgsoft\EnumType\DgVehicleRentalRateTypeRateRestrictionsOneWayPolicy::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $oneWayPolicy
     * @return \dgsoft\StructType\DgVehicleRentalRateTypeRateRestrictions
     */
    public function setOneWayPolicy($oneWayPolicy = null)
    {
        // validation for constraint: enumeration
        if (!\dgsoft\EnumType\DgVehicleRentalRateTypeRateRestrictionsOneWayPolicy::valueIsValid($oneWayPolicy)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $oneWayPolicy, implode(', ', \dgsoft\EnumType\DgVehicleRentalRateTypeRateRestrictionsOneWayPolicy::getValidValues())), __LINE__);
        }
        $this->OneWayPolicy = $oneWayPolicy;
        return $this;
    }
    /**
     * Get CancellationPenaltyInd value
     * @return bool|null
     */
    public function getCancellationPenaltyInd()
    {
        return $this->CancellationPenaltyInd;
    }
    /**
     * Set CancellationPenaltyInd value
     * @param bool $cancellationPenaltyInd
     * @return \dgsoft\StructType\DgVehicleRentalRateTypeRateRestrictions
     */
    public function setCancellationPenaltyInd($cancellationPenaltyInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($cancellationPenaltyInd) && !is_bool($cancellationPenaltyInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($cancellationPenaltyInd)), __LINE__);
        }
        $this->CancellationPenaltyInd = $cancellationPenaltyInd;
        return $this;
    }
    /**
     * Get ModificationPenaltyInd value
     * @return bool|null
     */
    public function getModificationPenaltyInd()
    {
        return $this->ModificationPenaltyInd;
    }
    /**
     * Set ModificationPenaltyInd value
     * @param bool $modificationPenaltyInd
     * @return \dgsoft\StructType\DgVehicleRentalRateTypeRateRestrictions
     */
    public function setModificationPenaltyInd($modificationPenaltyInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($modificationPenaltyInd) && !is_bool($modificationPenaltyInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($modificationPenaltyInd)), __LINE__);
        }
        $this->ModificationPenaltyInd = $modificationPenaltyInd;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\StructType\DgVehicleRentalRateTypeRateRestrictions
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
