<?php

namespace dgsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for VehicleRentalRateTypeRateGuarantee StructType
 * @package Dg
 * @subpackage Structs
 */
class DgVehicleRentalRateTypeRateGuarantee extends AbstractStructBase
{
    /**
     * The Description
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgFormattedTextTextType
     */
    public $Description;
    /**
     * The AbsoluteDeadline
     * @var string
     */
    public $AbsoluteDeadline;
    /**
     * The OffsetTimeUnit
     * @var string
     */
    public $OffsetTimeUnit;
    /**
     * The OffsetUnitMultiplier
     * @var int
     */
    public $OffsetUnitMultiplier;
    /**
     * The OffsetDropTime
     * @var string
     */
    public $OffsetDropTime;
    /**
     * Constructor method for VehicleRentalRateTypeRateGuarantee
     * @uses DgVehicleRentalRateTypeRateGuarantee::setDescription()
     * @uses DgVehicleRentalRateTypeRateGuarantee::setAbsoluteDeadline()
     * @uses DgVehicleRentalRateTypeRateGuarantee::setOffsetTimeUnit()
     * @uses DgVehicleRentalRateTypeRateGuarantee::setOffsetUnitMultiplier()
     * @uses DgVehicleRentalRateTypeRateGuarantee::setOffsetDropTime()
     * @param \dgsoft\StructType\DgFormattedTextTextType $description
     * @param string $absoluteDeadline
     * @param string $offsetTimeUnit
     * @param int $offsetUnitMultiplier
     * @param string $offsetDropTime
     */
    public function __construct(\dgsoft\StructType\DgFormattedTextTextType $description = null, $absoluteDeadline = null, $offsetTimeUnit = null, $offsetUnitMultiplier = null, $offsetDropTime = null)
    {
        $this
            ->setDescription($description)
            ->setAbsoluteDeadline($absoluteDeadline)
            ->setOffsetTimeUnit($offsetTimeUnit)
            ->setOffsetUnitMultiplier($offsetUnitMultiplier)
            ->setOffsetDropTime($offsetDropTime);
    }
    /**
     * Get Description value
     * @return \dgsoft\StructType\DgFormattedTextTextType|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param \dgsoft\StructType\DgFormattedTextTextType $description
     * @return \dgsoft\StructType\DgVehicleRentalRateTypeRateGuarantee
     */
    public function setDescription(\dgsoft\StructType\DgFormattedTextTextType $description = null)
    {
        $this->Description = $description;
        return $this;
    }
    /**
     * Get AbsoluteDeadline value
     * @return string|null
     */
    public function getAbsoluteDeadline()
    {
        return $this->AbsoluteDeadline;
    }
    /**
     * Set AbsoluteDeadline value
     * @param string $absoluteDeadline
     * @return \dgsoft\StructType\DgVehicleRentalRateTypeRateGuarantee
     */
    public function setAbsoluteDeadline($absoluteDeadline = null)
    {
        // validation for constraint: string
        if (!is_null($absoluteDeadline) && !is_string($absoluteDeadline)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($absoluteDeadline)), __LINE__);
        }
        $this->AbsoluteDeadline = $absoluteDeadline;
        return $this;
    }
    /**
     * Get OffsetTimeUnit value
     * @return string|null
     */
    public function getOffsetTimeUnit()
    {
        return $this->OffsetTimeUnit;
    }
    /**
     * Set OffsetTimeUnit value
     * @uses \dgsoft\EnumType\DgTimeUnitType::valueIsValid()
     * @uses \dgsoft\EnumType\DgTimeUnitType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $offsetTimeUnit
     * @return \dgsoft\StructType\DgVehicleRentalRateTypeRateGuarantee
     */
    public function setOffsetTimeUnit($offsetTimeUnit = null)
    {
        // validation for constraint: enumeration
        if (!\dgsoft\EnumType\DgTimeUnitType::valueIsValid($offsetTimeUnit)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $offsetTimeUnit, implode(', ', \dgsoft\EnumType\DgTimeUnitType::getValidValues())), __LINE__);
        }
        $this->OffsetTimeUnit = $offsetTimeUnit;
        return $this;
    }
    /**
     * Get OffsetUnitMultiplier value
     * @return int|null
     */
    public function getOffsetUnitMultiplier()
    {
        return $this->OffsetUnitMultiplier;
    }
    /**
     * Set OffsetUnitMultiplier value
     * @param int $offsetUnitMultiplier
     * @return \dgsoft\StructType\DgVehicleRentalRateTypeRateGuarantee
     */
    public function setOffsetUnitMultiplier($offsetUnitMultiplier = null)
    {
        // validation for constraint: int
        if (!is_null($offsetUnitMultiplier) && !is_numeric($offsetUnitMultiplier)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($offsetUnitMultiplier)), __LINE__);
        }
        $this->OffsetUnitMultiplier = $offsetUnitMultiplier;
        return $this;
    }
    /**
     * Get OffsetDropTime value
     * @return string|null
     */
    public function getOffsetDropTime()
    {
        return $this->OffsetDropTime;
    }
    /**
     * Set OffsetDropTime value
     * @uses \dgsoft\EnumType\DgVehicleRentalRateTypeRateGuaranteeOffsetDropTime::valueIsValid()
     * @uses \dgsoft\EnumType\DgVehicleRentalRateTypeRateGuaranteeOffsetDropTime::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $offsetDropTime
     * @return \dgsoft\StructType\DgVehicleRentalRateTypeRateGuarantee
     */
    public function setOffsetDropTime($offsetDropTime = null)
    {
        // validation for constraint: enumeration
        if (!\dgsoft\EnumType\DgVehicleRentalRateTypeRateGuaranteeOffsetDropTime::valueIsValid($offsetDropTime)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $offsetDropTime, implode(', ', \dgsoft\EnumType\DgVehicleRentalRateTypeRateGuaranteeOffsetDropTime::getValidValues())), __LINE__);
        }
        $this->OffsetDropTime = $offsetDropTime;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\StructType\DgVehicleRentalRateTypeRateGuarantee
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
