<?php

namespace dgsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for VehicleRentalRateTypeRateDistance StructType
 * @package Dg
 * @subpackage Structs
 */
class DgVehicleRentalRateTypeRateDistance extends AbstractStructBase
{
    /**
     * The Unlimited
     * Meta informations extracted from the WSDL
     * - use: required
     * @var bool
     */
    public $Unlimited;
    /**
     * The ChargeAmount
     * @var float
     */
    public $ChargeAmount;
    /**
     * The Quantity
     * @var int
     */
    public $Quantity;
    /**
     * The DistUnitName
     * @var string
     */
    public $DistUnitName;
    /**
     * The VehiclePeriodUnitName
     * @var string
     */
    public $VehiclePeriodUnitName;
    /**
     * Constructor method for VehicleRentalRateTypeRateDistance
     * @uses DgVehicleRentalRateTypeRateDistance::setUnlimited()
     * @uses DgVehicleRentalRateTypeRateDistance::setChargeAmount()
     * @uses DgVehicleRentalRateTypeRateDistance::setQuantity()
     * @uses DgVehicleRentalRateTypeRateDistance::setDistUnitName()
     * @uses DgVehicleRentalRateTypeRateDistance::setVehiclePeriodUnitName()
     * @param bool $unlimited
     * @param float $chargeAmount
     * @param int $quantity
     * @param string $distUnitName
     * @param string $vehiclePeriodUnitName
     */
    public function __construct($unlimited = null, $chargeAmount = null, $quantity = null, $distUnitName = null, $vehiclePeriodUnitName = null)
    {
        $this
            ->setUnlimited($unlimited)
            ->setChargeAmount($chargeAmount)
            ->setQuantity($quantity)
            ->setDistUnitName($distUnitName)
            ->setVehiclePeriodUnitName($vehiclePeriodUnitName);
    }
    /**
     * Get Unlimited value
     * @return bool
     */
    public function getUnlimited()
    {
        return $this->Unlimited;
    }
    /**
     * Set Unlimited value
     * @param bool $unlimited
     * @return \dgsoft\StructType\DgVehicleRentalRateTypeRateDistance
     */
    public function setUnlimited($unlimited = null)
    {
        // validation for constraint: boolean
        if (!is_null($unlimited) && !is_bool($unlimited)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($unlimited)), __LINE__);
        }
        $this->Unlimited = $unlimited;
        return $this;
    }
    /**
     * Get ChargeAmount value
     * @return float|null
     */
    public function getChargeAmount()
    {
        return $this->ChargeAmount;
    }
    /**
     * Set ChargeAmount value
     * @param float $chargeAmount
     * @return \dgsoft\StructType\DgVehicleRentalRateTypeRateDistance
     */
    public function setChargeAmount($chargeAmount = null)
    {
        $this->ChargeAmount = $chargeAmount;
        return $this;
    }
    /**
     * Get Quantity value
     * @return int|null
     */
    public function getQuantity()
    {
        return $this->Quantity;
    }
    /**
     * Set Quantity value
     * @param int $quantity
     * @return \dgsoft\StructType\DgVehicleRentalRateTypeRateDistance
     */
    public function setQuantity($quantity = null)
    {
        // validation for constraint: int
        if (!is_null($quantity) && !is_numeric($quantity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($quantity)), __LINE__);
        }
        $this->Quantity = $quantity;
        return $this;
    }
    /**
     * Get DistUnitName value
     * @return string|null
     */
    public function getDistUnitName()
    {
        return $this->DistUnitName;
    }
    /**
     * Set DistUnitName value
     * @uses \dgsoft\EnumType\DgDistanceUnitNameType::valueIsValid()
     * @uses \dgsoft\EnumType\DgDistanceUnitNameType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $distUnitName
     * @return \dgsoft\StructType\DgVehicleRentalRateTypeRateDistance
     */
    public function setDistUnitName($distUnitName = null)
    {
        // validation for constraint: enumeration
        if (!\dgsoft\EnumType\DgDistanceUnitNameType::valueIsValid($distUnitName)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $distUnitName, implode(', ', \dgsoft\EnumType\DgDistanceUnitNameType::getValidValues())), __LINE__);
        }
        $this->DistUnitName = $distUnitName;
        return $this;
    }
    /**
     * Get VehiclePeriodUnitName value
     * @return string|null
     */
    public function getVehiclePeriodUnitName()
    {
        return $this->VehiclePeriodUnitName;
    }
    /**
     * Set VehiclePeriodUnitName value
     * @uses \dgsoft\EnumType\DgVehiclePeriodUnitNameType::valueIsValid()
     * @uses \dgsoft\EnumType\DgVehiclePeriodUnitNameType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $vehiclePeriodUnitName
     * @return \dgsoft\StructType\DgVehicleRentalRateTypeRateDistance
     */
    public function setVehiclePeriodUnitName($vehiclePeriodUnitName = null)
    {
        // validation for constraint: enumeration
        if (!\dgsoft\EnumType\DgVehiclePeriodUnitNameType::valueIsValid($vehiclePeriodUnitName)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $vehiclePeriodUnitName, implode(', ', \dgsoft\EnumType\DgVehiclePeriodUnitNameType::getValidValues())), __LINE__);
        }
        $this->VehiclePeriodUnitName = $vehiclePeriodUnitName;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\StructType\DgVehicleRentalRateTypeRateDistance
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
