<?php

namespace dgsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for VehicleProfileRentalPrefType StructType
 * @package Dg
 * @subpackage Structs
 */
class DgVehicleProfileRentalPrefType extends AbstractStructBase
{
    /**
     * The LoyaltyPref
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgLoyaltyPref[]
     */
    public $LoyaltyPref;
    /**
     * The VendorPref
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgCompanyNamePrefType[]
     */
    public $VendorPref;
    /**
     * The PaymentFormPref
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgPaymentFormPref[]
     */
    public $PaymentFormPref;
    /**
     * The CoveragePref
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgCoveragePref[]
     */
    public $CoveragePref;
    /**
     * The SpecialReqPref
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgVehicleSpecialReqPrefType[]
     */
    public $SpecialReqPref;
    /**
     * The VehTypePref
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgVehiclePrefType[]
     */
    public $VehTypePref;
    /**
     * The SpecialEquipPref
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgSpecialEquipPref[]
     */
    public $SpecialEquipPref;
    /**
     * The PreferLevel
     * Meta informations extracted from the WSDL
     * - default: Preferred
     * @var string
     */
    public $PreferLevel;
    /**
     * The ShareSynchInd
     * @var string
     */
    public $ShareSynchInd;
    /**
     * The ShareMarketInd
     * @var string
     */
    public $ShareMarketInd;
    /**
     * The SmokingAllowed
     * Meta informations extracted from the WSDL
     * - default: false
     * @var bool
     */
    public $SmokingAllowed;
    /**
     * The GasPrePay
     * Meta informations extracted from the WSDL
     * - default: false
     * @var bool
     */
    public $GasPrePay;
    /**
     * Constructor method for VehicleProfileRentalPrefType
     * @uses DgVehicleProfileRentalPrefType::setLoyaltyPref()
     * @uses DgVehicleProfileRentalPrefType::setVendorPref()
     * @uses DgVehicleProfileRentalPrefType::setPaymentFormPref()
     * @uses DgVehicleProfileRentalPrefType::setCoveragePref()
     * @uses DgVehicleProfileRentalPrefType::setSpecialReqPref()
     * @uses DgVehicleProfileRentalPrefType::setVehTypePref()
     * @uses DgVehicleProfileRentalPrefType::setSpecialEquipPref()
     * @uses DgVehicleProfileRentalPrefType::setPreferLevel()
     * @uses DgVehicleProfileRentalPrefType::setShareSynchInd()
     * @uses DgVehicleProfileRentalPrefType::setShareMarketInd()
     * @uses DgVehicleProfileRentalPrefType::setSmokingAllowed()
     * @uses DgVehicleProfileRentalPrefType::setGasPrePay()
     * @param \dgsoft\StructType\DgLoyaltyPref[] $loyaltyPref
     * @param \dgsoft\StructType\DgCompanyNamePrefType[] $vendorPref
     * @param \dgsoft\StructType\DgPaymentFormPref[] $paymentFormPref
     * @param \dgsoft\StructType\DgCoveragePref[] $coveragePref
     * @param \dgsoft\StructType\DgVehicleSpecialReqPrefType[] $specialReqPref
     * @param \dgsoft\StructType\DgVehiclePrefType[] $vehTypePref
     * @param \dgsoft\StructType\DgSpecialEquipPref[] $specialEquipPref
     * @param string $preferLevel
     * @param string $shareSynchInd
     * @param string $shareMarketInd
     * @param bool $smokingAllowed
     * @param bool $gasPrePay
     */
    public function __construct(array $loyaltyPref = array(), array $vendorPref = array(), array $paymentFormPref = array(), array $coveragePref = array(), array $specialReqPref = array(), array $vehTypePref = array(), array $specialEquipPref = array(), $preferLevel = 'Preferred', $shareSynchInd = null, $shareMarketInd = null, $smokingAllowed = false, $gasPrePay = false)
    {
        $this
            ->setLoyaltyPref($loyaltyPref)
            ->setVendorPref($vendorPref)
            ->setPaymentFormPref($paymentFormPref)
            ->setCoveragePref($coveragePref)
            ->setSpecialReqPref($specialReqPref)
            ->setVehTypePref($vehTypePref)
            ->setSpecialEquipPref($specialEquipPref)
            ->setPreferLevel($preferLevel)
            ->setShareSynchInd($shareSynchInd)
            ->setShareMarketInd($shareMarketInd)
            ->setSmokingAllowed($smokingAllowed)
            ->setGasPrePay($gasPrePay);
    }
    /**
     * Get LoyaltyPref value
     * @return \dgsoft\StructType\DgLoyaltyPref[]|null
     */
    public function getLoyaltyPref()
    {
        return $this->LoyaltyPref;
    }
    /**
     * Set LoyaltyPref value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgLoyaltyPref[] $loyaltyPref
     * @return \dgsoft\StructType\DgVehicleProfileRentalPrefType
     */
    public function setLoyaltyPref(array $loyaltyPref = array())
    {
        foreach ($loyaltyPref as $vehicleProfileRentalPrefTypeLoyaltyPrefItem) {
            // validation for constraint: itemType
            if (!$vehicleProfileRentalPrefTypeLoyaltyPrefItem instanceof \dgsoft\StructType\DgLoyaltyPref) {
                throw new \InvalidArgumentException(sprintf('The LoyaltyPref property can only contain items of \dgsoft\StructType\DgLoyaltyPref, "%s" given', is_object($vehicleProfileRentalPrefTypeLoyaltyPrefItem) ? get_class($vehicleProfileRentalPrefTypeLoyaltyPrefItem) : gettype($vehicleProfileRentalPrefTypeLoyaltyPrefItem)), __LINE__);
            }
        }
        $this->LoyaltyPref = $loyaltyPref;
        return $this;
    }
    /**
     * Add item to LoyaltyPref value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgLoyaltyPref $item
     * @return \dgsoft\StructType\DgVehicleProfileRentalPrefType
     */
    public function addToLoyaltyPref(\dgsoft\StructType\DgLoyaltyPref $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \dgsoft\StructType\DgLoyaltyPref) {
            throw new \InvalidArgumentException(sprintf('The LoyaltyPref property can only contain items of \dgsoft\StructType\DgLoyaltyPref, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->LoyaltyPref[] = $item;
        return $this;
    }
    /**
     * Get VendorPref value
     * @return \dgsoft\StructType\DgCompanyNamePrefType[]|null
     */
    public function getVendorPref()
    {
        return $this->VendorPref;
    }
    /**
     * Set VendorPref value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgCompanyNamePrefType[] $vendorPref
     * @return \dgsoft\StructType\DgVehicleProfileRentalPrefType
     */
    public function setVendorPref(array $vendorPref = array())
    {
        foreach ($vendorPref as $vehicleProfileRentalPrefTypeVendorPrefItem) {
            // validation for constraint: itemType
            if (!$vehicleProfileRentalPrefTypeVendorPrefItem instanceof \dgsoft\StructType\DgCompanyNamePrefType) {
                throw new \InvalidArgumentException(sprintf('The VendorPref property can only contain items of \dgsoft\StructType\DgCompanyNamePrefType, "%s" given', is_object($vehicleProfileRentalPrefTypeVendorPrefItem) ? get_class($vehicleProfileRentalPrefTypeVendorPrefItem) : gettype($vehicleProfileRentalPrefTypeVendorPrefItem)), __LINE__);
            }
        }
        $this->VendorPref = $vendorPref;
        return $this;
    }
    /**
     * Add item to VendorPref value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgCompanyNamePrefType $item
     * @return \dgsoft\StructType\DgVehicleProfileRentalPrefType
     */
    public function addToVendorPref(\dgsoft\StructType\DgCompanyNamePrefType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \dgsoft\StructType\DgCompanyNamePrefType) {
            throw new \InvalidArgumentException(sprintf('The VendorPref property can only contain items of \dgsoft\StructType\DgCompanyNamePrefType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->VendorPref[] = $item;
        return $this;
    }
    /**
     * Get PaymentFormPref value
     * @return \dgsoft\StructType\DgPaymentFormPref[]|null
     */
    public function getPaymentFormPref()
    {
        return $this->PaymentFormPref;
    }
    /**
     * Set PaymentFormPref value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgPaymentFormPref[] $paymentFormPref
     * @return \dgsoft\StructType\DgVehicleProfileRentalPrefType
     */
    public function setPaymentFormPref(array $paymentFormPref = array())
    {
        foreach ($paymentFormPref as $vehicleProfileRentalPrefTypePaymentFormPrefItem) {
            // validation for constraint: itemType
            if (!$vehicleProfileRentalPrefTypePaymentFormPrefItem instanceof \dgsoft\StructType\DgPaymentFormPref) {
                throw new \InvalidArgumentException(sprintf('The PaymentFormPref property can only contain items of \dgsoft\StructType\DgPaymentFormPref, "%s" given', is_object($vehicleProfileRentalPrefTypePaymentFormPrefItem) ? get_class($vehicleProfileRentalPrefTypePaymentFormPrefItem) : gettype($vehicleProfileRentalPrefTypePaymentFormPrefItem)), __LINE__);
            }
        }
        $this->PaymentFormPref = $paymentFormPref;
        return $this;
    }
    /**
     * Add item to PaymentFormPref value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgPaymentFormPref $item
     * @return \dgsoft\StructType\DgVehicleProfileRentalPrefType
     */
    public function addToPaymentFormPref(\dgsoft\StructType\DgPaymentFormPref $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \dgsoft\StructType\DgPaymentFormPref) {
            throw new \InvalidArgumentException(sprintf('The PaymentFormPref property can only contain items of \dgsoft\StructType\DgPaymentFormPref, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->PaymentFormPref[] = $item;
        return $this;
    }
    /**
     * Get CoveragePref value
     * @return \dgsoft\StructType\DgCoveragePref[]|null
     */
    public function getCoveragePref()
    {
        return $this->CoveragePref;
    }
    /**
     * Set CoveragePref value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgCoveragePref[] $coveragePref
     * @return \dgsoft\StructType\DgVehicleProfileRentalPrefType
     */
    public function setCoveragePref(array $coveragePref = array())
    {
        foreach ($coveragePref as $vehicleProfileRentalPrefTypeCoveragePrefItem) {
            // validation for constraint: itemType
            if (!$vehicleProfileRentalPrefTypeCoveragePrefItem instanceof \dgsoft\StructType\DgCoveragePref) {
                throw new \InvalidArgumentException(sprintf('The CoveragePref property can only contain items of \dgsoft\StructType\DgCoveragePref, "%s" given', is_object($vehicleProfileRentalPrefTypeCoveragePrefItem) ? get_class($vehicleProfileRentalPrefTypeCoveragePrefItem) : gettype($vehicleProfileRentalPrefTypeCoveragePrefItem)), __LINE__);
            }
        }
        $this->CoveragePref = $coveragePref;
        return $this;
    }
    /**
     * Add item to CoveragePref value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgCoveragePref $item
     * @return \dgsoft\StructType\DgVehicleProfileRentalPrefType
     */
    public function addToCoveragePref(\dgsoft\StructType\DgCoveragePref $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \dgsoft\StructType\DgCoveragePref) {
            throw new \InvalidArgumentException(sprintf('The CoveragePref property can only contain items of \dgsoft\StructType\DgCoveragePref, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->CoveragePref[] = $item;
        return $this;
    }
    /**
     * Get SpecialReqPref value
     * @return \dgsoft\StructType\DgVehicleSpecialReqPrefType[]|null
     */
    public function getSpecialReqPref()
    {
        return $this->SpecialReqPref;
    }
    /**
     * Set SpecialReqPref value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgVehicleSpecialReqPrefType[] $specialReqPref
     * @return \dgsoft\StructType\DgVehicleProfileRentalPrefType
     */
    public function setSpecialReqPref(array $specialReqPref = array())
    {
        foreach ($specialReqPref as $vehicleProfileRentalPrefTypeSpecialReqPrefItem) {
            // validation for constraint: itemType
            if (!$vehicleProfileRentalPrefTypeSpecialReqPrefItem instanceof \dgsoft\StructType\DgVehicleSpecialReqPrefType) {
                throw new \InvalidArgumentException(sprintf('The SpecialReqPref property can only contain items of \dgsoft\StructType\DgVehicleSpecialReqPrefType, "%s" given', is_object($vehicleProfileRentalPrefTypeSpecialReqPrefItem) ? get_class($vehicleProfileRentalPrefTypeSpecialReqPrefItem) : gettype($vehicleProfileRentalPrefTypeSpecialReqPrefItem)), __LINE__);
            }
        }
        $this->SpecialReqPref = $specialReqPref;
        return $this;
    }
    /**
     * Add item to SpecialReqPref value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgVehicleSpecialReqPrefType $item
     * @return \dgsoft\StructType\DgVehicleProfileRentalPrefType
     */
    public function addToSpecialReqPref(\dgsoft\StructType\DgVehicleSpecialReqPrefType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \dgsoft\StructType\DgVehicleSpecialReqPrefType) {
            throw new \InvalidArgumentException(sprintf('The SpecialReqPref property can only contain items of \dgsoft\StructType\DgVehicleSpecialReqPrefType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->SpecialReqPref[] = $item;
        return $this;
    }
    /**
     * Get VehTypePref value
     * @return \dgsoft\StructType\DgVehiclePrefType[]|null
     */
    public function getVehTypePref()
    {
        return $this->VehTypePref;
    }
    /**
     * Set VehTypePref value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgVehiclePrefType[] $vehTypePref
     * @return \dgsoft\StructType\DgVehicleProfileRentalPrefType
     */
    public function setVehTypePref(array $vehTypePref = array())
    {
        foreach ($vehTypePref as $vehicleProfileRentalPrefTypeVehTypePrefItem) {
            // validation for constraint: itemType
            if (!$vehicleProfileRentalPrefTypeVehTypePrefItem instanceof \dgsoft\StructType\DgVehiclePrefType) {
                throw new \InvalidArgumentException(sprintf('The VehTypePref property can only contain items of \dgsoft\StructType\DgVehiclePrefType, "%s" given', is_object($vehicleProfileRentalPrefTypeVehTypePrefItem) ? get_class($vehicleProfileRentalPrefTypeVehTypePrefItem) : gettype($vehicleProfileRentalPrefTypeVehTypePrefItem)), __LINE__);
            }
        }
        $this->VehTypePref = $vehTypePref;
        return $this;
    }
    /**
     * Add item to VehTypePref value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgVehiclePrefType $item
     * @return \dgsoft\StructType\DgVehicleProfileRentalPrefType
     */
    public function addToVehTypePref(\dgsoft\StructType\DgVehiclePrefType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \dgsoft\StructType\DgVehiclePrefType) {
            throw new \InvalidArgumentException(sprintf('The VehTypePref property can only contain items of \dgsoft\StructType\DgVehiclePrefType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->VehTypePref[] = $item;
        return $this;
    }
    /**
     * Get SpecialEquipPref value
     * @return \dgsoft\StructType\DgSpecialEquipPref[]|null
     */
    public function getSpecialEquipPref()
    {
        return $this->SpecialEquipPref;
    }
    /**
     * Set SpecialEquipPref value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgSpecialEquipPref[] $specialEquipPref
     * @return \dgsoft\StructType\DgVehicleProfileRentalPrefType
     */
    public function setSpecialEquipPref(array $specialEquipPref = array())
    {
        foreach ($specialEquipPref as $vehicleProfileRentalPrefTypeSpecialEquipPrefItem) {
            // validation for constraint: itemType
            if (!$vehicleProfileRentalPrefTypeSpecialEquipPrefItem instanceof \dgsoft\StructType\DgSpecialEquipPref) {
                throw new \InvalidArgumentException(sprintf('The SpecialEquipPref property can only contain items of \dgsoft\StructType\DgSpecialEquipPref, "%s" given', is_object($vehicleProfileRentalPrefTypeSpecialEquipPrefItem) ? get_class($vehicleProfileRentalPrefTypeSpecialEquipPrefItem) : gettype($vehicleProfileRentalPrefTypeSpecialEquipPrefItem)), __LINE__);
            }
        }
        $this->SpecialEquipPref = $specialEquipPref;
        return $this;
    }
    /**
     * Add item to SpecialEquipPref value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgSpecialEquipPref $item
     * @return \dgsoft\StructType\DgVehicleProfileRentalPrefType
     */
    public function addToSpecialEquipPref(\dgsoft\StructType\DgSpecialEquipPref $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \dgsoft\StructType\DgSpecialEquipPref) {
            throw new \InvalidArgumentException(sprintf('The SpecialEquipPref property can only contain items of \dgsoft\StructType\DgSpecialEquipPref, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->SpecialEquipPref[] = $item;
        return $this;
    }
    /**
     * Get PreferLevel value
     * @return string|null
     */
    public function getPreferLevel()
    {
        return $this->PreferLevel;
    }
    /**
     * Set PreferLevel value
     * @uses \dgsoft\EnumType\DgPreferLevelType::valueIsValid()
     * @uses \dgsoft\EnumType\DgPreferLevelType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $preferLevel
     * @return \dgsoft\StructType\DgVehicleProfileRentalPrefType
     */
    public function setPreferLevel($preferLevel = 'Preferred')
    {
        // validation for constraint: enumeration
        if (!\dgsoft\EnumType\DgPreferLevelType::valueIsValid($preferLevel)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $preferLevel, implode(', ', \dgsoft\EnumType\DgPreferLevelType::getValidValues())), __LINE__);
        }
        $this->PreferLevel = $preferLevel;
        return $this;
    }
    /**
     * Get ShareSynchInd value
     * @return string|null
     */
    public function getShareSynchInd()
    {
        return $this->ShareSynchInd;
    }
    /**
     * Set ShareSynchInd value
     * @param string $shareSynchInd
     * @return \dgsoft\StructType\DgVehicleProfileRentalPrefType
     */
    public function setShareSynchInd($shareSynchInd = null)
    {
        // validation for constraint: string
        if (!is_null($shareSynchInd) && !is_string($shareSynchInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($shareSynchInd)), __LINE__);
        }
        $this->ShareSynchInd = $shareSynchInd;
        return $this;
    }
    /**
     * Get ShareMarketInd value
     * @return string|null
     */
    public function getShareMarketInd()
    {
        return $this->ShareMarketInd;
    }
    /**
     * Set ShareMarketInd value
     * @param string $shareMarketInd
     * @return \dgsoft\StructType\DgVehicleProfileRentalPrefType
     */
    public function setShareMarketInd($shareMarketInd = null)
    {
        // validation for constraint: string
        if (!is_null($shareMarketInd) && !is_string($shareMarketInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($shareMarketInd)), __LINE__);
        }
        $this->ShareMarketInd = $shareMarketInd;
        return $this;
    }
    /**
     * Get SmokingAllowed value
     * @return bool|null
     */
    public function getSmokingAllowed()
    {
        return $this->SmokingAllowed;
    }
    /**
     * Set SmokingAllowed value
     * @param bool $smokingAllowed
     * @return \dgsoft\StructType\DgVehicleProfileRentalPrefType
     */
    public function setSmokingAllowed($smokingAllowed = false)
    {
        // validation for constraint: boolean
        if (!is_null($smokingAllowed) && !is_bool($smokingAllowed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($smokingAllowed)), __LINE__);
        }
        $this->SmokingAllowed = $smokingAllowed;
        return $this;
    }
    /**
     * Get GasPrePay value
     * @return bool|null
     */
    public function getGasPrePay()
    {
        return $this->GasPrePay;
    }
    /**
     * Set GasPrePay value
     * @param bool $gasPrePay
     * @return \dgsoft\StructType\DgVehicleProfileRentalPrefType
     */
    public function setGasPrePay($gasPrePay = false)
    {
        // validation for constraint: boolean
        if (!is_null($gasPrePay) && !is_bool($gasPrePay)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($gasPrePay)), __LINE__);
        }
        $this->GasPrePay = $gasPrePay;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\StructType\DgVehicleProfileRentalPrefType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
