<?php

namespace dgsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for VehicleMatchedLocationType StructType
 * @package Dg
 * @subpackage Structs
 */
class DgVehicleMatchedLocationType extends AbstractStructBase
{
    /**
     * The LocationDetail
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgVehicleLocationDetailsType
     */
    public $LocationDetail;
    /**
     * The VehLocSearchCriterion
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgItemSearchCriterionType[]
     */
    public $VehLocSearchCriterion;
    /**
     * The CompanyName
     * @var string
     */
    public $CompanyName;
    /**
     * The CompanyCode
     * @var string
     */
    public $CompanyCode;
    /**
     * The AlternateLocInd
     * @var bool
     */
    public $AlternateLocInd;
    /**
     * Constructor method for VehicleMatchedLocationType
     * @uses DgVehicleMatchedLocationType::setLocationDetail()
     * @uses DgVehicleMatchedLocationType::setVehLocSearchCriterion()
     * @uses DgVehicleMatchedLocationType::setCompanyName()
     * @uses DgVehicleMatchedLocationType::setCompanyCode()
     * @uses DgVehicleMatchedLocationType::setAlternateLocInd()
     * @param \dgsoft\StructType\DgVehicleLocationDetailsType $locationDetail
     * @param \dgsoft\StructType\DgItemSearchCriterionType[] $vehLocSearchCriterion
     * @param string $companyName
     * @param string $companyCode
     * @param bool $alternateLocInd
     */
    public function __construct(\dgsoft\StructType\DgVehicleLocationDetailsType $locationDetail = null, array $vehLocSearchCriterion = array(), $companyName = null, $companyCode = null, $alternateLocInd = null)
    {
        $this
            ->setLocationDetail($locationDetail)
            ->setVehLocSearchCriterion($vehLocSearchCriterion)
            ->setCompanyName($companyName)
            ->setCompanyCode($companyCode)
            ->setAlternateLocInd($alternateLocInd);
    }
    /**
     * Get LocationDetail value
     * @return \dgsoft\StructType\DgVehicleLocationDetailsType|null
     */
    public function getLocationDetail()
    {
        return $this->LocationDetail;
    }
    /**
     * Set LocationDetail value
     * @param \dgsoft\StructType\DgVehicleLocationDetailsType $locationDetail
     * @return \dgsoft\StructType\DgVehicleMatchedLocationType
     */
    public function setLocationDetail(\dgsoft\StructType\DgVehicleLocationDetailsType $locationDetail = null)
    {
        $this->LocationDetail = $locationDetail;
        return $this;
    }
    /**
     * Get VehLocSearchCriterion value
     * @return \dgsoft\StructType\DgItemSearchCriterionType[]|null
     */
    public function getVehLocSearchCriterion()
    {
        return $this->VehLocSearchCriterion;
    }
    /**
     * Set VehLocSearchCriterion value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgItemSearchCriterionType[] $vehLocSearchCriterion
     * @return \dgsoft\StructType\DgVehicleMatchedLocationType
     */
    public function setVehLocSearchCriterion(array $vehLocSearchCriterion = array())
    {
        foreach ($vehLocSearchCriterion as $vehicleMatchedLocationTypeVehLocSearchCriterionItem) {
            // validation for constraint: itemType
            if (!$vehicleMatchedLocationTypeVehLocSearchCriterionItem instanceof \dgsoft\StructType\DgItemSearchCriterionType) {
                throw new \InvalidArgumentException(sprintf('The VehLocSearchCriterion property can only contain items of \dgsoft\StructType\DgItemSearchCriterionType, "%s" given', is_object($vehicleMatchedLocationTypeVehLocSearchCriterionItem) ? get_class($vehicleMatchedLocationTypeVehLocSearchCriterionItem) : gettype($vehicleMatchedLocationTypeVehLocSearchCriterionItem)), __LINE__);
            }
        }
        $this->VehLocSearchCriterion = $vehLocSearchCriterion;
        return $this;
    }
    /**
     * Add item to VehLocSearchCriterion value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgItemSearchCriterionType $item
     * @return \dgsoft\StructType\DgVehicleMatchedLocationType
     */
    public function addToVehLocSearchCriterion(\dgsoft\StructType\DgItemSearchCriterionType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \dgsoft\StructType\DgItemSearchCriterionType) {
            throw new \InvalidArgumentException(sprintf('The VehLocSearchCriterion property can only contain items of \dgsoft\StructType\DgItemSearchCriterionType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->VehLocSearchCriterion[] = $item;
        return $this;
    }
    /**
     * Get CompanyName value
     * @return string|null
     */
    public function getCompanyName()
    {
        return $this->CompanyName;
    }
    /**
     * Set CompanyName value
     * @param string $companyName
     * @return \dgsoft\StructType\DgVehicleMatchedLocationType
     */
    public function setCompanyName($companyName = null)
    {
        // validation for constraint: string
        if (!is_null($companyName) && !is_string($companyName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($companyName)), __LINE__);
        }
        $this->CompanyName = $companyName;
        return $this;
    }
    /**
     * Get CompanyCode value
     * @return string|null
     */
    public function getCompanyCode()
    {
        return $this->CompanyCode;
    }
    /**
     * Set CompanyCode value
     * @param string $companyCode
     * @return \dgsoft\StructType\DgVehicleMatchedLocationType
     */
    public function setCompanyCode($companyCode = null)
    {
        // validation for constraint: string
        if (!is_null($companyCode) && !is_string($companyCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($companyCode)), __LINE__);
        }
        $this->CompanyCode = $companyCode;
        return $this;
    }
    /**
     * Get AlternateLocInd value
     * @return bool|null
     */
    public function getAlternateLocInd()
    {
        return $this->AlternateLocInd;
    }
    /**
     * Set AlternateLocInd value
     * @param bool $alternateLocInd
     * @return \dgsoft\StructType\DgVehicleMatchedLocationType
     */
    public function setAlternateLocInd($alternateLocInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($alternateLocInd) && !is_bool($alternateLocInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($alternateLocInd)), __LINE__);
        }
        $this->AlternateLocInd = $alternateLocInd;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\StructType\DgVehicleMatchedLocationType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
