<?php

namespace dgsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for VehicleCoreType StructType
 * @package Dg
 * @subpackage Structs
 */
class DgVehicleCoreType extends AbstractStructBase
{
    /**
     * The VehType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgVehType
     */
    public $VehType;
    /**
     * The VehClass
     * @var string
     */
    public $VehClass;
    /**
     * The AirConditionInd
     * @var bool
     */
    public $AirConditionInd;
    /**
     * The TransmissionType
     * @var string
     */
    public $TransmissionType;
    /**
     * The FuelType
     * @var string
     */
    public $FuelType;
    /**
     * The DriveType
     * @var string
     */
    public $DriveType;
    /**
     * Constructor method for VehicleCoreType
     * @uses DgVehicleCoreType::setVehType()
     * @uses DgVehicleCoreType::setVehClass()
     * @uses DgVehicleCoreType::setAirConditionInd()
     * @uses DgVehicleCoreType::setTransmissionType()
     * @uses DgVehicleCoreType::setFuelType()
     * @uses DgVehicleCoreType::setDriveType()
     * @param \dgsoft\StructType\DgVehType $vehType
     * @param string $vehClass
     * @param bool $airConditionInd
     * @param string $transmissionType
     * @param string $fuelType
     * @param string $driveType
     */
    public function __construct(\dgsoft\StructType\DgVehType $vehType = null, $vehClass = null, $airConditionInd = null, $transmissionType = null, $fuelType = null, $driveType = null)
    {
        $this
            ->setVehType($vehType)
            ->setVehClass($vehClass)
            ->setAirConditionInd($airConditionInd)
            ->setTransmissionType($transmissionType)
            ->setFuelType($fuelType)
            ->setDriveType($driveType);
    }
    /**
     * Get VehType value
     * @return \dgsoft\StructType\DgVehType|null
     */
    public function getVehType()
    {
        return $this->VehType;
    }
    /**
     * Set VehType value
     * @param \dgsoft\StructType\DgVehType $vehType
     * @return \dgsoft\StructType\DgVehicleCoreType
     */
    public function setVehType(\dgsoft\StructType\DgVehType $vehType = null)
    {
        $this->VehType = $vehType;
        return $this;
    }
    /**
     * Get VehClass value
     * @return string|null
     */
    public function getVehClass()
    {
        return $this->VehClass;
    }
    /**
     * Set VehClass value
     * @param string $vehClass
     * @return \dgsoft\StructType\DgVehicleCoreType
     */
    public function setVehClass($vehClass = null)
    {
        // validation for constraint: string
        if (!is_null($vehClass) && !is_string($vehClass)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($vehClass)), __LINE__);
        }
        $this->VehClass = $vehClass;
        return $this;
    }
    /**
     * Get AirConditionInd value
     * @return bool|null
     */
    public function getAirConditionInd()
    {
        return $this->AirConditionInd;
    }
    /**
     * Set AirConditionInd value
     * @param bool $airConditionInd
     * @return \dgsoft\StructType\DgVehicleCoreType
     */
    public function setAirConditionInd($airConditionInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($airConditionInd) && !is_bool($airConditionInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($airConditionInd)), __LINE__);
        }
        $this->AirConditionInd = $airConditionInd;
        return $this;
    }
    /**
     * Get TransmissionType value
     * @return string|null
     */
    public function getTransmissionType()
    {
        return $this->TransmissionType;
    }
    /**
     * Set TransmissionType value
     * @uses \dgsoft\EnumType\DgVehicleTransmissionType::valueIsValid()
     * @uses \dgsoft\EnumType\DgVehicleTransmissionType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $transmissionType
     * @return \dgsoft\StructType\DgVehicleCoreType
     */
    public function setTransmissionType($transmissionType = null)
    {
        // validation for constraint: enumeration
        if (!\dgsoft\EnumType\DgVehicleTransmissionType::valueIsValid($transmissionType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $transmissionType, implode(', ', \dgsoft\EnumType\DgVehicleTransmissionType::getValidValues())), __LINE__);
        }
        $this->TransmissionType = $transmissionType;
        return $this;
    }
    /**
     * Get FuelType value
     * @return string|null
     */
    public function getFuelType()
    {
        return $this->FuelType;
    }
    /**
     * Set FuelType value
     * @param string $fuelType
     * @return \dgsoft\StructType\DgVehicleCoreType
     */
    public function setFuelType($fuelType = null)
    {
        // validation for constraint: string
        if (!is_null($fuelType) && !is_string($fuelType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($fuelType)), __LINE__);
        }
        $this->FuelType = $fuelType;
        return $this;
    }
    /**
     * Get DriveType value
     * @return string|null
     */
    public function getDriveType()
    {
        return $this->DriveType;
    }
    /**
     * Set DriveType value
     * @param string $driveType
     * @return \dgsoft\StructType\DgVehicleCoreType
     */
    public function setDriveType($driveType = null)
    {
        // validation for constraint: string
        if (!is_null($driveType) && !is_string($driveType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($driveType)), __LINE__);
        }
        $this->DriveType = $driveType;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\StructType\DgVehicleCoreType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
