<?php

namespace dgsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for VehicleChargeTypeTaxAmount StructType
 * @package Dg
 * @subpackage Structs
 */
class DgVehicleChargeTypeTaxAmount extends AbstractStructBase
{
    /**
     * The PeriodType
     * @var string
     */
    public $PeriodType;
    /**
     * The Type
     * @var string
     */
    public $Type;
    /**
     * The Comment
     * @var string
     */
    public $Comment;
    /**
     * The Total
     * @var float
     */
    public $Total;
    /**
     * The CurrencyCode
     * @var string
     */
    public $CurrencyCode;
    /**
     * The TaxCode
     * @var string
     */
    public $TaxCode;
    /**
     * The Percentage
     * @var float
     */
    public $Percentage;
    /**
     * The Description
     * @var string
     */
    public $Description;
    /**
     * Constructor method for VehicleChargeTypeTaxAmount
     * @uses DgVehicleChargeTypeTaxAmount::setPeriodType()
     * @uses DgVehicleChargeTypeTaxAmount::setType()
     * @uses DgVehicleChargeTypeTaxAmount::setComment()
     * @uses DgVehicleChargeTypeTaxAmount::setTotal()
     * @uses DgVehicleChargeTypeTaxAmount::setCurrencyCode()
     * @uses DgVehicleChargeTypeTaxAmount::setTaxCode()
     * @uses DgVehicleChargeTypeTaxAmount::setPercentage()
     * @uses DgVehicleChargeTypeTaxAmount::setDescription()
     * @param string $periodType
     * @param string $type
     * @param string $comment
     * @param float $total
     * @param string $currencyCode
     * @param string $taxCode
     * @param float $percentage
     * @param string $description
     */
    public function __construct($periodType = null, $type = null, $comment = null, $total = null, $currencyCode = null, $taxCode = null, $percentage = null, $description = null)
    {
        $this
            ->setPeriodType($periodType)
            ->setType($type)
            ->setComment($comment)
            ->setTotal($total)
            ->setCurrencyCode($currencyCode)
            ->setTaxCode($taxCode)
            ->setPercentage($percentage)
            ->setDescription($description);
    }
    /**
     * Get PeriodType value
     * @return string|null
     */
    public function getPeriodType()
    {
        return $this->PeriodType;
    }
    /**
     * Set PeriodType value
     * @param string $periodType
     * @return \dgsoft\StructType\DgVehicleChargeTypeTaxAmount
     */
    public function setPeriodType($periodType = null)
    {
        // validation for constraint: string
        if (!is_null($periodType) && !is_string($periodType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($periodType)), __LINE__);
        }
        $this->PeriodType = $periodType;
        return $this;
    }
    /**
     * Get Type value
     * @return string|null
     */
    public function getType()
    {
        return $this->Type;
    }
    /**
     * Set Type value
     * @param string $type
     * @return \dgsoft\StructType\DgVehicleChargeTypeTaxAmount
     */
    public function setType($type = null)
    {
        // validation for constraint: string
        if (!is_null($type) && !is_string($type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($type)), __LINE__);
        }
        $this->Type = $type;
        return $this;
    }
    /**
     * Get Comment value
     * @return string|null
     */
    public function getComment()
    {
        return $this->Comment;
    }
    /**
     * Set Comment value
     * @param string $comment
     * @return \dgsoft\StructType\DgVehicleChargeTypeTaxAmount
     */
    public function setComment($comment = null)
    {
        // validation for constraint: string
        if (!is_null($comment) && !is_string($comment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($comment)), __LINE__);
        }
        $this->Comment = $comment;
        return $this;
    }
    /**
     * Get Total value
     * @return float|null
     */
    public function getTotal()
    {
        return $this->Total;
    }
    /**
     * Set Total value
     * @param float $total
     * @return \dgsoft\StructType\DgVehicleChargeTypeTaxAmount
     */
    public function setTotal($total = null)
    {
        $this->Total = $total;
        return $this;
    }
    /**
     * Get CurrencyCode value
     * @return string|null
     */
    public function getCurrencyCode()
    {
        return $this->CurrencyCode;
    }
    /**
     * Set CurrencyCode value
     * @param string $currencyCode
     * @return \dgsoft\StructType\DgVehicleChargeTypeTaxAmount
     */
    public function setCurrencyCode($currencyCode = null)
    {
        // validation for constraint: string
        if (!is_null($currencyCode) && !is_string($currencyCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($currencyCode)), __LINE__);
        }
        $this->CurrencyCode = $currencyCode;
        return $this;
    }
    /**
     * Get TaxCode value
     * @return string|null
     */
    public function getTaxCode()
    {
        return $this->TaxCode;
    }
    /**
     * Set TaxCode value
     * @param string $taxCode
     * @return \dgsoft\StructType\DgVehicleChargeTypeTaxAmount
     */
    public function setTaxCode($taxCode = null)
    {
        // validation for constraint: string
        if (!is_null($taxCode) && !is_string($taxCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($taxCode)), __LINE__);
        }
        $this->TaxCode = $taxCode;
        return $this;
    }
    /**
     * Get Percentage value
     * @return float|null
     */
    public function getPercentage()
    {
        return $this->Percentage;
    }
    /**
     * Set Percentage value
     * @param float $percentage
     * @return \dgsoft\StructType\DgVehicleChargeTypeTaxAmount
     */
    public function setPercentage($percentage = null)
    {
        $this->Percentage = $percentage;
        return $this;
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \dgsoft\StructType\DgVehicleChargeTypeTaxAmount
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\StructType\DgVehicleChargeTypeTaxAmount
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
