<?php

namespace dgsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for VehicleChargeType StructType
 * @package Dg
 * @subpackage Structs
 */
class DgVehicleChargeType extends AbstractStructBase
{
    /**
     * The TaxAmounts
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\ArrayType\DgArrayOfVehicleChargeTypeTaxAmount1
     */
    public $TaxAmounts;
    /**
     * The MinMax
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgVehicleChargeTypeMinMax
     */
    public $MinMax;
    /**
     * The Calculation
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgVehicleChargeTypeCalculation[]
     */
    public $Calculation;
    /**
     * The CurrencyCode
     * @var string
     */
    public $CurrencyCode;
    /**
     * The FareType
     * @var string
     */
    public $FareType;
    /**
     * The FareCategory
     * @var string
     */
    public $FareCategory;
    /**
     * The Amount
     * @var float
     */
    public $Amount;
    /**
     * The MarkupAmount
     * @var float
     */
    public $MarkupAmount;
    /**
     * The TaxInclusive
     * @var bool
     */
    public $TaxInclusive;
    /**
     * The Description
     * @var string
     */
    public $Description;
    /**
     * The GuaranteedInd
     * @var bool
     */
    public $GuaranteedInd;
    /**
     * The IncludedInRate
     * Meta informations extracted from the WSDL
     * - default: false
     * @var bool
     */
    public $IncludedInRate;
    /**
     * The IncludedInEstTotalInd
     * @var bool
     */
    public $IncludedInEstTotalInd;
    /**
     * Constructor method for VehicleChargeType
     * @uses DgVehicleChargeType::setTaxAmounts()
     * @uses DgVehicleChargeType::setMinMax()
     * @uses DgVehicleChargeType::setCalculation()
     * @uses DgVehicleChargeType::setCurrencyCode()
     * @uses DgVehicleChargeType::setFareType()
     * @uses DgVehicleChargeType::setFareCategory()
     * @uses DgVehicleChargeType::setAmount()
     * @uses DgVehicleChargeType::setMarkupAmount()
     * @uses DgVehicleChargeType::setTaxInclusive()
     * @uses DgVehicleChargeType::setDescription()
     * @uses DgVehicleChargeType::setGuaranteedInd()
     * @uses DgVehicleChargeType::setIncludedInRate()
     * @uses DgVehicleChargeType::setIncludedInEstTotalInd()
     * @param \dgsoft\ArrayType\DgArrayOfVehicleChargeTypeTaxAmount1 $taxAmounts
     * @param \dgsoft\StructType\DgVehicleChargeTypeMinMax $minMax
     * @param \dgsoft\StructType\DgVehicleChargeTypeCalculation[] $calculation
     * @param string $currencyCode
     * @param string $fareType
     * @param string $fareCategory
     * @param float $amount
     * @param float $markupAmount
     * @param bool $taxInclusive
     * @param string $description
     * @param bool $guaranteedInd
     * @param bool $includedInRate
     * @param bool $includedInEstTotalInd
     */
    public function __construct(\dgsoft\ArrayType\DgArrayOfVehicleChargeTypeTaxAmount1 $taxAmounts = null, \dgsoft\StructType\DgVehicleChargeTypeMinMax $minMax = null, array $calculation = array(), $currencyCode = null, $fareType = null, $fareCategory = null, $amount = null, $markupAmount = null, $taxInclusive = null, $description = null, $guaranteedInd = null, $includedInRate = false, $includedInEstTotalInd = null)
    {
        $this
            ->setTaxAmounts($taxAmounts)
            ->setMinMax($minMax)
            ->setCalculation($calculation)
            ->setCurrencyCode($currencyCode)
            ->setFareType($fareType)
            ->setFareCategory($fareCategory)
            ->setAmount($amount)
            ->setMarkupAmount($markupAmount)
            ->setTaxInclusive($taxInclusive)
            ->setDescription($description)
            ->setGuaranteedInd($guaranteedInd)
            ->setIncludedInRate($includedInRate)
            ->setIncludedInEstTotalInd($includedInEstTotalInd);
    }
    /**
     * Get TaxAmounts value
     * @return \dgsoft\ArrayType\DgArrayOfVehicleChargeTypeTaxAmount1|null
     */
    public function getTaxAmounts()
    {
        return $this->TaxAmounts;
    }
    /**
     * Set TaxAmounts value
     * @param \dgsoft\ArrayType\DgArrayOfVehicleChargeTypeTaxAmount1 $taxAmounts
     * @return \dgsoft\StructType\DgVehicleChargeType
     */
    public function setTaxAmounts(\dgsoft\ArrayType\DgArrayOfVehicleChargeTypeTaxAmount1 $taxAmounts = null)
    {
        $this->TaxAmounts = $taxAmounts;
        return $this;
    }
    /**
     * Get MinMax value
     * @return \dgsoft\StructType\DgVehicleChargeTypeMinMax|null
     */
    public function getMinMax()
    {
        return $this->MinMax;
    }
    /**
     * Set MinMax value
     * @param \dgsoft\StructType\DgVehicleChargeTypeMinMax $minMax
     * @return \dgsoft\StructType\DgVehicleChargeType
     */
    public function setMinMax(\dgsoft\StructType\DgVehicleChargeTypeMinMax $minMax = null)
    {
        $this->MinMax = $minMax;
        return $this;
    }
    /**
     * Get Calculation value
     * @return \dgsoft\StructType\DgVehicleChargeTypeCalculation[]|null
     */
    public function getCalculation()
    {
        return $this->Calculation;
    }
    /**
     * Set Calculation value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgVehicleChargeTypeCalculation[] $calculation
     * @return \dgsoft\StructType\DgVehicleChargeType
     */
    public function setCalculation(array $calculation = array())
    {
        foreach ($calculation as $vehicleChargeTypeCalculationItem) {
            // validation for constraint: itemType
            if (!$vehicleChargeTypeCalculationItem instanceof \dgsoft\StructType\DgVehicleChargeTypeCalculation) {
                throw new \InvalidArgumentException(sprintf('The Calculation property can only contain items of \dgsoft\StructType\DgVehicleChargeTypeCalculation, "%s" given', is_object($vehicleChargeTypeCalculationItem) ? get_class($vehicleChargeTypeCalculationItem) : gettype($vehicleChargeTypeCalculationItem)), __LINE__);
            }
        }
        $this->Calculation = $calculation;
        return $this;
    }
    /**
     * Add item to Calculation value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgVehicleChargeTypeCalculation $item
     * @return \dgsoft\StructType\DgVehicleChargeType
     */
    public function addToCalculation(\dgsoft\StructType\DgVehicleChargeTypeCalculation $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \dgsoft\StructType\DgVehicleChargeTypeCalculation) {
            throw new \InvalidArgumentException(sprintf('The Calculation property can only contain items of \dgsoft\StructType\DgVehicleChargeTypeCalculation, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Calculation[] = $item;
        return $this;
    }
    /**
     * Get CurrencyCode value
     * @return string|null
     */
    public function getCurrencyCode()
    {
        return $this->CurrencyCode;
    }
    /**
     * Set CurrencyCode value
     * @param string $currencyCode
     * @return \dgsoft\StructType\DgVehicleChargeType
     */
    public function setCurrencyCode($currencyCode = null)
    {
        // validation for constraint: string
        if (!is_null($currencyCode) && !is_string($currencyCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($currencyCode)), __LINE__);
        }
        $this->CurrencyCode = $currencyCode;
        return $this;
    }
    /**
     * Get FareType value
     * @return string|null
     */
    public function getFareType()
    {
        return $this->FareType;
    }
    /**
     * Set FareType value
     * @param string $fareType
     * @return \dgsoft\StructType\DgVehicleChargeType
     */
    public function setFareType($fareType = null)
    {
        // validation for constraint: string
        if (!is_null($fareType) && !is_string($fareType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($fareType)), __LINE__);
        }
        $this->FareType = $fareType;
        return $this;
    }
    /**
     * Get FareCategory value
     * @return string|null
     */
    public function getFareCategory()
    {
        return $this->FareCategory;
    }
    /**
     * Set FareCategory value
     * @param string $fareCategory
     * @return \dgsoft\StructType\DgVehicleChargeType
     */
    public function setFareCategory($fareCategory = null)
    {
        // validation for constraint: string
        if (!is_null($fareCategory) && !is_string($fareCategory)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($fareCategory)), __LINE__);
        }
        $this->FareCategory = $fareCategory;
        return $this;
    }
    /**
     * Get Amount value
     * @return float|null
     */
    public function getAmount()
    {
        return $this->Amount;
    }
    /**
     * Set Amount value
     * @param float $amount
     * @return \dgsoft\StructType\DgVehicleChargeType
     */
    public function setAmount($amount = null)
    {
        $this->Amount = $amount;
        return $this;
    }
    /**
     * Get MarkupAmount value
     * @return float|null
     */
    public function getMarkupAmount()
    {
        return $this->MarkupAmount;
    }
    /**
     * Set MarkupAmount value
     * @param float $markupAmount
     * @return \dgsoft\StructType\DgVehicleChargeType
     */
    public function setMarkupAmount($markupAmount = null)
    {
        $this->MarkupAmount = $markupAmount;
        return $this;
    }
    /**
     * Get TaxInclusive value
     * @return bool|null
     */
    public function getTaxInclusive()
    {
        return $this->TaxInclusive;
    }
    /**
     * Set TaxInclusive value
     * @param bool $taxInclusive
     * @return \dgsoft\StructType\DgVehicleChargeType
     */
    public function setTaxInclusive($taxInclusive = null)
    {
        // validation for constraint: boolean
        if (!is_null($taxInclusive) && !is_bool($taxInclusive)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($taxInclusive)), __LINE__);
        }
        $this->TaxInclusive = $taxInclusive;
        return $this;
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \dgsoft\StructType\DgVehicleChargeType
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Get GuaranteedInd value
     * @return bool|null
     */
    public function getGuaranteedInd()
    {
        return $this->GuaranteedInd;
    }
    /**
     * Set GuaranteedInd value
     * @param bool $guaranteedInd
     * @return \dgsoft\StructType\DgVehicleChargeType
     */
    public function setGuaranteedInd($guaranteedInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($guaranteedInd) && !is_bool($guaranteedInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($guaranteedInd)), __LINE__);
        }
        $this->GuaranteedInd = $guaranteedInd;
        return $this;
    }
    /**
     * Get IncludedInRate value
     * @return bool|null
     */
    public function getIncludedInRate()
    {
        return $this->IncludedInRate;
    }
    /**
     * Set IncludedInRate value
     * @param bool $includedInRate
     * @return \dgsoft\StructType\DgVehicleChargeType
     */
    public function setIncludedInRate($includedInRate = false)
    {
        // validation for constraint: boolean
        if (!is_null($includedInRate) && !is_bool($includedInRate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($includedInRate)), __LINE__);
        }
        $this->IncludedInRate = $includedInRate;
        return $this;
    }
    /**
     * Get IncludedInEstTotalInd value
     * @return bool|null
     */
    public function getIncludedInEstTotalInd()
    {
        return $this->IncludedInEstTotalInd;
    }
    /**
     * Set IncludedInEstTotalInd value
     * @param bool $includedInEstTotalInd
     * @return \dgsoft\StructType\DgVehicleChargeType
     */
    public function setIncludedInEstTotalInd($includedInEstTotalInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($includedInEstTotalInd) && !is_bool($includedInEstTotalInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($includedInEstTotalInd)), __LINE__);
        }
        $this->IncludedInEstTotalInd = $includedInEstTotalInd;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\StructType\DgVehicleChargeType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
