<?php

namespace dgsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for VehicleAvailVendorInfoType StructType
 * @package Dg
 * @subpackage Structs
 */
class DgVehicleAvailVendorInfoType extends AbstractStructBase
{
    /**
     * The VendorMessages
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\ArrayType\DgArrayOfVendorMessageType
     */
    public $VendorMessages;
    /**
     * The OffLocServices
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgOffLocationServicePricedType[]
     */
    public $OffLocServices;
    /**
     * The PaymentRules
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\ArrayType\DgArrayOfMonetaryRuleType
     */
    public $PaymentRules;
    /**
     * The LocationDetails
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgVehicleLocationDetailsType[]
     */
    public $LocationDetails;
    /**
     * The TourInfo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgVehicleTourInfoType
     */
    public $TourInfo;
    /**
     * The TPA_Extensions
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgTPA_ExtensionsType
     */
    public $TPA_Extensions;
    /**
     * Constructor method for VehicleAvailVendorInfoType
     * @uses DgVehicleAvailVendorInfoType::setVendorMessages()
     * @uses DgVehicleAvailVendorInfoType::setOffLocServices()
     * @uses DgVehicleAvailVendorInfoType::setPaymentRules()
     * @uses DgVehicleAvailVendorInfoType::setLocationDetails()
     * @uses DgVehicleAvailVendorInfoType::setTourInfo()
     * @uses DgVehicleAvailVendorInfoType::setTPA_Extensions()
     * @param \dgsoft\ArrayType\DgArrayOfVendorMessageType $vendorMessages
     * @param \dgsoft\StructType\DgOffLocationServicePricedType[] $offLocServices
     * @param \dgsoft\ArrayType\DgArrayOfMonetaryRuleType $paymentRules
     * @param \dgsoft\StructType\DgVehicleLocationDetailsType[] $locationDetails
     * @param \dgsoft\StructType\DgVehicleTourInfoType $tourInfo
     * @param \dgsoft\StructType\DgTPA_ExtensionsType $tPA_Extensions
     */
    public function __construct(\dgsoft\ArrayType\DgArrayOfVendorMessageType $vendorMessages = null, array $offLocServices = array(), \dgsoft\ArrayType\DgArrayOfMonetaryRuleType $paymentRules = null, array $locationDetails = array(), \dgsoft\StructType\DgVehicleTourInfoType $tourInfo = null, \dgsoft\StructType\DgTPA_ExtensionsType $tPA_Extensions = null)
    {
        $this
            ->setVendorMessages($vendorMessages)
            ->setOffLocServices($offLocServices)
            ->setPaymentRules($paymentRules)
            ->setLocationDetails($locationDetails)
            ->setTourInfo($tourInfo)
            ->setTPA_Extensions($tPA_Extensions);
    }
    /**
     * Get VendorMessages value
     * @return \dgsoft\ArrayType\DgArrayOfVendorMessageType|null
     */
    public function getVendorMessages()
    {
        return $this->VendorMessages;
    }
    /**
     * Set VendorMessages value
     * @param \dgsoft\ArrayType\DgArrayOfVendorMessageType $vendorMessages
     * @return \dgsoft\StructType\DgVehicleAvailVendorInfoType
     */
    public function setVendorMessages(\dgsoft\ArrayType\DgArrayOfVendorMessageType $vendorMessages = null)
    {
        $this->VendorMessages = $vendorMessages;
        return $this;
    }
    /**
     * Get OffLocServices value
     * @return \dgsoft\StructType\DgOffLocationServicePricedType[]|null
     */
    public function getOffLocServices()
    {
        return $this->OffLocServices;
    }
    /**
     * Set OffLocServices value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgOffLocationServicePricedType[] $offLocServices
     * @return \dgsoft\StructType\DgVehicleAvailVendorInfoType
     */
    public function setOffLocServices(array $offLocServices = array())
    {
        foreach ($offLocServices as $vehicleAvailVendorInfoTypeOffLocServicesItem) {
            // validation for constraint: itemType
            if (!$vehicleAvailVendorInfoTypeOffLocServicesItem instanceof \dgsoft\StructType\DgOffLocationServicePricedType) {
                throw new \InvalidArgumentException(sprintf('The OffLocServices property can only contain items of \dgsoft\StructType\DgOffLocationServicePricedType, "%s" given', is_object($vehicleAvailVendorInfoTypeOffLocServicesItem) ? get_class($vehicleAvailVendorInfoTypeOffLocServicesItem) : gettype($vehicleAvailVendorInfoTypeOffLocServicesItem)), __LINE__);
            }
        }
        $this->OffLocServices = $offLocServices;
        return $this;
    }
    /**
     * Add item to OffLocServices value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgOffLocationServicePricedType $item
     * @return \dgsoft\StructType\DgVehicleAvailVendorInfoType
     */
    public function addToOffLocServices(\dgsoft\StructType\DgOffLocationServicePricedType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \dgsoft\StructType\DgOffLocationServicePricedType) {
            throw new \InvalidArgumentException(sprintf('The OffLocServices property can only contain items of \dgsoft\StructType\DgOffLocationServicePricedType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->OffLocServices[] = $item;
        return $this;
    }
    /**
     * Get PaymentRules value
     * @return \dgsoft\ArrayType\DgArrayOfMonetaryRuleType|null
     */
    public function getPaymentRules()
    {
        return $this->PaymentRules;
    }
    /**
     * Set PaymentRules value
     * @param \dgsoft\ArrayType\DgArrayOfMonetaryRuleType $paymentRules
     * @return \dgsoft\StructType\DgVehicleAvailVendorInfoType
     */
    public function setPaymentRules(\dgsoft\ArrayType\DgArrayOfMonetaryRuleType $paymentRules = null)
    {
        $this->PaymentRules = $paymentRules;
        return $this;
    }
    /**
     * Get LocationDetails value
     * @return \dgsoft\StructType\DgVehicleLocationDetailsType[]|null
     */
    public function getLocationDetails()
    {
        return $this->LocationDetails;
    }
    /**
     * Set LocationDetails value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgVehicleLocationDetailsType[] $locationDetails
     * @return \dgsoft\StructType\DgVehicleAvailVendorInfoType
     */
    public function setLocationDetails(array $locationDetails = array())
    {
        foreach ($locationDetails as $vehicleAvailVendorInfoTypeLocationDetailsItem) {
            // validation for constraint: itemType
            if (!$vehicleAvailVendorInfoTypeLocationDetailsItem instanceof \dgsoft\StructType\DgVehicleLocationDetailsType) {
                throw new \InvalidArgumentException(sprintf('The LocationDetails property can only contain items of \dgsoft\StructType\DgVehicleLocationDetailsType, "%s" given', is_object($vehicleAvailVendorInfoTypeLocationDetailsItem) ? get_class($vehicleAvailVendorInfoTypeLocationDetailsItem) : gettype($vehicleAvailVendorInfoTypeLocationDetailsItem)), __LINE__);
            }
        }
        $this->LocationDetails = $locationDetails;
        return $this;
    }
    /**
     * Add item to LocationDetails value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgVehicleLocationDetailsType $item
     * @return \dgsoft\StructType\DgVehicleAvailVendorInfoType
     */
    public function addToLocationDetails(\dgsoft\StructType\DgVehicleLocationDetailsType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \dgsoft\StructType\DgVehicleLocationDetailsType) {
            throw new \InvalidArgumentException(sprintf('The LocationDetails property can only contain items of \dgsoft\StructType\DgVehicleLocationDetailsType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->LocationDetails[] = $item;
        return $this;
    }
    /**
     * Get TourInfo value
     * @return \dgsoft\StructType\DgVehicleTourInfoType|null
     */
    public function getTourInfo()
    {
        return $this->TourInfo;
    }
    /**
     * Set TourInfo value
     * @param \dgsoft\StructType\DgVehicleTourInfoType $tourInfo
     * @return \dgsoft\StructType\DgVehicleAvailVendorInfoType
     */
    public function setTourInfo(\dgsoft\StructType\DgVehicleTourInfoType $tourInfo = null)
    {
        $this->TourInfo = $tourInfo;
        return $this;
    }
    /**
     * Get TPA_Extensions value
     * @return \dgsoft\StructType\DgTPA_ExtensionsType|null
     */
    public function getTPA_Extensions()
    {
        return $this->TPA_Extensions;
    }
    /**
     * Set TPA_Extensions value
     * @param \dgsoft\StructType\DgTPA_ExtensionsType $tPA_Extensions
     * @return \dgsoft\StructType\DgVehicleAvailVendorInfoType
     */
    public function setTPA_Extensions(\dgsoft\StructType\DgTPA_ExtensionsType $tPA_Extensions = null)
    {
        $this->TPA_Extensions = $tPA_Extensions;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\StructType\DgVehicleAvailVendorInfoType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
