<?php

namespace dgsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for VehicleAvailRQCoreTypeVendorPrefs StructType
 * @package Dg
 * @subpackage Structs
 */
class DgVehicleAvailRQCoreTypeVendorPrefs extends AbstractStructBase
{
    /**
     * The VendorPref
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgVehicleAvailRQCoreTypeVendorPrefsVendorPref[]
     */
    public $VendorPref;
    /**
     * The ParticipationLevelCode
     * @var string
     */
    public $ParticipationLevelCode;
    /**
     * The LocationCategory
     * @var string
     */
    public $LocationCategory;
    /**
     * Constructor method for VehicleAvailRQCoreTypeVendorPrefs
     * @uses DgVehicleAvailRQCoreTypeVendorPrefs::setVendorPref()
     * @uses DgVehicleAvailRQCoreTypeVendorPrefs::setParticipationLevelCode()
     * @uses DgVehicleAvailRQCoreTypeVendorPrefs::setLocationCategory()
     * @param \dgsoft\StructType\DgVehicleAvailRQCoreTypeVendorPrefsVendorPref[] $vendorPref
     * @param string $participationLevelCode
     * @param string $locationCategory
     */
    public function __construct(array $vendorPref = array(), $participationLevelCode = null, $locationCategory = null)
    {
        $this
            ->setVendorPref($vendorPref)
            ->setParticipationLevelCode($participationLevelCode)
            ->setLocationCategory($locationCategory);
    }
    /**
     * Get VendorPref value
     * @return \dgsoft\StructType\DgVehicleAvailRQCoreTypeVendorPrefsVendorPref[]|null
     */
    public function getVendorPref()
    {
        return $this->VendorPref;
    }
    /**
     * Set VendorPref value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgVehicleAvailRQCoreTypeVendorPrefsVendorPref[] $vendorPref
     * @return \dgsoft\StructType\DgVehicleAvailRQCoreTypeVendorPrefs
     */
    public function setVendorPref(array $vendorPref = array())
    {
        foreach ($vendorPref as $vehicleAvailRQCoreTypeVendorPrefsVendorPrefItem) {
            // validation for constraint: itemType
            if (!$vehicleAvailRQCoreTypeVendorPrefsVendorPrefItem instanceof \dgsoft\StructType\DgVehicleAvailRQCoreTypeVendorPrefsVendorPref) {
                throw new \InvalidArgumentException(sprintf('The VendorPref property can only contain items of \dgsoft\StructType\DgVehicleAvailRQCoreTypeVendorPrefsVendorPref, "%s" given', is_object($vehicleAvailRQCoreTypeVendorPrefsVendorPrefItem) ? get_class($vehicleAvailRQCoreTypeVendorPrefsVendorPrefItem) : gettype($vehicleAvailRQCoreTypeVendorPrefsVendorPrefItem)), __LINE__);
            }
        }
        $this->VendorPref = $vendorPref;
        return $this;
    }
    /**
     * Add item to VendorPref value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgVehicleAvailRQCoreTypeVendorPrefsVendorPref $item
     * @return \dgsoft\StructType\DgVehicleAvailRQCoreTypeVendorPrefs
     */
    public function addToVendorPref(\dgsoft\StructType\DgVehicleAvailRQCoreTypeVendorPrefsVendorPref $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \dgsoft\StructType\DgVehicleAvailRQCoreTypeVendorPrefsVendorPref) {
            throw new \InvalidArgumentException(sprintf('The VendorPref property can only contain items of \dgsoft\StructType\DgVehicleAvailRQCoreTypeVendorPrefsVendorPref, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->VendorPref[] = $item;
        return $this;
    }
    /**
     * Get ParticipationLevelCode value
     * @return string|null
     */
    public function getParticipationLevelCode()
    {
        return $this->ParticipationLevelCode;
    }
    /**
     * Set ParticipationLevelCode value
     * @param string $participationLevelCode
     * @return \dgsoft\StructType\DgVehicleAvailRQCoreTypeVendorPrefs
     */
    public function setParticipationLevelCode($participationLevelCode = null)
    {
        // validation for constraint: string
        if (!is_null($participationLevelCode) && !is_string($participationLevelCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($participationLevelCode)), __LINE__);
        }
        $this->ParticipationLevelCode = $participationLevelCode;
        return $this;
    }
    /**
     * Get LocationCategory value
     * @return string|null
     */
    public function getLocationCategory()
    {
        return $this->LocationCategory;
    }
    /**
     * Set LocationCategory value
     * @param string $locationCategory
     * @return \dgsoft\StructType\DgVehicleAvailRQCoreTypeVendorPrefs
     */
    public function setLocationCategory($locationCategory = null)
    {
        // validation for constraint: string
        if (!is_null($locationCategory) && !is_string($locationCategory)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($locationCategory)), __LINE__);
        }
        $this->LocationCategory = $locationCategory;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\StructType\DgVehicleAvailRQCoreTypeVendorPrefs
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
