<?php

namespace dgsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for VehicleAvailRQAdditionalInfoType StructType
 * @package Dg
 * @subpackage Structs
 */
class DgVehicleAvailRQAdditionalInfoType extends AbstractStructBase
{
    /**
     * The Customer
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgCustomerPrimaryAdditionalType
     */
    public $Customer;
    /**
     * The SpecialReqPref
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgVehicleSpecialReqPrefType[]
     */
    public $SpecialReqPref;
    /**
     * The CoveragePrefs
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\ArrayType\DgArrayOfVehicleAvailRQAdditionalInfoTypeCoveragePref
     */
    public $CoveragePrefs;
    /**
     * The OffLocService
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgOffLocationServiceType[]
     */
    public $OffLocService;
    /**
     * The ArrivalDetails
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgVehicleArrivalDetailsType
     */
    public $ArrivalDetails;
    /**
     * The TourInfo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgVehicleTourInfoType
     */
    public $TourInfo;
    /**
     * The TPA_Extensions
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgTPA_ExtensionsType
     */
    public $TPA_Extensions;
    /**
     * The LuggageQty
     * @var int
     */
    public $LuggageQty;
    /**
     * The PassengerQty
     * @var int
     */
    public $PassengerQty;
    /**
     * The SmokingAllowed
     * Meta informations extracted from the WSDL
     * - default: false
     * @var bool
     */
    public $SmokingAllowed;
    /**
     * The GasPrePay
     * Meta informations extracted from the WSDL
     * - default: false
     * @var bool
     */
    public $GasPrePay;
    /**
     * The SingleQuote
     * @var bool
     */
    public $SingleQuote;
    /**
     * Constructor method for VehicleAvailRQAdditionalInfoType
     * @uses DgVehicleAvailRQAdditionalInfoType::setCustomer()
     * @uses DgVehicleAvailRQAdditionalInfoType::setSpecialReqPref()
     * @uses DgVehicleAvailRQAdditionalInfoType::setCoveragePrefs()
     * @uses DgVehicleAvailRQAdditionalInfoType::setOffLocService()
     * @uses DgVehicleAvailRQAdditionalInfoType::setArrivalDetails()
     * @uses DgVehicleAvailRQAdditionalInfoType::setTourInfo()
     * @uses DgVehicleAvailRQAdditionalInfoType::setTPA_Extensions()
     * @uses DgVehicleAvailRQAdditionalInfoType::setLuggageQty()
     * @uses DgVehicleAvailRQAdditionalInfoType::setPassengerQty()
     * @uses DgVehicleAvailRQAdditionalInfoType::setSmokingAllowed()
     * @uses DgVehicleAvailRQAdditionalInfoType::setGasPrePay()
     * @uses DgVehicleAvailRQAdditionalInfoType::setSingleQuote()
     * @param \dgsoft\StructType\DgCustomerPrimaryAdditionalType $customer
     * @param \dgsoft\StructType\DgVehicleSpecialReqPrefType[] $specialReqPref
     * @param \dgsoft\ArrayType\DgArrayOfVehicleAvailRQAdditionalInfoTypeCoveragePref $coveragePrefs
     * @param \dgsoft\StructType\DgOffLocationServiceType[] $offLocService
     * @param \dgsoft\StructType\DgVehicleArrivalDetailsType $arrivalDetails
     * @param \dgsoft\StructType\DgVehicleTourInfoType $tourInfo
     * @param \dgsoft\StructType\DgTPA_ExtensionsType $tPA_Extensions
     * @param int $luggageQty
     * @param int $passengerQty
     * @param bool $smokingAllowed
     * @param bool $gasPrePay
     * @param bool $singleQuote
     */
    public function __construct(\dgsoft\StructType\DgCustomerPrimaryAdditionalType $customer = null, array $specialReqPref = array(), \dgsoft\ArrayType\DgArrayOfVehicleAvailRQAdditionalInfoTypeCoveragePref $coveragePrefs = null, array $offLocService = array(), \dgsoft\StructType\DgVehicleArrivalDetailsType $arrivalDetails = null, \dgsoft\StructType\DgVehicleTourInfoType $tourInfo = null, \dgsoft\StructType\DgTPA_ExtensionsType $tPA_Extensions = null, $luggageQty = null, $passengerQty = null, $smokingAllowed = false, $gasPrePay = false, $singleQuote = null)
    {
        $this
            ->setCustomer($customer)
            ->setSpecialReqPref($specialReqPref)
            ->setCoveragePrefs($coveragePrefs)
            ->setOffLocService($offLocService)
            ->setArrivalDetails($arrivalDetails)
            ->setTourInfo($tourInfo)
            ->setTPA_Extensions($tPA_Extensions)
            ->setLuggageQty($luggageQty)
            ->setPassengerQty($passengerQty)
            ->setSmokingAllowed($smokingAllowed)
            ->setGasPrePay($gasPrePay)
            ->setSingleQuote($singleQuote);
    }
    /**
     * Get Customer value
     * @return \dgsoft\StructType\DgCustomerPrimaryAdditionalType|null
     */
    public function getCustomer()
    {
        return $this->Customer;
    }
    /**
     * Set Customer value
     * @param \dgsoft\StructType\DgCustomerPrimaryAdditionalType $customer
     * @return \dgsoft\StructType\DgVehicleAvailRQAdditionalInfoType
     */
    public function setCustomer(\dgsoft\StructType\DgCustomerPrimaryAdditionalType $customer = null)
    {
        $this->Customer = $customer;
        return $this;
    }
    /**
     * Get SpecialReqPref value
     * @return \dgsoft\StructType\DgVehicleSpecialReqPrefType[]|null
     */
    public function getSpecialReqPref()
    {
        return $this->SpecialReqPref;
    }
    /**
     * Set SpecialReqPref value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgVehicleSpecialReqPrefType[] $specialReqPref
     * @return \dgsoft\StructType\DgVehicleAvailRQAdditionalInfoType
     */
    public function setSpecialReqPref(array $specialReqPref = array())
    {
        foreach ($specialReqPref as $vehicleAvailRQAdditionalInfoTypeSpecialReqPrefItem) {
            // validation for constraint: itemType
            if (!$vehicleAvailRQAdditionalInfoTypeSpecialReqPrefItem instanceof \dgsoft\StructType\DgVehicleSpecialReqPrefType) {
                throw new \InvalidArgumentException(sprintf('The SpecialReqPref property can only contain items of \dgsoft\StructType\DgVehicleSpecialReqPrefType, "%s" given', is_object($vehicleAvailRQAdditionalInfoTypeSpecialReqPrefItem) ? get_class($vehicleAvailRQAdditionalInfoTypeSpecialReqPrefItem) : gettype($vehicleAvailRQAdditionalInfoTypeSpecialReqPrefItem)), __LINE__);
            }
        }
        $this->SpecialReqPref = $specialReqPref;
        return $this;
    }
    /**
     * Add item to SpecialReqPref value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgVehicleSpecialReqPrefType $item
     * @return \dgsoft\StructType\DgVehicleAvailRQAdditionalInfoType
     */
    public function addToSpecialReqPref(\dgsoft\StructType\DgVehicleSpecialReqPrefType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \dgsoft\StructType\DgVehicleSpecialReqPrefType) {
            throw new \InvalidArgumentException(sprintf('The SpecialReqPref property can only contain items of \dgsoft\StructType\DgVehicleSpecialReqPrefType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->SpecialReqPref[] = $item;
        return $this;
    }
    /**
     * Get CoveragePrefs value
     * @return \dgsoft\ArrayType\DgArrayOfVehicleAvailRQAdditionalInfoTypeCoveragePref|null
     */
    public function getCoveragePrefs()
    {
        return $this->CoveragePrefs;
    }
    /**
     * Set CoveragePrefs value
     * @param \dgsoft\ArrayType\DgArrayOfVehicleAvailRQAdditionalInfoTypeCoveragePref $coveragePrefs
     * @return \dgsoft\StructType\DgVehicleAvailRQAdditionalInfoType
     */
    public function setCoveragePrefs(\dgsoft\ArrayType\DgArrayOfVehicleAvailRQAdditionalInfoTypeCoveragePref $coveragePrefs = null)
    {
        $this->CoveragePrefs = $coveragePrefs;
        return $this;
    }
    /**
     * Get OffLocService value
     * @return \dgsoft\StructType\DgOffLocationServiceType[]|null
     */
    public function getOffLocService()
    {
        return $this->OffLocService;
    }
    /**
     * Set OffLocService value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgOffLocationServiceType[] $offLocService
     * @return \dgsoft\StructType\DgVehicleAvailRQAdditionalInfoType
     */
    public function setOffLocService(array $offLocService = array())
    {
        foreach ($offLocService as $vehicleAvailRQAdditionalInfoTypeOffLocServiceItem) {
            // validation for constraint: itemType
            if (!$vehicleAvailRQAdditionalInfoTypeOffLocServiceItem instanceof \dgsoft\StructType\DgOffLocationServiceType) {
                throw new \InvalidArgumentException(sprintf('The OffLocService property can only contain items of \dgsoft\StructType\DgOffLocationServiceType, "%s" given', is_object($vehicleAvailRQAdditionalInfoTypeOffLocServiceItem) ? get_class($vehicleAvailRQAdditionalInfoTypeOffLocServiceItem) : gettype($vehicleAvailRQAdditionalInfoTypeOffLocServiceItem)), __LINE__);
            }
        }
        $this->OffLocService = $offLocService;
        return $this;
    }
    /**
     * Add item to OffLocService value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgOffLocationServiceType $item
     * @return \dgsoft\StructType\DgVehicleAvailRQAdditionalInfoType
     */
    public function addToOffLocService(\dgsoft\StructType\DgOffLocationServiceType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \dgsoft\StructType\DgOffLocationServiceType) {
            throw new \InvalidArgumentException(sprintf('The OffLocService property can only contain items of \dgsoft\StructType\DgOffLocationServiceType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->OffLocService[] = $item;
        return $this;
    }
    /**
     * Get ArrivalDetails value
     * @return \dgsoft\StructType\DgVehicleArrivalDetailsType|null
     */
    public function getArrivalDetails()
    {
        return $this->ArrivalDetails;
    }
    /**
     * Set ArrivalDetails value
     * @param \dgsoft\StructType\DgVehicleArrivalDetailsType $arrivalDetails
     * @return \dgsoft\StructType\DgVehicleAvailRQAdditionalInfoType
     */
    public function setArrivalDetails(\dgsoft\StructType\DgVehicleArrivalDetailsType $arrivalDetails = null)
    {
        $this->ArrivalDetails = $arrivalDetails;
        return $this;
    }
    /**
     * Get TourInfo value
     * @return \dgsoft\StructType\DgVehicleTourInfoType|null
     */
    public function getTourInfo()
    {
        return $this->TourInfo;
    }
    /**
     * Set TourInfo value
     * @param \dgsoft\StructType\DgVehicleTourInfoType $tourInfo
     * @return \dgsoft\StructType\DgVehicleAvailRQAdditionalInfoType
     */
    public function setTourInfo(\dgsoft\StructType\DgVehicleTourInfoType $tourInfo = null)
    {
        $this->TourInfo = $tourInfo;
        return $this;
    }
    /**
     * Get TPA_Extensions value
     * @return \dgsoft\StructType\DgTPA_ExtensionsType|null
     */
    public function getTPA_Extensions()
    {
        return $this->TPA_Extensions;
    }
    /**
     * Set TPA_Extensions value
     * @param \dgsoft\StructType\DgTPA_ExtensionsType $tPA_Extensions
     * @return \dgsoft\StructType\DgVehicleAvailRQAdditionalInfoType
     */
    public function setTPA_Extensions(\dgsoft\StructType\DgTPA_ExtensionsType $tPA_Extensions = null)
    {
        $this->TPA_Extensions = $tPA_Extensions;
        return $this;
    }
    /**
     * Get LuggageQty value
     * @return int|null
     */
    public function getLuggageQty()
    {
        return $this->LuggageQty;
    }
    /**
     * Set LuggageQty value
     * @param int $luggageQty
     * @return \dgsoft\StructType\DgVehicleAvailRQAdditionalInfoType
     */
    public function setLuggageQty($luggageQty = null)
    {
        // validation for constraint: int
        if (!is_null($luggageQty) && !is_numeric($luggageQty)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($luggageQty)), __LINE__);
        }
        $this->LuggageQty = $luggageQty;
        return $this;
    }
    /**
     * Get PassengerQty value
     * @return int|null
     */
    public function getPassengerQty()
    {
        return $this->PassengerQty;
    }
    /**
     * Set PassengerQty value
     * @param int $passengerQty
     * @return \dgsoft\StructType\DgVehicleAvailRQAdditionalInfoType
     */
    public function setPassengerQty($passengerQty = null)
    {
        // validation for constraint: int
        if (!is_null($passengerQty) && !is_numeric($passengerQty)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($passengerQty)), __LINE__);
        }
        $this->PassengerQty = $passengerQty;
        return $this;
    }
    /**
     * Get SmokingAllowed value
     * @return bool|null
     */
    public function getSmokingAllowed()
    {
        return $this->SmokingAllowed;
    }
    /**
     * Set SmokingAllowed value
     * @param bool $smokingAllowed
     * @return \dgsoft\StructType\DgVehicleAvailRQAdditionalInfoType
     */
    public function setSmokingAllowed($smokingAllowed = false)
    {
        // validation for constraint: boolean
        if (!is_null($smokingAllowed) && !is_bool($smokingAllowed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($smokingAllowed)), __LINE__);
        }
        $this->SmokingAllowed = $smokingAllowed;
        return $this;
    }
    /**
     * Get GasPrePay value
     * @return bool|null
     */
    public function getGasPrePay()
    {
        return $this->GasPrePay;
    }
    /**
     * Set GasPrePay value
     * @param bool $gasPrePay
     * @return \dgsoft\StructType\DgVehicleAvailRQAdditionalInfoType
     */
    public function setGasPrePay($gasPrePay = false)
    {
        // validation for constraint: boolean
        if (!is_null($gasPrePay) && !is_bool($gasPrePay)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($gasPrePay)), __LINE__);
        }
        $this->GasPrePay = $gasPrePay;
        return $this;
    }
    /**
     * Get SingleQuote value
     * @return bool|null
     */
    public function getSingleQuote()
    {
        return $this->SingleQuote;
    }
    /**
     * Set SingleQuote value
     * @param bool $singleQuote
     * @return \dgsoft\StructType\DgVehicleAvailRQAdditionalInfoType
     */
    public function setSingleQuote($singleQuote = null)
    {
        // validation for constraint: boolean
        if (!is_null($singleQuote) && !is_bool($singleQuote)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($singleQuote)), __LINE__);
        }
        $this->SingleQuote = $singleQuote;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\StructType\DgVehicleAvailRQAdditionalInfoType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
