<?php

namespace dgsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for VehicleAvailCoreType StructType
 * @package Dg
 * @subpackage Structs
 */
class DgVehicleAvailCoreType extends AbstractStructBase
{
    /**
     * The Status
     * Meta informations extracted from the WSDL
     * - use: required
     * @var string
     */
    public $Status;
    /**
     * The Vehicle
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgVehicleType
     */
    public $Vehicle;
    /**
     * The RentalRate
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgVehicleRentalRateType[]
     */
    public $RentalRate;
    /**
     * The TotalCharge
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgVehicleAvailCoreTypeTotalCharge[]
     */
    public $TotalCharge;
    /**
     * The PricedEquips
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\ArrayType\DgArrayOfVehicleEquipmentPricedType
     */
    public $PricedEquips;
    /**
     * The Fees
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\ArrayType\DgArrayOfVehicleChargePurposeType1
     */
    public $Fees;
    /**
     * The Reference
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgVehicleAvailCoreTypeReference
     */
    public $Reference;
    /**
     * The Vendor
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgVehicleAvailCoreTypeVendor
     */
    public $Vendor;
    /**
     * The VendorLocation
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgVehicleAvailCoreTypeVendorLocation
     */
    public $VendorLocation;
    /**
     * The DropOffLocation
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgVehicleAvailCoreTypeDropOffLocation
     */
    public $DropOffLocation;
    /**
     * The TPA_Extensions
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgTPA_ExtensionsType
     */
    public $TPA_Extensions;
    /**
     * The IsAlternateInd
     * @var bool
     */
    public $IsAlternateInd;
    /**
     * Constructor method for VehicleAvailCoreType
     * @uses DgVehicleAvailCoreType::setStatus()
     * @uses DgVehicleAvailCoreType::setVehicle()
     * @uses DgVehicleAvailCoreType::setRentalRate()
     * @uses DgVehicleAvailCoreType::setTotalCharge()
     * @uses DgVehicleAvailCoreType::setPricedEquips()
     * @uses DgVehicleAvailCoreType::setFees()
     * @uses DgVehicleAvailCoreType::setReference()
     * @uses DgVehicleAvailCoreType::setVendor()
     * @uses DgVehicleAvailCoreType::setVendorLocation()
     * @uses DgVehicleAvailCoreType::setDropOffLocation()
     * @uses DgVehicleAvailCoreType::setTPA_Extensions()
     * @uses DgVehicleAvailCoreType::setIsAlternateInd()
     * @param string $status
     * @param \dgsoft\StructType\DgVehicleType $vehicle
     * @param \dgsoft\StructType\DgVehicleRentalRateType[] $rentalRate
     * @param \dgsoft\StructType\DgVehicleAvailCoreTypeTotalCharge[] $totalCharge
     * @param \dgsoft\ArrayType\DgArrayOfVehicleEquipmentPricedType $pricedEquips
     * @param \dgsoft\ArrayType\DgArrayOfVehicleChargePurposeType1 $fees
     * @param \dgsoft\StructType\DgVehicleAvailCoreTypeReference $reference
     * @param \dgsoft\StructType\DgVehicleAvailCoreTypeVendor $vendor
     * @param \dgsoft\StructType\DgVehicleAvailCoreTypeVendorLocation $vendorLocation
     * @param \dgsoft\StructType\DgVehicleAvailCoreTypeDropOffLocation $dropOffLocation
     * @param \dgsoft\StructType\DgTPA_ExtensionsType $tPA_Extensions
     * @param bool $isAlternateInd
     */
    public function __construct($status = null, \dgsoft\StructType\DgVehicleType $vehicle = null, array $rentalRate = array(), array $totalCharge = array(), \dgsoft\ArrayType\DgArrayOfVehicleEquipmentPricedType $pricedEquips = null, \dgsoft\ArrayType\DgArrayOfVehicleChargePurposeType1 $fees = null, \dgsoft\StructType\DgVehicleAvailCoreTypeReference $reference = null, \dgsoft\StructType\DgVehicleAvailCoreTypeVendor $vendor = null, \dgsoft\StructType\DgVehicleAvailCoreTypeVendorLocation $vendorLocation = null, \dgsoft\StructType\DgVehicleAvailCoreTypeDropOffLocation $dropOffLocation = null, \dgsoft\StructType\DgTPA_ExtensionsType $tPA_Extensions = null, $isAlternateInd = null)
    {
        $this
            ->setStatus($status)
            ->setVehicle($vehicle)
            ->setRentalRate($rentalRate)
            ->setTotalCharge($totalCharge)
            ->setPricedEquips($pricedEquips)
            ->setFees($fees)
            ->setReference($reference)
            ->setVendor($vendor)
            ->setVendorLocation($vendorLocation)
            ->setDropOffLocation($dropOffLocation)
            ->setTPA_Extensions($tPA_Extensions)
            ->setIsAlternateInd($isAlternateInd);
    }
    /**
     * Get Status value
     * @return string
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @uses \dgsoft\EnumType\DgInventoryStatusType::valueIsValid()
     * @uses \dgsoft\EnumType\DgInventoryStatusType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $status
     * @return \dgsoft\StructType\DgVehicleAvailCoreType
     */
    public function setStatus($status = null)
    {
        // validation for constraint: enumeration
        if (!\dgsoft\EnumType\DgInventoryStatusType::valueIsValid($status)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $status, implode(', ', \dgsoft\EnumType\DgInventoryStatusType::getValidValues())), __LINE__);
        }
        $this->Status = $status;
        return $this;
    }
    /**
     * Get Vehicle value
     * @return \dgsoft\StructType\DgVehicleType|null
     */
    public function getVehicle()
    {
        return $this->Vehicle;
    }
    /**
     * Set Vehicle value
     * @param \dgsoft\StructType\DgVehicleType $vehicle
     * @return \dgsoft\StructType\DgVehicleAvailCoreType
     */
    public function setVehicle(\dgsoft\StructType\DgVehicleType $vehicle = null)
    {
        $this->Vehicle = $vehicle;
        return $this;
    }
    /**
     * Get RentalRate value
     * @return \dgsoft\StructType\DgVehicleRentalRateType[]|null
     */
    public function getRentalRate()
    {
        return $this->RentalRate;
    }
    /**
     * Set RentalRate value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgVehicleRentalRateType[] $rentalRate
     * @return \dgsoft\StructType\DgVehicleAvailCoreType
     */
    public function setRentalRate(array $rentalRate = array())
    {
        foreach ($rentalRate as $vehicleAvailCoreTypeRentalRateItem) {
            // validation for constraint: itemType
            if (!$vehicleAvailCoreTypeRentalRateItem instanceof \dgsoft\StructType\DgVehicleRentalRateType) {
                throw new \InvalidArgumentException(sprintf('The RentalRate property can only contain items of \dgsoft\StructType\DgVehicleRentalRateType, "%s" given', is_object($vehicleAvailCoreTypeRentalRateItem) ? get_class($vehicleAvailCoreTypeRentalRateItem) : gettype($vehicleAvailCoreTypeRentalRateItem)), __LINE__);
            }
        }
        $this->RentalRate = $rentalRate;
        return $this;
    }
    /**
     * Add item to RentalRate value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgVehicleRentalRateType $item
     * @return \dgsoft\StructType\DgVehicleAvailCoreType
     */
    public function addToRentalRate(\dgsoft\StructType\DgVehicleRentalRateType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \dgsoft\StructType\DgVehicleRentalRateType) {
            throw new \InvalidArgumentException(sprintf('The RentalRate property can only contain items of \dgsoft\StructType\DgVehicleRentalRateType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->RentalRate[] = $item;
        return $this;
    }
    /**
     * Get TotalCharge value
     * @return \dgsoft\StructType\DgVehicleAvailCoreTypeTotalCharge[]|null
     */
    public function getTotalCharge()
    {
        return $this->TotalCharge;
    }
    /**
     * Set TotalCharge value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgVehicleAvailCoreTypeTotalCharge[] $totalCharge
     * @return \dgsoft\StructType\DgVehicleAvailCoreType
     */
    public function setTotalCharge(array $totalCharge = array())
    {
        foreach ($totalCharge as $vehicleAvailCoreTypeTotalChargeItem) {
            // validation for constraint: itemType
            if (!$vehicleAvailCoreTypeTotalChargeItem instanceof \dgsoft\StructType\DgVehicleAvailCoreTypeTotalCharge) {
                throw new \InvalidArgumentException(sprintf('The TotalCharge property can only contain items of \dgsoft\StructType\DgVehicleAvailCoreTypeTotalCharge, "%s" given', is_object($vehicleAvailCoreTypeTotalChargeItem) ? get_class($vehicleAvailCoreTypeTotalChargeItem) : gettype($vehicleAvailCoreTypeTotalChargeItem)), __LINE__);
            }
        }
        $this->TotalCharge = $totalCharge;
        return $this;
    }
    /**
     * Add item to TotalCharge value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgVehicleAvailCoreTypeTotalCharge $item
     * @return \dgsoft\StructType\DgVehicleAvailCoreType
     */
    public function addToTotalCharge(\dgsoft\StructType\DgVehicleAvailCoreTypeTotalCharge $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \dgsoft\StructType\DgVehicleAvailCoreTypeTotalCharge) {
            throw new \InvalidArgumentException(sprintf('The TotalCharge property can only contain items of \dgsoft\StructType\DgVehicleAvailCoreTypeTotalCharge, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->TotalCharge[] = $item;
        return $this;
    }
    /**
     * Get PricedEquips value
     * @return \dgsoft\ArrayType\DgArrayOfVehicleEquipmentPricedType|null
     */
    public function getPricedEquips()
    {
        return $this->PricedEquips;
    }
    /**
     * Set PricedEquips value
     * @param \dgsoft\ArrayType\DgArrayOfVehicleEquipmentPricedType $pricedEquips
     * @return \dgsoft\StructType\DgVehicleAvailCoreType
     */
    public function setPricedEquips(\dgsoft\ArrayType\DgArrayOfVehicleEquipmentPricedType $pricedEquips = null)
    {
        $this->PricedEquips = $pricedEquips;
        return $this;
    }
    /**
     * Get Fees value
     * @return \dgsoft\ArrayType\DgArrayOfVehicleChargePurposeType1|null
     */
    public function getFees()
    {
        return $this->Fees;
    }
    /**
     * Set Fees value
     * @param \dgsoft\ArrayType\DgArrayOfVehicleChargePurposeType1 $fees
     * @return \dgsoft\StructType\DgVehicleAvailCoreType
     */
    public function setFees(\dgsoft\ArrayType\DgArrayOfVehicleChargePurposeType1 $fees = null)
    {
        $this->Fees = $fees;
        return $this;
    }
    /**
     * Get Reference value
     * @return \dgsoft\StructType\DgVehicleAvailCoreTypeReference|null
     */
    public function getReference()
    {
        return $this->Reference;
    }
    /**
     * Set Reference value
     * @param \dgsoft\StructType\DgVehicleAvailCoreTypeReference $reference
     * @return \dgsoft\StructType\DgVehicleAvailCoreType
     */
    public function setReference(\dgsoft\StructType\DgVehicleAvailCoreTypeReference $reference = null)
    {
        $this->Reference = $reference;
        return $this;
    }
    /**
     * Get Vendor value
     * @return \dgsoft\StructType\DgVehicleAvailCoreTypeVendor|null
     */
    public function getVendor()
    {
        return $this->Vendor;
    }
    /**
     * Set Vendor value
     * @param \dgsoft\StructType\DgVehicleAvailCoreTypeVendor $vendor
     * @return \dgsoft\StructType\DgVehicleAvailCoreType
     */
    public function setVendor(\dgsoft\StructType\DgVehicleAvailCoreTypeVendor $vendor = null)
    {
        $this->Vendor = $vendor;
        return $this;
    }
    /**
     * Get VendorLocation value
     * @return \dgsoft\StructType\DgVehicleAvailCoreTypeVendorLocation|null
     */
    public function getVendorLocation()
    {
        return $this->VendorLocation;
    }
    /**
     * Set VendorLocation value
     * @param \dgsoft\StructType\DgVehicleAvailCoreTypeVendorLocation $vendorLocation
     * @return \dgsoft\StructType\DgVehicleAvailCoreType
     */
    public function setVendorLocation(\dgsoft\StructType\DgVehicleAvailCoreTypeVendorLocation $vendorLocation = null)
    {
        $this->VendorLocation = $vendorLocation;
        return $this;
    }
    /**
     * Get DropOffLocation value
     * @return \dgsoft\StructType\DgVehicleAvailCoreTypeDropOffLocation|null
     */
    public function getDropOffLocation()
    {
        return $this->DropOffLocation;
    }
    /**
     * Set DropOffLocation value
     * @param \dgsoft\StructType\DgVehicleAvailCoreTypeDropOffLocation $dropOffLocation
     * @return \dgsoft\StructType\DgVehicleAvailCoreType
     */
    public function setDropOffLocation(\dgsoft\StructType\DgVehicleAvailCoreTypeDropOffLocation $dropOffLocation = null)
    {
        $this->DropOffLocation = $dropOffLocation;
        return $this;
    }
    /**
     * Get TPA_Extensions value
     * @return \dgsoft\StructType\DgTPA_ExtensionsType|null
     */
    public function getTPA_Extensions()
    {
        return $this->TPA_Extensions;
    }
    /**
     * Set TPA_Extensions value
     * @param \dgsoft\StructType\DgTPA_ExtensionsType $tPA_Extensions
     * @return \dgsoft\StructType\DgVehicleAvailCoreType
     */
    public function setTPA_Extensions(\dgsoft\StructType\DgTPA_ExtensionsType $tPA_Extensions = null)
    {
        $this->TPA_Extensions = $tPA_Extensions;
        return $this;
    }
    /**
     * Get IsAlternateInd value
     * @return bool|null
     */
    public function getIsAlternateInd()
    {
        return $this->IsAlternateInd;
    }
    /**
     * Set IsAlternateInd value
     * @param bool $isAlternateInd
     * @return \dgsoft\StructType\DgVehicleAvailCoreType
     */
    public function setIsAlternateInd($isAlternateInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($isAlternateInd) && !is_bool($isAlternateInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isAlternateInd)), __LINE__);
        }
        $this->IsAlternateInd = $isAlternateInd;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\StructType\DgVehicleAvailCoreType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
