<?php

namespace dgsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for VehicleAvailAdditionalInfoType StructType
 * @package Dg
 * @subpackage Structs
 */
class DgVehicleAvailAdditionalInfoType extends AbstractStructBase
{
    /**
     * The PricedCoverages
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\ArrayType\DgArrayOfCoveragePricedType
     */
    public $PricedCoverages;
    /**
     * The PaymentRules
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\ArrayType\DgArrayOfMonetaryRuleType
     */
    public $PaymentRules;
    /**
     * The TPA_Extensions
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgTPA_ExtensionsType
     */
    public $TPA_Extensions;
    /**
     * The ChargeablePeriod
     * @var string
     */
    public $ChargeablePeriod;
    /**
     * Constructor method for VehicleAvailAdditionalInfoType
     * @uses DgVehicleAvailAdditionalInfoType::setPricedCoverages()
     * @uses DgVehicleAvailAdditionalInfoType::setPaymentRules()
     * @uses DgVehicleAvailAdditionalInfoType::setTPA_Extensions()
     * @uses DgVehicleAvailAdditionalInfoType::setChargeablePeriod()
     * @param \dgsoft\ArrayType\DgArrayOfCoveragePricedType $pricedCoverages
     * @param \dgsoft\ArrayType\DgArrayOfMonetaryRuleType $paymentRules
     * @param \dgsoft\StructType\DgTPA_ExtensionsType $tPA_Extensions
     * @param string $chargeablePeriod
     */
    public function __construct(\dgsoft\ArrayType\DgArrayOfCoveragePricedType $pricedCoverages = null, \dgsoft\ArrayType\DgArrayOfMonetaryRuleType $paymentRules = null, \dgsoft\StructType\DgTPA_ExtensionsType $tPA_Extensions = null, $chargeablePeriod = null)
    {
        $this
            ->setPricedCoverages($pricedCoverages)
            ->setPaymentRules($paymentRules)
            ->setTPA_Extensions($tPA_Extensions)
            ->setChargeablePeriod($chargeablePeriod);
    }
    /**
     * Get PricedCoverages value
     * @return \dgsoft\ArrayType\DgArrayOfCoveragePricedType|null
     */
    public function getPricedCoverages()
    {
        return $this->PricedCoverages;
    }
    /**
     * Set PricedCoverages value
     * @param \dgsoft\ArrayType\DgArrayOfCoveragePricedType $pricedCoverages
     * @return \dgsoft\StructType\DgVehicleAvailAdditionalInfoType
     */
    public function setPricedCoverages(\dgsoft\ArrayType\DgArrayOfCoveragePricedType $pricedCoverages = null)
    {
        $this->PricedCoverages = $pricedCoverages;
        return $this;
    }
    /**
     * Get PaymentRules value
     * @return \dgsoft\ArrayType\DgArrayOfMonetaryRuleType|null
     */
    public function getPaymentRules()
    {
        return $this->PaymentRules;
    }
    /**
     * Set PaymentRules value
     * @param \dgsoft\ArrayType\DgArrayOfMonetaryRuleType $paymentRules
     * @return \dgsoft\StructType\DgVehicleAvailAdditionalInfoType
     */
    public function setPaymentRules(\dgsoft\ArrayType\DgArrayOfMonetaryRuleType $paymentRules = null)
    {
        $this->PaymentRules = $paymentRules;
        return $this;
    }
    /**
     * Get TPA_Extensions value
     * @return \dgsoft\StructType\DgTPA_ExtensionsType|null
     */
    public function getTPA_Extensions()
    {
        return $this->TPA_Extensions;
    }
    /**
     * Set TPA_Extensions value
     * @param \dgsoft\StructType\DgTPA_ExtensionsType $tPA_Extensions
     * @return \dgsoft\StructType\DgVehicleAvailAdditionalInfoType
     */
    public function setTPA_Extensions(\dgsoft\StructType\DgTPA_ExtensionsType $tPA_Extensions = null)
    {
        $this->TPA_Extensions = $tPA_Extensions;
        return $this;
    }
    /**
     * Get ChargeablePeriod value
     * @return string|null
     */
    public function getChargeablePeriod()
    {
        return $this->ChargeablePeriod;
    }
    /**
     * Set ChargeablePeriod value
     * @param string $chargeablePeriod
     * @return \dgsoft\StructType\DgVehicleAvailAdditionalInfoType
     */
    public function setChargeablePeriod($chargeablePeriod = null)
    {
        // validation for constraint: string
        if (!is_null($chargeablePeriod) && !is_string($chargeablePeriod)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($chargeablePeriod)), __LINE__);
        }
        $this->ChargeablePeriod = $chargeablePeriod;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\StructType\DgVehicleAvailAdditionalInfoType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
