<?php

namespace dgsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for VehType StructType
 * @package Dg
 * @subpackage Structs
 */
class DgVehType extends AbstractStructBase
{
    /**
     * The VehicleCategory
     * @var string
     */
    public $VehicleCategory;
    /**
     * The DoorCount
     * @var string
     */
    public $DoorCount;
    /**
     * Constructor method for VehType
     * @uses DgVehType::setVehicleCategory()
     * @uses DgVehType::setDoorCount()
     * @param string $vehicleCategory
     * @param string $doorCount
     */
    public function __construct($vehicleCategory = null, $doorCount = null)
    {
        $this
            ->setVehicleCategory($vehicleCategory)
            ->setDoorCount($doorCount);
    }
    /**
     * Get VehicleCategory value
     * @return string|null
     */
    public function getVehicleCategory()
    {
        return $this->VehicleCategory;
    }
    /**
     * Set VehicleCategory value
     * @param string $vehicleCategory
     * @return \dgsoft\StructType\DgVehType
     */
    public function setVehicleCategory($vehicleCategory = null)
    {
        // validation for constraint: string
        if (!is_null($vehicleCategory) && !is_string($vehicleCategory)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($vehicleCategory)), __LINE__);
        }
        $this->VehicleCategory = $vehicleCategory;
        return $this;
    }
    /**
     * Get DoorCount value
     * @return string|null
     */
    public function getDoorCount()
    {
        return $this->DoorCount;
    }
    /**
     * Set DoorCount value
     * @param string $doorCount
     * @return \dgsoft\StructType\DgVehType
     */
    public function setDoorCount($doorCount = null)
    {
        // validation for constraint: string
        if (!is_null($doorCount) && !is_string($doorCount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($doorCount)), __LINE__);
        }
        $this->DoorCount = $doorCount;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\StructType\DgVehType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
