<?php

namespace dgsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ValidationError StructType
 * @package Dg
 * @subpackage Structs
 */
class DgValidationError extends AbstractStructBase
{
    /**
     * The ErrorCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $ErrorCode;
    /**
     * The ErrorType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $ErrorType;
    /**
     * The ErrorCategory
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $ErrorCategory;
    /**
     * The RelatedEntityPropertyName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $RelatedEntityPropertyName;
    /**
     * The ErrorMessage
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ErrorMessage;
    /**
     * The MessageValueList
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\ArrayType\DgArrayOfString5
     */
    public $MessageValueList;
    /**
     * The MessageValue
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $MessageValue;
    /**
     * The MainMessage
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $MainMessage;
    /**
     * The ErrorField
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ErrorField;
    /**
     * The GotoPage
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $GotoPage;
    /**
     * Constructor method for ValidationError
     * @uses DgValidationError::setErrorCode()
     * @uses DgValidationError::setErrorType()
     * @uses DgValidationError::setErrorCategory()
     * @uses DgValidationError::setRelatedEntityPropertyName()
     * @uses DgValidationError::setErrorMessage()
     * @uses DgValidationError::setMessageValueList()
     * @uses DgValidationError::setMessageValue()
     * @uses DgValidationError::setMainMessage()
     * @uses DgValidationError::setErrorField()
     * @uses DgValidationError::setGotoPage()
     * @param string $errorCode
     * @param string $errorType
     * @param string $errorCategory
     * @param string $relatedEntityPropertyName
     * @param string $errorMessage
     * @param \dgsoft\ArrayType\DgArrayOfString5 $messageValueList
     * @param string $messageValue
     * @param string $mainMessage
     * @param string $errorField
     * @param string $gotoPage
     */
    public function __construct($errorCode = null, $errorType = null, $errorCategory = null, $relatedEntityPropertyName = null, $errorMessage = null, \dgsoft\ArrayType\DgArrayOfString5 $messageValueList = null, $messageValue = null, $mainMessage = null, $errorField = null, $gotoPage = null)
    {
        $this
            ->setErrorCode($errorCode)
            ->setErrorType($errorType)
            ->setErrorCategory($errorCategory)
            ->setRelatedEntityPropertyName($relatedEntityPropertyName)
            ->setErrorMessage($errorMessage)
            ->setMessageValueList($messageValueList)
            ->setMessageValue($messageValue)
            ->setMainMessage($mainMessage)
            ->setErrorField($errorField)
            ->setGotoPage($gotoPage);
    }
    /**
     * Get ErrorCode value
     * @return string
     */
    public function getErrorCode()
    {
        return $this->ErrorCode;
    }
    /**
     * Set ErrorCode value
     * @uses \dgsoft\EnumType\DgValidationErrorCodes::valueIsValid()
     * @uses \dgsoft\EnumType\DgValidationErrorCodes::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $errorCode
     * @return \dgsoft\StructType\DgValidationError
     */
    public function setErrorCode($errorCode = null)
    {
        // validation for constraint: enumeration
        if (!\dgsoft\EnumType\DgValidationErrorCodes::valueIsValid($errorCode)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $errorCode, implode(', ', \dgsoft\EnumType\DgValidationErrorCodes::getValidValues())), __LINE__);
        }
        $this->ErrorCode = $errorCode;
        return $this;
    }
    /**
     * Get ErrorType value
     * @return string
     */
    public function getErrorType()
    {
        return $this->ErrorType;
    }
    /**
     * Set ErrorType value
     * @uses \dgsoft\EnumType\DgValidationErrorTypes::valueIsValid()
     * @uses \dgsoft\EnumType\DgValidationErrorTypes::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $errorType
     * @return \dgsoft\StructType\DgValidationError
     */
    public function setErrorType($errorType = null)
    {
        // validation for constraint: enumeration
        if (!\dgsoft\EnumType\DgValidationErrorTypes::valueIsValid($errorType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $errorType, implode(', ', \dgsoft\EnumType\DgValidationErrorTypes::getValidValues())), __LINE__);
        }
        $this->ErrorType = $errorType;
        return $this;
    }
    /**
     * Get ErrorCategory value
     * @return string
     */
    public function getErrorCategory()
    {
        return $this->ErrorCategory;
    }
    /**
     * Set ErrorCategory value
     * @uses \dgsoft\EnumType\DgValidationErrorCategories::valueIsValid()
     * @uses \dgsoft\EnumType\DgValidationErrorCategories::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $errorCategory
     * @return \dgsoft\StructType\DgValidationError
     */
    public function setErrorCategory($errorCategory = null)
    {
        // validation for constraint: enumeration
        if (!\dgsoft\EnumType\DgValidationErrorCategories::valueIsValid($errorCategory)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $errorCategory, implode(', ', \dgsoft\EnumType\DgValidationErrorCategories::getValidValues())), __LINE__);
        }
        $this->ErrorCategory = $errorCategory;
        return $this;
    }
    /**
     * Get RelatedEntityPropertyName value
     * @return string|null
     */
    public function getRelatedEntityPropertyName()
    {
        return $this->RelatedEntityPropertyName;
    }
    /**
     * Set RelatedEntityPropertyName value
     * @param string $relatedEntityPropertyName
     * @return \dgsoft\StructType\DgValidationError
     */
    public function setRelatedEntityPropertyName($relatedEntityPropertyName = null)
    {
        // validation for constraint: string
        if (!is_null($relatedEntityPropertyName) && !is_string($relatedEntityPropertyName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($relatedEntityPropertyName)), __LINE__);
        }
        $this->RelatedEntityPropertyName = $relatedEntityPropertyName;
        return $this;
    }
    /**
     * Get ErrorMessage value
     * @return string|null
     */
    public function getErrorMessage()
    {
        return $this->ErrorMessage;
    }
    /**
     * Set ErrorMessage value
     * @param string $errorMessage
     * @return \dgsoft\StructType\DgValidationError
     */
    public function setErrorMessage($errorMessage = null)
    {
        // validation for constraint: string
        if (!is_null($errorMessage) && !is_string($errorMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($errorMessage)), __LINE__);
        }
        $this->ErrorMessage = $errorMessage;
        return $this;
    }
    /**
     * Get MessageValueList value
     * @return \dgsoft\ArrayType\DgArrayOfString5|null
     */
    public function getMessageValueList()
    {
        return $this->MessageValueList;
    }
    /**
     * Set MessageValueList value
     * @param \dgsoft\ArrayType\DgArrayOfString5 $messageValueList
     * @return \dgsoft\StructType\DgValidationError
     */
    public function setMessageValueList(\dgsoft\ArrayType\DgArrayOfString5 $messageValueList = null)
    {
        $this->MessageValueList = $messageValueList;
        return $this;
    }
    /**
     * Get MessageValue value
     * @return string|null
     */
    public function getMessageValue()
    {
        return $this->MessageValue;
    }
    /**
     * Set MessageValue value
     * @param string $messageValue
     * @return \dgsoft\StructType\DgValidationError
     */
    public function setMessageValue($messageValue = null)
    {
        // validation for constraint: string
        if (!is_null($messageValue) && !is_string($messageValue)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($messageValue)), __LINE__);
        }
        $this->MessageValue = $messageValue;
        return $this;
    }
    /**
     * Get MainMessage value
     * @return string|null
     */
    public function getMainMessage()
    {
        return $this->MainMessage;
    }
    /**
     * Set MainMessage value
     * @param string $mainMessage
     * @return \dgsoft\StructType\DgValidationError
     */
    public function setMainMessage($mainMessage = null)
    {
        // validation for constraint: string
        if (!is_null($mainMessage) && !is_string($mainMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($mainMessage)), __LINE__);
        }
        $this->MainMessage = $mainMessage;
        return $this;
    }
    /**
     * Get ErrorField value
     * @return string|null
     */
    public function getErrorField()
    {
        return $this->ErrorField;
    }
    /**
     * Set ErrorField value
     * @param string $errorField
     * @return \dgsoft\StructType\DgValidationError
     */
    public function setErrorField($errorField = null)
    {
        // validation for constraint: string
        if (!is_null($errorField) && !is_string($errorField)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($errorField)), __LINE__);
        }
        $this->ErrorField = $errorField;
        return $this;
    }
    /**
     * Get GotoPage value
     * @return string|null
     */
    public function getGotoPage()
    {
        return $this->GotoPage;
    }
    /**
     * Set GotoPage value
     * @param string $gotoPage
     * @return \dgsoft\StructType\DgValidationError
     */
    public function setGotoPage($gotoPage = null)
    {
        // validation for constraint: string
        if (!is_null($gotoPage) && !is_string($gotoPage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($gotoPage)), __LINE__);
        }
        $this->GotoPage = $gotoPage;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\StructType\DgValidationError
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
