<?php

namespace dgsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UniqueID_Type StructType
 * @package Dg
 * @subpackage Structs
 */
class DgUniqueID_Type extends AbstractStructBase
{
    /**
     * The CompanyName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgCompanyNameType
     */
    public $CompanyName;
    /**
     * The URL
     * @var string
     */
    public $URL;
    /**
     * The Type
     * @var string
     */
    public $Type;
    /**
     * The Instance
     * @var string
     */
    public $Instance;
    /**
     * The ID_Context
     * @var string
     */
    public $ID_Context;
    /**
     * The SecondarySplitPNRs
     * @var string
     */
    public $SecondarySplitPNRs;
    /**
     * Constructor method for UniqueID_Type
     * @uses DgUniqueID_Type::setCompanyName()
     * @uses DgUniqueID_Type::setURL()
     * @uses DgUniqueID_Type::setType()
     * @uses DgUniqueID_Type::setInstance()
     * @uses DgUniqueID_Type::setID_Context()
     * @uses DgUniqueID_Type::setSecondarySplitPNRs()
     * @param \dgsoft\StructType\DgCompanyNameType $companyName
     * @param string $uRL
     * @param string $type
     * @param string $instance
     * @param string $iD_Context
     * @param string $secondarySplitPNRs
     */
    public function __construct(\dgsoft\StructType\DgCompanyNameType $companyName = null, $uRL = null, $type = null, $instance = null, $iD_Context = null, $secondarySplitPNRs = null)
    {
        $this
            ->setCompanyName($companyName)
            ->setURL($uRL)
            ->setType($type)
            ->setInstance($instance)
            ->setID_Context($iD_Context)
            ->setSecondarySplitPNRs($secondarySplitPNRs);
    }
    /**
     * Get CompanyName value
     * @return \dgsoft\StructType\DgCompanyNameType|null
     */
    public function getCompanyName()
    {
        return $this->CompanyName;
    }
    /**
     * Set CompanyName value
     * @param \dgsoft\StructType\DgCompanyNameType $companyName
     * @return \dgsoft\StructType\DgUniqueID_Type
     */
    public function setCompanyName(\dgsoft\StructType\DgCompanyNameType $companyName = null)
    {
        $this->CompanyName = $companyName;
        return $this;
    }
    /**
     * Get URL value
     * @return string|null
     */
    public function getURL()
    {
        return $this->URL;
    }
    /**
     * Set URL value
     * @param string $uRL
     * @return \dgsoft\StructType\DgUniqueID_Type
     */
    public function setURL($uRL = null)
    {
        // validation for constraint: string
        if (!is_null($uRL) && !is_string($uRL)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($uRL)), __LINE__);
        }
        $this->URL = $uRL;
        return $this;
    }
    /**
     * Get Type value
     * @return string|null
     */
    public function getType()
    {
        return $this->Type;
    }
    /**
     * Set Type value
     * @param string $type
     * @return \dgsoft\StructType\DgUniqueID_Type
     */
    public function setType($type = null)
    {
        // validation for constraint: string
        if (!is_null($type) && !is_string($type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($type)), __LINE__);
        }
        $this->Type = $type;
        return $this;
    }
    /**
     * Get Instance value
     * @return string|null
     */
    public function getInstance()
    {
        return $this->Instance;
    }
    /**
     * Set Instance value
     * @param string $instance
     * @return \dgsoft\StructType\DgUniqueID_Type
     */
    public function setInstance($instance = null)
    {
        // validation for constraint: string
        if (!is_null($instance) && !is_string($instance)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($instance)), __LINE__);
        }
        $this->Instance = $instance;
        return $this;
    }
    /**
     * Get ID_Context value
     * @return string|null
     */
    public function getID_Context()
    {
        return $this->ID_Context;
    }
    /**
     * Set ID_Context value
     * @param string $iD_Context
     * @return \dgsoft\StructType\DgUniqueID_Type
     */
    public function setID_Context($iD_Context = null)
    {
        // validation for constraint: string
        if (!is_null($iD_Context) && !is_string($iD_Context)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($iD_Context)), __LINE__);
        }
        $this->ID_Context = $iD_Context;
        return $this;
    }
    /**
     * Get SecondarySplitPNRs value
     * @return string|null
     */
    public function getSecondarySplitPNRs()
    {
        return $this->SecondarySplitPNRs;
    }
    /**
     * Set SecondarySplitPNRs value
     * @param string $secondarySplitPNRs
     * @return \dgsoft\StructType\DgUniqueID_Type
     */
    public function setSecondarySplitPNRs($secondarySplitPNRs = null)
    {
        // validation for constraint: string
        if (!is_null($secondarySplitPNRs) && !is_string($secondarySplitPNRs)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($secondarySplitPNRs)), __LINE__);
        }
        $this->SecondarySplitPNRs = $secondarySplitPNRs;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\StructType\DgUniqueID_Type
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
