<?php

namespace dgsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TripFeaturesTypeDestination StructType
 * @package Dg
 * @subpackage Structs
 */
class DgTripFeaturesTypeDestination extends DgAddressType
{
    /**
     * The ArrivalDate
     * @var string
     */
    public $ArrivalDate;
    /**
     * The DepartureDate
     * @var string
     */
    public $DepartureDate;
    /**
     * The AreaID
     * @var string
     */
    public $AreaID;
    /**
     * Constructor method for TripFeaturesTypeDestination
     * @uses DgTripFeaturesTypeDestination::setArrivalDate()
     * @uses DgTripFeaturesTypeDestination::setDepartureDate()
     * @uses DgTripFeaturesTypeDestination::setAreaID()
     * @param string $arrivalDate
     * @param string $departureDate
     * @param string $areaID
     */
    public function __construct($arrivalDate = null, $departureDate = null, $areaID = null)
    {
        $this
            ->setArrivalDate($arrivalDate)
            ->setDepartureDate($departureDate)
            ->setAreaID($areaID);
    }
    /**
     * Get ArrivalDate value
     * @return string|null
     */
    public function getArrivalDate()
    {
        return $this->ArrivalDate;
    }
    /**
     * Set ArrivalDate value
     * @param string $arrivalDate
     * @return \dgsoft\StructType\DgTripFeaturesTypeDestination
     */
    public function setArrivalDate($arrivalDate = null)
    {
        // validation for constraint: string
        if (!is_null($arrivalDate) && !is_string($arrivalDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($arrivalDate)), __LINE__);
        }
        $this->ArrivalDate = $arrivalDate;
        return $this;
    }
    /**
     * Get DepartureDate value
     * @return string|null
     */
    public function getDepartureDate()
    {
        return $this->DepartureDate;
    }
    /**
     * Set DepartureDate value
     * @param string $departureDate
     * @return \dgsoft\StructType\DgTripFeaturesTypeDestination
     */
    public function setDepartureDate($departureDate = null)
    {
        // validation for constraint: string
        if (!is_null($departureDate) && !is_string($departureDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($departureDate)), __LINE__);
        }
        $this->DepartureDate = $departureDate;
        return $this;
    }
    /**
     * Get AreaID value
     * @return string|null
     */
    public function getAreaID()
    {
        return $this->AreaID;
    }
    /**
     * Set AreaID value
     * @param string $areaID
     * @return \dgsoft\StructType\DgTripFeaturesTypeDestination
     */
    public function setAreaID($areaID = null)
    {
        // validation for constraint: string
        if (!is_null($areaID) && !is_string($areaID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($areaID)), __LINE__);
        }
        $this->AreaID = $areaID;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\StructType\DgTripFeaturesTypeDestination
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
