<?php

namespace dgsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TravelerInfoSummaryType StructType
 * @package Dg
 * @subpackage Structs
 */
class DgTravelerInfoSummaryType extends AbstractStructBase
{
    /**
     * The SeatsRequested
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var int[]
     */
    public $SeatsRequested;
    /**
     * The AirTravelerAvail
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgTravelerInformationType[]
     */
    public $AirTravelerAvail;
    /**
     * The PriceRequestInformation
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgPriceRequestInformationType
     */
    public $PriceRequestInformation;
    /**
     * Constructor method for TravelerInfoSummaryType
     * @uses DgTravelerInfoSummaryType::setSeatsRequested()
     * @uses DgTravelerInfoSummaryType::setAirTravelerAvail()
     * @uses DgTravelerInfoSummaryType::setPriceRequestInformation()
     * @param int[] $seatsRequested
     * @param \dgsoft\StructType\DgTravelerInformationType[] $airTravelerAvail
     * @param \dgsoft\StructType\DgPriceRequestInformationType $priceRequestInformation
     */
    public function __construct(array $seatsRequested = array(), array $airTravelerAvail = array(), \dgsoft\StructType\DgPriceRequestInformationType $priceRequestInformation = null)
    {
        $this
            ->setSeatsRequested($seatsRequested)
            ->setAirTravelerAvail($airTravelerAvail)
            ->setPriceRequestInformation($priceRequestInformation);
    }
    /**
     * Get SeatsRequested value
     * @return int[]|null
     */
    public function getSeatsRequested()
    {
        return $this->SeatsRequested;
    }
    /**
     * Set SeatsRequested value
     * @throws \InvalidArgumentException
     * @param int[] $seatsRequested
     * @return \dgsoft\StructType\DgTravelerInfoSummaryType
     */
    public function setSeatsRequested(array $seatsRequested = array())
    {
        foreach ($seatsRequested as $travelerInfoSummaryTypeSeatsRequestedItem) {
            // validation for constraint: itemType
            if (!is_numeric($travelerInfoSummaryTypeSeatsRequestedItem)) {
                throw new \InvalidArgumentException(sprintf('The SeatsRequested property can only contain items of nonNegativeInteger, "%s" given', is_object($travelerInfoSummaryTypeSeatsRequestedItem) ? get_class($travelerInfoSummaryTypeSeatsRequestedItem) : gettype($travelerInfoSummaryTypeSeatsRequestedItem)), __LINE__);
            }
        }
        $this->SeatsRequested = $seatsRequested;
        return $this;
    }
    /**
     * Add item to SeatsRequested value
     * @throws \InvalidArgumentException
     * @param int $item
     * @return \dgsoft\StructType\DgTravelerInfoSummaryType
     */
    public function addToSeatsRequested($item)
    {
        // validation for constraint: itemType
        if (!is_numeric($item)) {
            throw new \InvalidArgumentException(sprintf('The SeatsRequested property can only contain items of nonNegativeInteger, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->SeatsRequested[] = $item;
        return $this;
    }
    /**
     * Get AirTravelerAvail value
     * @return \dgsoft\StructType\DgTravelerInformationType[]|null
     */
    public function getAirTravelerAvail()
    {
        return $this->AirTravelerAvail;
    }
    /**
     * Set AirTravelerAvail value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgTravelerInformationType[] $airTravelerAvail
     * @return \dgsoft\StructType\DgTravelerInfoSummaryType
     */
    public function setAirTravelerAvail(array $airTravelerAvail = array())
    {
        foreach ($airTravelerAvail as $travelerInfoSummaryTypeAirTravelerAvailItem) {
            // validation for constraint: itemType
            if (!$travelerInfoSummaryTypeAirTravelerAvailItem instanceof \dgsoft\StructType\DgTravelerInformationType) {
                throw new \InvalidArgumentException(sprintf('The AirTravelerAvail property can only contain items of \dgsoft\StructType\DgTravelerInformationType, "%s" given', is_object($travelerInfoSummaryTypeAirTravelerAvailItem) ? get_class($travelerInfoSummaryTypeAirTravelerAvailItem) : gettype($travelerInfoSummaryTypeAirTravelerAvailItem)), __LINE__);
            }
        }
        $this->AirTravelerAvail = $airTravelerAvail;
        return $this;
    }
    /**
     * Add item to AirTravelerAvail value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgTravelerInformationType $item
     * @return \dgsoft\StructType\DgTravelerInfoSummaryType
     */
    public function addToAirTravelerAvail(\dgsoft\StructType\DgTravelerInformationType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \dgsoft\StructType\DgTravelerInformationType) {
            throw new \InvalidArgumentException(sprintf('The AirTravelerAvail property can only contain items of \dgsoft\StructType\DgTravelerInformationType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->AirTravelerAvail[] = $item;
        return $this;
    }
    /**
     * Get PriceRequestInformation value
     * @return \dgsoft\StructType\DgPriceRequestInformationType|null
     */
    public function getPriceRequestInformation()
    {
        return $this->PriceRequestInformation;
    }
    /**
     * Set PriceRequestInformation value
     * @param \dgsoft\StructType\DgPriceRequestInformationType $priceRequestInformation
     * @return \dgsoft\StructType\DgTravelerInfoSummaryType
     */
    public function setPriceRequestInformation(\dgsoft\StructType\DgPriceRequestInformationType $priceRequestInformation = null)
    {
        $this->PriceRequestInformation = $priceRequestInformation;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\StructType\DgTravelerInfoSummaryType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
