<?php

namespace dgsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TravelPreferences StructType
 * @package Dg
 * @subpackage Structs
 */
class DgTravelPreferences extends DgAirSearchPrefsType
{
    /**
     * The FlexDatePref
     * @var string
     */
    public $FlexDatePref;
    /**
     * The FlexWeekendIndicator
     * @var bool
     */
    public $FlexWeekendIndicator;
    /**
     * The FlexLevelIndicator
     * @var bool
     */
    public $FlexLevelIndicator;
    /**
     * The NoFareBreakIndicator
     * @var bool
     */
    public $NoFareBreakIndicator;
    /**
     * The OriginDestinationRPHs
     * @var string[]
     */
    public $OriginDestinationRPHs;
    /**
     * Constructor method for TravelPreferences
     * @uses DgTravelPreferences::setFlexDatePref()
     * @uses DgTravelPreferences::setFlexWeekendIndicator()
     * @uses DgTravelPreferences::setFlexLevelIndicator()
     * @uses DgTravelPreferences::setNoFareBreakIndicator()
     * @uses DgTravelPreferences::setOriginDestinationRPHs()
     * @param string $flexDatePref
     * @param bool $flexWeekendIndicator
     * @param bool $flexLevelIndicator
     * @param bool $noFareBreakIndicator
     * @param string[] $originDestinationRPHs
     */
    public function __construct($flexDatePref = null, $flexWeekendIndicator = null, $flexLevelIndicator = null, $noFareBreakIndicator = null, array $originDestinationRPHs = array())
    {
        $this
            ->setFlexDatePref($flexDatePref)
            ->setFlexWeekendIndicator($flexWeekendIndicator)
            ->setFlexLevelIndicator($flexLevelIndicator)
            ->setNoFareBreakIndicator($noFareBreakIndicator)
            ->setOriginDestinationRPHs($originDestinationRPHs);
    }
    /**
     * Get FlexDatePref value
     * @return string|null
     */
    public function getFlexDatePref()
    {
        return $this->FlexDatePref;
    }
    /**
     * Set FlexDatePref value
     * @param string $flexDatePref
     * @return \dgsoft\StructType\DgTravelPreferences
     */
    public function setFlexDatePref($flexDatePref = null)
    {
        // validation for constraint: string
        if (!is_null($flexDatePref) && !is_string($flexDatePref)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($flexDatePref)), __LINE__);
        }
        $this->FlexDatePref = $flexDatePref;
        return $this;
    }
    /**
     * Get FlexWeekendIndicator value
     * @return bool|null
     */
    public function getFlexWeekendIndicator()
    {
        return $this->FlexWeekendIndicator;
    }
    /**
     * Set FlexWeekendIndicator value
     * @param bool $flexWeekendIndicator
     * @return \dgsoft\StructType\DgTravelPreferences
     */
    public function setFlexWeekendIndicator($flexWeekendIndicator = null)
    {
        // validation for constraint: boolean
        if (!is_null($flexWeekendIndicator) && !is_bool($flexWeekendIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($flexWeekendIndicator)), __LINE__);
        }
        $this->FlexWeekendIndicator = $flexWeekendIndicator;
        return $this;
    }
    /**
     * Get FlexLevelIndicator value
     * @return bool|null
     */
    public function getFlexLevelIndicator()
    {
        return $this->FlexLevelIndicator;
    }
    /**
     * Set FlexLevelIndicator value
     * @param bool $flexLevelIndicator
     * @return \dgsoft\StructType\DgTravelPreferences
     */
    public function setFlexLevelIndicator($flexLevelIndicator = null)
    {
        // validation for constraint: boolean
        if (!is_null($flexLevelIndicator) && !is_bool($flexLevelIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($flexLevelIndicator)), __LINE__);
        }
        $this->FlexLevelIndicator = $flexLevelIndicator;
        return $this;
    }
    /**
     * Get NoFareBreakIndicator value
     * @return bool|null
     */
    public function getNoFareBreakIndicator()
    {
        return $this->NoFareBreakIndicator;
    }
    /**
     * Set NoFareBreakIndicator value
     * @param bool $noFareBreakIndicator
     * @return \dgsoft\StructType\DgTravelPreferences
     */
    public function setNoFareBreakIndicator($noFareBreakIndicator = null)
    {
        // validation for constraint: boolean
        if (!is_null($noFareBreakIndicator) && !is_bool($noFareBreakIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($noFareBreakIndicator)), __LINE__);
        }
        $this->NoFareBreakIndicator = $noFareBreakIndicator;
        return $this;
    }
    /**
     * Get OriginDestinationRPHs value
     * @return string[]|null
     */
    public function getOriginDestinationRPHs()
    {
        return $this->OriginDestinationRPHs;
    }
    /**
     * Set OriginDestinationRPHs value
     * @throws \InvalidArgumentException
     * @param string[] $originDestinationRPHs
     * @return \dgsoft\StructType\DgTravelPreferences
     */
    public function setOriginDestinationRPHs(array $originDestinationRPHs = array())
    {
        foreach ($originDestinationRPHs as $travelPreferencesOriginDestinationRPHsItem) {
            // validation for constraint: itemType
            if (!is_string($travelPreferencesOriginDestinationRPHsItem)) {
                throw new \InvalidArgumentException(sprintf('The OriginDestinationRPHs property can only contain items of string, "%s" given', is_object($travelPreferencesOriginDestinationRPHsItem) ? get_class($travelPreferencesOriginDestinationRPHsItem) : gettype($travelPreferencesOriginDestinationRPHsItem)), __LINE__);
            }
        }
        $this->OriginDestinationRPHs = $originDestinationRPHs;
        return $this;
    }
    /**
     * Add item to OriginDestinationRPHs value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \dgsoft\StructType\DgTravelPreferences
     */
    public function addToOriginDestinationRPHs($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The OriginDestinationRPHs property can only contain items of string, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->OriginDestinationRPHs[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\StructType\DgTravelPreferences
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
