<?php

namespace dgsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TotalType StructType
 * @package Dg
 * @subpackage Structs
 */
class DgTotalType extends AbstractStructBase
{
    /**
     * The IsDailyPrice
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsDailyPrice;
    /**
     * The IsRateChange
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsRateChange;
    /**
     * The Taxes
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgTaxesType
     */
    public $Taxes;
    /**
     * The AmountBeforeTax
     * @var float
     */
    public $AmountBeforeTax;
    /**
     * The AmountAfterTax
     * @var float
     */
    public $AmountAfterTax;
    /**
     * The MarkupAmount
     * @var float
     */
    public $MarkupAmount;
    /**
     * The CurrencyCode
     * @var string
     */
    public $CurrencyCode;
    /**
     * The DecimalPlaces
     * @var int
     */
    public $DecimalPlaces;
    /**
     * The AdditionalFeesExcludedIndicator
     * @var bool
     */
    public $AdditionalFeesExcludedIndicator;
    /**
     * Constructor method for TotalType
     * @uses DgTotalType::setIsDailyPrice()
     * @uses DgTotalType::setIsRateChange()
     * @uses DgTotalType::setTaxes()
     * @uses DgTotalType::setAmountBeforeTax()
     * @uses DgTotalType::setAmountAfterTax()
     * @uses DgTotalType::setMarkupAmount()
     * @uses DgTotalType::setCurrencyCode()
     * @uses DgTotalType::setDecimalPlaces()
     * @uses DgTotalType::setAdditionalFeesExcludedIndicator()
     * @param bool $isDailyPrice
     * @param bool $isRateChange
     * @param \dgsoft\StructType\DgTaxesType $taxes
     * @param float $amountBeforeTax
     * @param float $amountAfterTax
     * @param float $markupAmount
     * @param string $currencyCode
     * @param int $decimalPlaces
     * @param bool $additionalFeesExcludedIndicator
     */
    public function __construct($isDailyPrice = null, $isRateChange = null, \dgsoft\StructType\DgTaxesType $taxes = null, $amountBeforeTax = null, $amountAfterTax = null, $markupAmount = null, $currencyCode = null, $decimalPlaces = null, $additionalFeesExcludedIndicator = null)
    {
        $this
            ->setIsDailyPrice($isDailyPrice)
            ->setIsRateChange($isRateChange)
            ->setTaxes($taxes)
            ->setAmountBeforeTax($amountBeforeTax)
            ->setAmountAfterTax($amountAfterTax)
            ->setMarkupAmount($markupAmount)
            ->setCurrencyCode($currencyCode)
            ->setDecimalPlaces($decimalPlaces)
            ->setAdditionalFeesExcludedIndicator($additionalFeesExcludedIndicator);
    }
    /**
     * Get IsDailyPrice value
     * @return bool
     */
    public function getIsDailyPrice()
    {
        return $this->IsDailyPrice;
    }
    /**
     * Set IsDailyPrice value
     * @param bool $isDailyPrice
     * @return \dgsoft\StructType\DgTotalType
     */
    public function setIsDailyPrice($isDailyPrice = null)
    {
        // validation for constraint: boolean
        if (!is_null($isDailyPrice) && !is_bool($isDailyPrice)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isDailyPrice)), __LINE__);
        }
        $this->IsDailyPrice = $isDailyPrice;
        return $this;
    }
    /**
     * Get IsRateChange value
     * @return bool
     */
    public function getIsRateChange()
    {
        return $this->IsRateChange;
    }
    /**
     * Set IsRateChange value
     * @param bool $isRateChange
     * @return \dgsoft\StructType\DgTotalType
     */
    public function setIsRateChange($isRateChange = null)
    {
        // validation for constraint: boolean
        if (!is_null($isRateChange) && !is_bool($isRateChange)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isRateChange)), __LINE__);
        }
        $this->IsRateChange = $isRateChange;
        return $this;
    }
    /**
     * Get Taxes value
     * @return \dgsoft\StructType\DgTaxesType|null
     */
    public function getTaxes()
    {
        return $this->Taxes;
    }
    /**
     * Set Taxes value
     * @param \dgsoft\StructType\DgTaxesType $taxes
     * @return \dgsoft\StructType\DgTotalType
     */
    public function setTaxes(\dgsoft\StructType\DgTaxesType $taxes = null)
    {
        $this->Taxes = $taxes;
        return $this;
    }
    /**
     * Get AmountBeforeTax value
     * @return float|null
     */
    public function getAmountBeforeTax()
    {
        return $this->AmountBeforeTax;
    }
    /**
     * Set AmountBeforeTax value
     * @param float $amountBeforeTax
     * @return \dgsoft\StructType\DgTotalType
     */
    public function setAmountBeforeTax($amountBeforeTax = null)
    {
        $this->AmountBeforeTax = $amountBeforeTax;
        return $this;
    }
    /**
     * Get AmountAfterTax value
     * @return float|null
     */
    public function getAmountAfterTax()
    {
        return $this->AmountAfterTax;
    }
    /**
     * Set AmountAfterTax value
     * @param float $amountAfterTax
     * @return \dgsoft\StructType\DgTotalType
     */
    public function setAmountAfterTax($amountAfterTax = null)
    {
        $this->AmountAfterTax = $amountAfterTax;
        return $this;
    }
    /**
     * Get MarkupAmount value
     * @return float|null
     */
    public function getMarkupAmount()
    {
        return $this->MarkupAmount;
    }
    /**
     * Set MarkupAmount value
     * @param float $markupAmount
     * @return \dgsoft\StructType\DgTotalType
     */
    public function setMarkupAmount($markupAmount = null)
    {
        $this->MarkupAmount = $markupAmount;
        return $this;
    }
    /**
     * Get CurrencyCode value
     * @return string|null
     */
    public function getCurrencyCode()
    {
        return $this->CurrencyCode;
    }
    /**
     * Set CurrencyCode value
     * @param string $currencyCode
     * @return \dgsoft\StructType\DgTotalType
     */
    public function setCurrencyCode($currencyCode = null)
    {
        // validation for constraint: string
        if (!is_null($currencyCode) && !is_string($currencyCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($currencyCode)), __LINE__);
        }
        $this->CurrencyCode = $currencyCode;
        return $this;
    }
    /**
     * Get DecimalPlaces value
     * @return int|null
     */
    public function getDecimalPlaces()
    {
        return $this->DecimalPlaces;
    }
    /**
     * Set DecimalPlaces value
     * @param int $decimalPlaces
     * @return \dgsoft\StructType\DgTotalType
     */
    public function setDecimalPlaces($decimalPlaces = null)
    {
        // validation for constraint: int
        if (!is_null($decimalPlaces) && !is_numeric($decimalPlaces)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($decimalPlaces)), __LINE__);
        }
        $this->DecimalPlaces = $decimalPlaces;
        return $this;
    }
    /**
     * Get AdditionalFeesExcludedIndicator value
     * @return bool|null
     */
    public function getAdditionalFeesExcludedIndicator()
    {
        return $this->AdditionalFeesExcludedIndicator;
    }
    /**
     * Set AdditionalFeesExcludedIndicator value
     * @param bool $additionalFeesExcludedIndicator
     * @return \dgsoft\StructType\DgTotalType
     */
    public function setAdditionalFeesExcludedIndicator($additionalFeesExcludedIndicator = null)
    {
        // validation for constraint: boolean
        if (!is_null($additionalFeesExcludedIndicator) && !is_bool($additionalFeesExcludedIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($additionalFeesExcludedIndicator)), __LINE__);
        }
        $this->AdditionalFeesExcludedIndicator = $additionalFeesExcludedIndicator;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\StructType\DgTotalType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
