<?php

namespace dgsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TicketingInfo StructType
 * @package Dg
 * @subpackage Structs
 */
class DgTicketingInfo extends DgTicketingInfoRS_Type
{
    /**
     * The DeliveryInfo
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgDeliveryInfo[]
     */
    public $DeliveryInfo;
    /**
     * The PaymentType
     * @var string[]
     */
    public $PaymentType;
    /**
     * Constructor method for TicketingInfo
     * @uses DgTicketingInfo::setDeliveryInfo()
     * @uses DgTicketingInfo::setPaymentType()
     * @param \dgsoft\StructType\DgDeliveryInfo[] $deliveryInfo
     * @param string[] $paymentType
     */
    public function __construct(array $deliveryInfo = array(), array $paymentType = array())
    {
        $this
            ->setDeliveryInfo($deliveryInfo)
            ->setPaymentType($paymentType);
    }
    /**
     * Get DeliveryInfo value
     * @return \dgsoft\StructType\DgDeliveryInfo[]|null
     */
    public function getDeliveryInfo()
    {
        return $this->DeliveryInfo;
    }
    /**
     * Set DeliveryInfo value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgDeliveryInfo[] $deliveryInfo
     * @return \dgsoft\StructType\DgTicketingInfo
     */
    public function setDeliveryInfo(array $deliveryInfo = array())
    {
        foreach ($deliveryInfo as $ticketingInfoDeliveryInfoItem) {
            // validation for constraint: itemType
            if (!$ticketingInfoDeliveryInfoItem instanceof \dgsoft\StructType\DgDeliveryInfo) {
                throw new \InvalidArgumentException(sprintf('The DeliveryInfo property can only contain items of \dgsoft\StructType\DgDeliveryInfo, "%s" given', is_object($ticketingInfoDeliveryInfoItem) ? get_class($ticketingInfoDeliveryInfoItem) : gettype($ticketingInfoDeliveryInfoItem)), __LINE__);
            }
        }
        $this->DeliveryInfo = $deliveryInfo;
        return $this;
    }
    /**
     * Add item to DeliveryInfo value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgDeliveryInfo $item
     * @return \dgsoft\StructType\DgTicketingInfo
     */
    public function addToDeliveryInfo(\dgsoft\StructType\DgDeliveryInfo $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \dgsoft\StructType\DgDeliveryInfo) {
            throw new \InvalidArgumentException(sprintf('The DeliveryInfo property can only contain items of \dgsoft\StructType\DgDeliveryInfo, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->DeliveryInfo[] = $item;
        return $this;
    }
    /**
     * Get PaymentType value
     * @return string[]|null
     */
    public function getPaymentType()
    {
        return $this->PaymentType;
    }
    /**
     * Set PaymentType value
     * @throws \InvalidArgumentException
     * @param string[] $paymentType
     * @return \dgsoft\StructType\DgTicketingInfo
     */
    public function setPaymentType(array $paymentType = array())
    {
        foreach ($paymentType as $ticketingInfoPaymentTypeItem) {
            // validation for constraint: itemType
            if (!is_string($ticketingInfoPaymentTypeItem)) {
                throw new \InvalidArgumentException(sprintf('The PaymentType property can only contain items of string, "%s" given', is_object($ticketingInfoPaymentTypeItem) ? get_class($ticketingInfoPaymentTypeItem) : gettype($ticketingInfoPaymentTypeItem)), __LINE__);
            }
        }
        $this->PaymentType = $paymentType;
        return $this;
    }
    /**
     * Add item to PaymentType value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \dgsoft\StructType\DgTicketingInfo
     */
    public function addToPaymentType($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The PaymentType property can only contain items of string, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->PaymentType[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\StructType\DgTicketingInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
