<?php

namespace dgsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TicketDesignator StructType
 * @package Dg
 * @subpackage Structs
 */
class DgTicketDesignator extends AbstractStructBase
{
    /**
     * The FlightRefRPH
     * @var string
     */
    public $FlightRefRPH;
    /**
     * The TicketDesignatorCode
     * @var string
     */
    public $TicketDesignatorCode;
    /**
     * The TicketDesignatorExtension
     * @var string
     */
    public $TicketDesignatorExtension;
    /**
     * Constructor method for TicketDesignator
     * @uses DgTicketDesignator::setFlightRefRPH()
     * @uses DgTicketDesignator::setTicketDesignatorCode()
     * @uses DgTicketDesignator::setTicketDesignatorExtension()
     * @param string $flightRefRPH
     * @param string $ticketDesignatorCode
     * @param string $ticketDesignatorExtension
     */
    public function __construct($flightRefRPH = null, $ticketDesignatorCode = null, $ticketDesignatorExtension = null)
    {
        $this
            ->setFlightRefRPH($flightRefRPH)
            ->setTicketDesignatorCode($ticketDesignatorCode)
            ->setTicketDesignatorExtension($ticketDesignatorExtension);
    }
    /**
     * Get FlightRefRPH value
     * @return string|null
     */
    public function getFlightRefRPH()
    {
        return $this->FlightRefRPH;
    }
    /**
     * Set FlightRefRPH value
     * @param string $flightRefRPH
     * @return \dgsoft\StructType\DgTicketDesignator
     */
    public function setFlightRefRPH($flightRefRPH = null)
    {
        // validation for constraint: string
        if (!is_null($flightRefRPH) && !is_string($flightRefRPH)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($flightRefRPH)), __LINE__);
        }
        $this->FlightRefRPH = $flightRefRPH;
        return $this;
    }
    /**
     * Get TicketDesignatorCode value
     * @return string|null
     */
    public function getTicketDesignatorCode()
    {
        return $this->TicketDesignatorCode;
    }
    /**
     * Set TicketDesignatorCode value
     * @param string $ticketDesignatorCode
     * @return \dgsoft\StructType\DgTicketDesignator
     */
    public function setTicketDesignatorCode($ticketDesignatorCode = null)
    {
        // validation for constraint: string
        if (!is_null($ticketDesignatorCode) && !is_string($ticketDesignatorCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($ticketDesignatorCode)), __LINE__);
        }
        $this->TicketDesignatorCode = $ticketDesignatorCode;
        return $this;
    }
    /**
     * Get TicketDesignatorExtension value
     * @return string|null
     */
    public function getTicketDesignatorExtension()
    {
        return $this->TicketDesignatorExtension;
    }
    /**
     * Set TicketDesignatorExtension value
     * @param string $ticketDesignatorExtension
     * @return \dgsoft\StructType\DgTicketDesignator
     */
    public function setTicketDesignatorExtension($ticketDesignatorExtension = null)
    {
        // validation for constraint: string
        if (!is_null($ticketDesignatorExtension) && !is_string($ticketDesignatorExtension)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($ticketDesignatorExtension)), __LINE__);
        }
        $this->TicketDesignatorExtension = $ticketDesignatorExtension;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\StructType\DgTicketDesignator
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
