<?php

namespace dgsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TaxesType StructType
 * @package Dg
 * @subpackage Structs
 */
class DgTaxesType extends AbstractStructBase
{
    /**
     * The Tax
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgTaxType[]
     */
    public $Tax;
    /**
     * The Amount
     * @var float
     */
    public $Amount;
    /**
     * Constructor method for TaxesType
     * @uses DgTaxesType::setTax()
     * @uses DgTaxesType::setAmount()
     * @param \dgsoft\StructType\DgTaxType[] $tax
     * @param float $amount
     */
    public function __construct(array $tax = array(), $amount = null)
    {
        $this
            ->setTax($tax)
            ->setAmount($amount);
    }
    /**
     * Get Tax value
     * @return \dgsoft\StructType\DgTaxType[]|null
     */
    public function getTax()
    {
        return $this->Tax;
    }
    /**
     * Set Tax value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgTaxType[] $tax
     * @return \dgsoft\StructType\DgTaxesType
     */
    public function setTax(array $tax = array())
    {
        foreach ($tax as $taxesTypeTaxItem) {
            // validation for constraint: itemType
            if (!$taxesTypeTaxItem instanceof \dgsoft\StructType\DgTaxType) {
                throw new \InvalidArgumentException(sprintf('The Tax property can only contain items of \dgsoft\StructType\DgTaxType, "%s" given', is_object($taxesTypeTaxItem) ? get_class($taxesTypeTaxItem) : gettype($taxesTypeTaxItem)), __LINE__);
            }
        }
        $this->Tax = $tax;
        return $this;
    }
    /**
     * Add item to Tax value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgTaxType $item
     * @return \dgsoft\StructType\DgTaxesType
     */
    public function addToTax(\dgsoft\StructType\DgTaxType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \dgsoft\StructType\DgTaxType) {
            throw new \InvalidArgumentException(sprintf('The Tax property can only contain items of \dgsoft\StructType\DgTaxType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Tax[] = $item;
        return $this;
    }
    /**
     * Get Amount value
     * @return float|null
     */
    public function getAmount()
    {
        return $this->Amount;
    }
    /**
     * Set Amount value
     * @param float $amount
     * @return \dgsoft\StructType\DgTaxesType
     */
    public function setAmount($amount = null)
    {
        $this->Amount = $amount;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\StructType\DgTaxesType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
