<?php

namespace dgsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SystemCode StructType
 * @package Dg
 * @subpackage Structs
 */
class DgSystemCode extends AbstractStructBase
{
    /**
     * The _
     * @var string
     */
    public $_;
    /**
     * The RestrictedDisplayIndicator
     * @var bool
     */
    public $RestrictedDisplayIndicator;
    /**
     * The Sort
     * @var int
     */
    public $Sort;
    /**
     * Constructor method for SystemCode
     * @uses DgSystemCode::set_()
     * @uses DgSystemCode::setRestrictedDisplayIndicator()
     * @uses DgSystemCode::setSort()
     * @param string $_
     * @param bool $restrictedDisplayIndicator
     * @param int $sort
     */
    public function __construct($_ = null, $restrictedDisplayIndicator = null, $sort = null)
    {
        $this
            ->set_($_)
            ->setRestrictedDisplayIndicator($restrictedDisplayIndicator)
            ->setSort($sort);
    }
    /**
     * Get _ value
     * @return string|null
     */
    public function get_()
    {
        return $this->_;
    }
    /**
     * Set _ value
     * @param string $_
     * @return \dgsoft\StructType\DgSystemCode
     */
    public function set_($_ = null)
    {
        // validation for constraint: string
        if (!is_null($_) && !is_string($_)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($_)), __LINE__);
        }
        $this->_ = $_;
        return $this;
    }
    /**
     * Get RestrictedDisplayIndicator value
     * @return bool|null
     */
    public function getRestrictedDisplayIndicator()
    {
        return $this->RestrictedDisplayIndicator;
    }
    /**
     * Set RestrictedDisplayIndicator value
     * @param bool $restrictedDisplayIndicator
     * @return \dgsoft\StructType\DgSystemCode
     */
    public function setRestrictedDisplayIndicator($restrictedDisplayIndicator = null)
    {
        // validation for constraint: boolean
        if (!is_null($restrictedDisplayIndicator) && !is_bool($restrictedDisplayIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($restrictedDisplayIndicator)), __LINE__);
        }
        $this->RestrictedDisplayIndicator = $restrictedDisplayIndicator;
        return $this;
    }
    /**
     * Get Sort value
     * @return int|null
     */
    public function getSort()
    {
        return $this->Sort;
    }
    /**
     * Set Sort value
     * @param int $sort
     * @return \dgsoft\StructType\DgSystemCode
     */
    public function setSort($sort = null)
    {
        // validation for constraint: int
        if (!is_null($sort) && !is_numeric($sort)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($sort)), __LINE__);
        }
        $this->Sort = $sort;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\StructType\DgSystemCode
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
