<?php

namespace dgsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SpecificFlightInfoType StructType
 * @package Dg
 * @subpackage Structs
 */
class DgSpecificFlightInfoType extends AbstractStructBase
{
    /**
     * The FlightNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $FlightNumber;
    /**
     * The Airline
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgCompanyNameType[]
     */
    public $Airline;
    /**
     * The ExcludedAirline
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgCompanyNameType[]
     */
    public $ExcludedAirline;
    /**
     * The Alliance
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $Alliance;
    /**
     * The ExcludedAlliance
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $ExcludedAlliance;
    /**
     * The BookingClassPref
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgBookingClassPref[]
     */
    public $BookingClassPref;
    /**
     * Constructor method for SpecificFlightInfoType
     * @uses DgSpecificFlightInfoType::setFlightNumber()
     * @uses DgSpecificFlightInfoType::setAirline()
     * @uses DgSpecificFlightInfoType::setExcludedAirline()
     * @uses DgSpecificFlightInfoType::setAlliance()
     * @uses DgSpecificFlightInfoType::setExcludedAlliance()
     * @uses DgSpecificFlightInfoType::setBookingClassPref()
     * @param string $flightNumber
     * @param \dgsoft\StructType\DgCompanyNameType[] $airline
     * @param \dgsoft\StructType\DgCompanyNameType[] $excludedAirline
     * @param string[] $alliance
     * @param string[] $excludedAlliance
     * @param \dgsoft\StructType\DgBookingClassPref[] $bookingClassPref
     */
    public function __construct($flightNumber = null, array $airline = array(), array $excludedAirline = array(), array $alliance = array(), array $excludedAlliance = array(), array $bookingClassPref = array())
    {
        $this
            ->setFlightNumber($flightNumber)
            ->setAirline($airline)
            ->setExcludedAirline($excludedAirline)
            ->setAlliance($alliance)
            ->setExcludedAlliance($excludedAlliance)
            ->setBookingClassPref($bookingClassPref);
    }
    /**
     * Get FlightNumber value
     * @return string|null
     */
    public function getFlightNumber()
    {
        return $this->FlightNumber;
    }
    /**
     * Set FlightNumber value
     * @param string $flightNumber
     * @return \dgsoft\StructType\DgSpecificFlightInfoType
     */
    public function setFlightNumber($flightNumber = null)
    {
        // validation for constraint: string
        if (!is_null($flightNumber) && !is_string($flightNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($flightNumber)), __LINE__);
        }
        $this->FlightNumber = $flightNumber;
        return $this;
    }
    /**
     * Get Airline value
     * @return \dgsoft\StructType\DgCompanyNameType[]|null
     */
    public function getAirline()
    {
        return $this->Airline;
    }
    /**
     * Set Airline value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgCompanyNameType[] $airline
     * @return \dgsoft\StructType\DgSpecificFlightInfoType
     */
    public function setAirline(array $airline = array())
    {
        foreach ($airline as $specificFlightInfoTypeAirlineItem) {
            // validation for constraint: itemType
            if (!$specificFlightInfoTypeAirlineItem instanceof \dgsoft\StructType\DgCompanyNameType) {
                throw new \InvalidArgumentException(sprintf('The Airline property can only contain items of \dgsoft\StructType\DgCompanyNameType, "%s" given', is_object($specificFlightInfoTypeAirlineItem) ? get_class($specificFlightInfoTypeAirlineItem) : gettype($specificFlightInfoTypeAirlineItem)), __LINE__);
            }
        }
        $this->Airline = $airline;
        return $this;
    }
    /**
     * Add item to Airline value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgCompanyNameType $item
     * @return \dgsoft\StructType\DgSpecificFlightInfoType
     */
    public function addToAirline(\dgsoft\StructType\DgCompanyNameType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \dgsoft\StructType\DgCompanyNameType) {
            throw new \InvalidArgumentException(sprintf('The Airline property can only contain items of \dgsoft\StructType\DgCompanyNameType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Airline[] = $item;
        return $this;
    }
    /**
     * Get ExcludedAirline value
     * @return \dgsoft\StructType\DgCompanyNameType[]|null
     */
    public function getExcludedAirline()
    {
        return $this->ExcludedAirline;
    }
    /**
     * Set ExcludedAirline value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgCompanyNameType[] $excludedAirline
     * @return \dgsoft\StructType\DgSpecificFlightInfoType
     */
    public function setExcludedAirline(array $excludedAirline = array())
    {
        foreach ($excludedAirline as $specificFlightInfoTypeExcludedAirlineItem) {
            // validation for constraint: itemType
            if (!$specificFlightInfoTypeExcludedAirlineItem instanceof \dgsoft\StructType\DgCompanyNameType) {
                throw new \InvalidArgumentException(sprintf('The ExcludedAirline property can only contain items of \dgsoft\StructType\DgCompanyNameType, "%s" given', is_object($specificFlightInfoTypeExcludedAirlineItem) ? get_class($specificFlightInfoTypeExcludedAirlineItem) : gettype($specificFlightInfoTypeExcludedAirlineItem)), __LINE__);
            }
        }
        $this->ExcludedAirline = $excludedAirline;
        return $this;
    }
    /**
     * Add item to ExcludedAirline value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgCompanyNameType $item
     * @return \dgsoft\StructType\DgSpecificFlightInfoType
     */
    public function addToExcludedAirline(\dgsoft\StructType\DgCompanyNameType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \dgsoft\StructType\DgCompanyNameType) {
            throw new \InvalidArgumentException(sprintf('The ExcludedAirline property can only contain items of \dgsoft\StructType\DgCompanyNameType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->ExcludedAirline[] = $item;
        return $this;
    }
    /**
     * Get Alliance value
     * @return string[]|null
     */
    public function getAlliance()
    {
        return $this->Alliance;
    }
    /**
     * Set Alliance value
     * @uses \dgsoft\EnumType\DgAllianceCode::valueIsValid()
     * @uses \dgsoft\EnumType\DgAllianceCode::getValidValues()
     * @throws \InvalidArgumentException
     * @param string[] $alliance
     * @return \dgsoft\StructType\DgSpecificFlightInfoType
     */
    public function setAlliance(array $alliance = array())
    {
        $invalidValues = array();
        foreach ($alliance as $specificFlightInfoTypeAllianceItem) {
            if (!\dgsoft\EnumType\DgAllianceCode::valueIsValid($specificFlightInfoTypeAllianceItem)) {
                $invalidValues[] = var_export($specificFlightInfoTypeAllianceItem, true);
            }
        }
        if (!empty($invalidValues)) {
            throw new \InvalidArgumentException(sprintf('Value(s) "%s" is/are invalid, please use one of: %s', implode(', ', $invalidValues), implode(', ', \dgsoft\EnumType\DgAllianceCode::getValidValues())), __LINE__);
        }
        $this->Alliance = $alliance;
        return $this;
    }
    /**
     * Add item to Alliance value
     * @uses \dgsoft\EnumType\DgAllianceCode::valueIsValid()
     * @uses \dgsoft\EnumType\DgAllianceCode::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \dgsoft\StructType\DgSpecificFlightInfoType
     */
    public function addToAlliance($item)
    {
        // validation for constraint: enumeration
        if (!\dgsoft\EnumType\DgAllianceCode::valueIsValid($item)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $item, implode(', ', \dgsoft\EnumType\DgAllianceCode::getValidValues())), __LINE__);
        }
        $this->Alliance[] = $item;
        return $this;
    }
    /**
     * Get ExcludedAlliance value
     * @return string[]|null
     */
    public function getExcludedAlliance()
    {
        return $this->ExcludedAlliance;
    }
    /**
     * Set ExcludedAlliance value
     * @uses \dgsoft\EnumType\DgAllianceCode::valueIsValid()
     * @uses \dgsoft\EnumType\DgAllianceCode::getValidValues()
     * @throws \InvalidArgumentException
     * @param string[] $excludedAlliance
     * @return \dgsoft\StructType\DgSpecificFlightInfoType
     */
    public function setExcludedAlliance(array $excludedAlliance = array())
    {
        $invalidValues = array();
        foreach ($excludedAlliance as $specificFlightInfoTypeExcludedAllianceItem) {
            if (!\dgsoft\EnumType\DgAllianceCode::valueIsValid($specificFlightInfoTypeExcludedAllianceItem)) {
                $invalidValues[] = var_export($specificFlightInfoTypeExcludedAllianceItem, true);
            }
        }
        if (!empty($invalidValues)) {
            throw new \InvalidArgumentException(sprintf('Value(s) "%s" is/are invalid, please use one of: %s', implode(', ', $invalidValues), implode(', ', \dgsoft\EnumType\DgAllianceCode::getValidValues())), __LINE__);
        }
        $this->ExcludedAlliance = $excludedAlliance;
        return $this;
    }
    /**
     * Add item to ExcludedAlliance value
     * @uses \dgsoft\EnumType\DgAllianceCode::valueIsValid()
     * @uses \dgsoft\EnumType\DgAllianceCode::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \dgsoft\StructType\DgSpecificFlightInfoType
     */
    public function addToExcludedAlliance($item)
    {
        // validation for constraint: enumeration
        if (!\dgsoft\EnumType\DgAllianceCode::valueIsValid($item)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $item, implode(', ', \dgsoft\EnumType\DgAllianceCode::getValidValues())), __LINE__);
        }
        $this->ExcludedAlliance[] = $item;
        return $this;
    }
    /**
     * Get BookingClassPref value
     * @return \dgsoft\StructType\DgBookingClassPref[]|null
     */
    public function getBookingClassPref()
    {
        return $this->BookingClassPref;
    }
    /**
     * Set BookingClassPref value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgBookingClassPref[] $bookingClassPref
     * @return \dgsoft\StructType\DgSpecificFlightInfoType
     */
    public function setBookingClassPref(array $bookingClassPref = array())
    {
        foreach ($bookingClassPref as $specificFlightInfoTypeBookingClassPrefItem) {
            // validation for constraint: itemType
            if (!$specificFlightInfoTypeBookingClassPrefItem instanceof \dgsoft\StructType\DgBookingClassPref) {
                throw new \InvalidArgumentException(sprintf('The BookingClassPref property can only contain items of \dgsoft\StructType\DgBookingClassPref, "%s" given', is_object($specificFlightInfoTypeBookingClassPrefItem) ? get_class($specificFlightInfoTypeBookingClassPrefItem) : gettype($specificFlightInfoTypeBookingClassPrefItem)), __LINE__);
            }
        }
        $this->BookingClassPref = $bookingClassPref;
        return $this;
    }
    /**
     * Add item to BookingClassPref value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgBookingClassPref $item
     * @return \dgsoft\StructType\DgSpecificFlightInfoType
     */
    public function addToBookingClassPref(\dgsoft\StructType\DgBookingClassPref $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \dgsoft\StructType\DgBookingClassPref) {
            throw new \InvalidArgumentException(sprintf('The BookingClassPref property can only contain items of \dgsoft\StructType\DgBookingClassPref, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->BookingClassPref[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\StructType\DgSpecificFlightInfoType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
