<?php

namespace dgsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SpecialServiceRequestType StructType
 * @package Dg
 * @subpackage Structs
 */
class DgSpecialServiceRequestType extends AbstractStructBase
{
    /**
     * The Airline
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgCompanyNameType
     */
    public $Airline;
    /**
     * The Text
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Text;
    /**
     * The SSRCode
     * @var string
     */
    public $SSRCode;
    /**
     * The ServiceQuantity
     * @var int
     */
    public $ServiceQuantity;
    /**
     * The Status
     * @var string
     */
    public $Status;
    /**
     * Constructor method for SpecialServiceRequestType
     * @uses DgSpecialServiceRequestType::setAirline()
     * @uses DgSpecialServiceRequestType::setText()
     * @uses DgSpecialServiceRequestType::setSSRCode()
     * @uses DgSpecialServiceRequestType::setServiceQuantity()
     * @uses DgSpecialServiceRequestType::setStatus()
     * @param \dgsoft\StructType\DgCompanyNameType $airline
     * @param string $text
     * @param string $sSRCode
     * @param int $serviceQuantity
     * @param string $status
     */
    public function __construct(\dgsoft\StructType\DgCompanyNameType $airline = null, $text = null, $sSRCode = null, $serviceQuantity = null, $status = null)
    {
        $this
            ->setAirline($airline)
            ->setText($text)
            ->setSSRCode($sSRCode)
            ->setServiceQuantity($serviceQuantity)
            ->setStatus($status);
    }
    /**
     * Get Airline value
     * @return \dgsoft\StructType\DgCompanyNameType|null
     */
    public function getAirline()
    {
        return $this->Airline;
    }
    /**
     * Set Airline value
     * @param \dgsoft\StructType\DgCompanyNameType $airline
     * @return \dgsoft\StructType\DgSpecialServiceRequestType
     */
    public function setAirline(\dgsoft\StructType\DgCompanyNameType $airline = null)
    {
        $this->Airline = $airline;
        return $this;
    }
    /**
     * Get Text value
     * @return string|null
     */
    public function getText()
    {
        return $this->Text;
    }
    /**
     * Set Text value
     * @param string $text
     * @return \dgsoft\StructType\DgSpecialServiceRequestType
     */
    public function setText($text = null)
    {
        // validation for constraint: string
        if (!is_null($text) && !is_string($text)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($text)), __LINE__);
        }
        $this->Text = $text;
        return $this;
    }
    /**
     * Get SSRCode value
     * @return string|null
     */
    public function getSSRCode()
    {
        return $this->SSRCode;
    }
    /**
     * Set SSRCode value
     * @param string $sSRCode
     * @return \dgsoft\StructType\DgSpecialServiceRequestType
     */
    public function setSSRCode($sSRCode = null)
    {
        // validation for constraint: string
        if (!is_null($sSRCode) && !is_string($sSRCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($sSRCode)), __LINE__);
        }
        $this->SSRCode = $sSRCode;
        return $this;
    }
    /**
     * Get ServiceQuantity value
     * @return int|null
     */
    public function getServiceQuantity()
    {
        return $this->ServiceQuantity;
    }
    /**
     * Set ServiceQuantity value
     * @param int $serviceQuantity
     * @return \dgsoft\StructType\DgSpecialServiceRequestType
     */
    public function setServiceQuantity($serviceQuantity = null)
    {
        // validation for constraint: int
        if (!is_null($serviceQuantity) && !is_numeric($serviceQuantity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($serviceQuantity)), __LINE__);
        }
        $this->ServiceQuantity = $serviceQuantity;
        return $this;
    }
    /**
     * Get Status value
     * @return string|null
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @param string $status
     * @return \dgsoft\StructType\DgSpecialServiceRequestType
     */
    public function setStatus($status = null)
    {
        // validation for constraint: string
        if (!is_null($status) && !is_string($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($status)), __LINE__);
        }
        $this->Status = $status;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\StructType\DgSpecialServiceRequestType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
