<?php

namespace dgsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SpecialRemarkType StructType
 * @package Dg
 * @subpackage Structs
 */
class DgSpecialRemarkType extends AbstractStructBase
{
    /**
     * The TravelerRefNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgTravelerRefNumber[]
     */
    public $TravelerRefNumber;
    /**
     * The FlightRefNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgFlightRefNumber[]
     */
    public $FlightRefNumber;
    /**
     * The Text
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Text;
    /**
     * The Airline
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgCompanyNameType[]
     */
    public $Airline;
    /**
     * The AuthorizedViewers
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\ArrayType\DgArrayOfSpecialRemarkTypeAuthorizedViewer
     */
    public $AuthorizedViewers;
    /**
     * The RemarkType
     * @var string
     */
    public $RemarkType;
    /**
     * Constructor method for SpecialRemarkType
     * @uses DgSpecialRemarkType::setTravelerRefNumber()
     * @uses DgSpecialRemarkType::setFlightRefNumber()
     * @uses DgSpecialRemarkType::setText()
     * @uses DgSpecialRemarkType::setAirline()
     * @uses DgSpecialRemarkType::setAuthorizedViewers()
     * @uses DgSpecialRemarkType::setRemarkType()
     * @param \dgsoft\StructType\DgTravelerRefNumber[] $travelerRefNumber
     * @param \dgsoft\StructType\DgFlightRefNumber[] $flightRefNumber
     * @param string $text
     * @param \dgsoft\StructType\DgCompanyNameType[] $airline
     * @param \dgsoft\ArrayType\DgArrayOfSpecialRemarkTypeAuthorizedViewer $authorizedViewers
     * @param string $remarkType
     */
    public function __construct(array $travelerRefNumber = array(), array $flightRefNumber = array(), $text = null, array $airline = array(), \dgsoft\ArrayType\DgArrayOfSpecialRemarkTypeAuthorizedViewer $authorizedViewers = null, $remarkType = null)
    {
        $this
            ->setTravelerRefNumber($travelerRefNumber)
            ->setFlightRefNumber($flightRefNumber)
            ->setText($text)
            ->setAirline($airline)
            ->setAuthorizedViewers($authorizedViewers)
            ->setRemarkType($remarkType);
    }
    /**
     * Get TravelerRefNumber value
     * @return \dgsoft\StructType\DgTravelerRefNumber[]|null
     */
    public function getTravelerRefNumber()
    {
        return $this->TravelerRefNumber;
    }
    /**
     * Set TravelerRefNumber value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgTravelerRefNumber[] $travelerRefNumber
     * @return \dgsoft\StructType\DgSpecialRemarkType
     */
    public function setTravelerRefNumber(array $travelerRefNumber = array())
    {
        foreach ($travelerRefNumber as $specialRemarkTypeTravelerRefNumberItem) {
            // validation for constraint: itemType
            if (!$specialRemarkTypeTravelerRefNumberItem instanceof \dgsoft\StructType\DgTravelerRefNumber) {
                throw new \InvalidArgumentException(sprintf('The TravelerRefNumber property can only contain items of \dgsoft\StructType\DgTravelerRefNumber, "%s" given', is_object($specialRemarkTypeTravelerRefNumberItem) ? get_class($specialRemarkTypeTravelerRefNumberItem) : gettype($specialRemarkTypeTravelerRefNumberItem)), __LINE__);
            }
        }
        $this->TravelerRefNumber = $travelerRefNumber;
        return $this;
    }
    /**
     * Add item to TravelerRefNumber value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgTravelerRefNumber $item
     * @return \dgsoft\StructType\DgSpecialRemarkType
     */
    public function addToTravelerRefNumber(\dgsoft\StructType\DgTravelerRefNumber $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \dgsoft\StructType\DgTravelerRefNumber) {
            throw new \InvalidArgumentException(sprintf('The TravelerRefNumber property can only contain items of \dgsoft\StructType\DgTravelerRefNumber, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->TravelerRefNumber[] = $item;
        return $this;
    }
    /**
     * Get FlightRefNumber value
     * @return \dgsoft\StructType\DgFlightRefNumber[]|null
     */
    public function getFlightRefNumber()
    {
        return $this->FlightRefNumber;
    }
    /**
     * Set FlightRefNumber value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgFlightRefNumber[] $flightRefNumber
     * @return \dgsoft\StructType\DgSpecialRemarkType
     */
    public function setFlightRefNumber(array $flightRefNumber = array())
    {
        foreach ($flightRefNumber as $specialRemarkTypeFlightRefNumberItem) {
            // validation for constraint: itemType
            if (!$specialRemarkTypeFlightRefNumberItem instanceof \dgsoft\StructType\DgFlightRefNumber) {
                throw new \InvalidArgumentException(sprintf('The FlightRefNumber property can only contain items of \dgsoft\StructType\DgFlightRefNumber, "%s" given', is_object($specialRemarkTypeFlightRefNumberItem) ? get_class($specialRemarkTypeFlightRefNumberItem) : gettype($specialRemarkTypeFlightRefNumberItem)), __LINE__);
            }
        }
        $this->FlightRefNumber = $flightRefNumber;
        return $this;
    }
    /**
     * Add item to FlightRefNumber value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgFlightRefNumber $item
     * @return \dgsoft\StructType\DgSpecialRemarkType
     */
    public function addToFlightRefNumber(\dgsoft\StructType\DgFlightRefNumber $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \dgsoft\StructType\DgFlightRefNumber) {
            throw new \InvalidArgumentException(sprintf('The FlightRefNumber property can only contain items of \dgsoft\StructType\DgFlightRefNumber, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->FlightRefNumber[] = $item;
        return $this;
    }
    /**
     * Get Text value
     * @return string|null
     */
    public function getText()
    {
        return $this->Text;
    }
    /**
     * Set Text value
     * @param string $text
     * @return \dgsoft\StructType\DgSpecialRemarkType
     */
    public function setText($text = null)
    {
        // validation for constraint: string
        if (!is_null($text) && !is_string($text)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($text)), __LINE__);
        }
        $this->Text = $text;
        return $this;
    }
    /**
     * Get Airline value
     * @return \dgsoft\StructType\DgCompanyNameType[]|null
     */
    public function getAirline()
    {
        return $this->Airline;
    }
    /**
     * Set Airline value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgCompanyNameType[] $airline
     * @return \dgsoft\StructType\DgSpecialRemarkType
     */
    public function setAirline(array $airline = array())
    {
        foreach ($airline as $specialRemarkTypeAirlineItem) {
            // validation for constraint: itemType
            if (!$specialRemarkTypeAirlineItem instanceof \dgsoft\StructType\DgCompanyNameType) {
                throw new \InvalidArgumentException(sprintf('The Airline property can only contain items of \dgsoft\StructType\DgCompanyNameType, "%s" given', is_object($specialRemarkTypeAirlineItem) ? get_class($specialRemarkTypeAirlineItem) : gettype($specialRemarkTypeAirlineItem)), __LINE__);
            }
        }
        $this->Airline = $airline;
        return $this;
    }
    /**
     * Add item to Airline value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgCompanyNameType $item
     * @return \dgsoft\StructType\DgSpecialRemarkType
     */
    public function addToAirline(\dgsoft\StructType\DgCompanyNameType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \dgsoft\StructType\DgCompanyNameType) {
            throw new \InvalidArgumentException(sprintf('The Airline property can only contain items of \dgsoft\StructType\DgCompanyNameType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Airline[] = $item;
        return $this;
    }
    /**
     * Get AuthorizedViewers value
     * @return \dgsoft\ArrayType\DgArrayOfSpecialRemarkTypeAuthorizedViewer|null
     */
    public function getAuthorizedViewers()
    {
        return $this->AuthorizedViewers;
    }
    /**
     * Set AuthorizedViewers value
     * @param \dgsoft\ArrayType\DgArrayOfSpecialRemarkTypeAuthorizedViewer $authorizedViewers
     * @return \dgsoft\StructType\DgSpecialRemarkType
     */
    public function setAuthorizedViewers(\dgsoft\ArrayType\DgArrayOfSpecialRemarkTypeAuthorizedViewer $authorizedViewers = null)
    {
        $this->AuthorizedViewers = $authorizedViewers;
        return $this;
    }
    /**
     * Get RemarkType value
     * @return string|null
     */
    public function getRemarkType()
    {
        return $this->RemarkType;
    }
    /**
     * Set RemarkType value
     * @param string $remarkType
     * @return \dgsoft\StructType\DgSpecialRemarkType
     */
    public function setRemarkType($remarkType = null)
    {
        // validation for constraint: string
        if (!is_null($remarkType) && !is_string($remarkType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($remarkType)), __LINE__);
        }
        $this->RemarkType = $remarkType;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\StructType\DgSpecialRemarkType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
