<?php

namespace dgsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SourceType StructType
 * @package Dg
 * @subpackage Structs
 */
class DgSourceType extends AbstractStructBase
{
    /**
     * The RequestorID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgRequestorID
     */
    public $RequestorID;
    /**
     * The Position
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgPosition
     */
    public $Position;
    /**
     * The BookingChannel
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgBookingChannel
     */
    public $BookingChannel;
    /**
     * The AgentSine
     * @var string
     */
    public $AgentSine;
    /**
     * The PseudoCityCode
     * @var string
     */
    public $PseudoCityCode;
    /**
     * The ISOCountry
     * @var string
     */
    public $ISOCountry;
    /**
     * The ISOCurrency
     * @var string
     */
    public $ISOCurrency;
    /**
     * The AgentDutyCode
     * @var string
     */
    public $AgentDutyCode;
    /**
     * The AirlineVendorID
     * @var string
     */
    public $AirlineVendorID;
    /**
     * The AirportCode
     * @var string
     */
    public $AirportCode;
    /**
     * The FirstDepartPoint
     * @var string
     */
    public $FirstDepartPoint;
    /**
     * The ERSP_UserID
     * @var string
     */
    public $ERSP_UserID;
    /**
     * The TerminalID
     * @var string
     */
    public $TerminalID;
    /**
     * Constructor method for SourceType
     * @uses DgSourceType::setRequestorID()
     * @uses DgSourceType::setPosition()
     * @uses DgSourceType::setBookingChannel()
     * @uses DgSourceType::setAgentSine()
     * @uses DgSourceType::setPseudoCityCode()
     * @uses DgSourceType::setISOCountry()
     * @uses DgSourceType::setISOCurrency()
     * @uses DgSourceType::setAgentDutyCode()
     * @uses DgSourceType::setAirlineVendorID()
     * @uses DgSourceType::setAirportCode()
     * @uses DgSourceType::setFirstDepartPoint()
     * @uses DgSourceType::setERSP_UserID()
     * @uses DgSourceType::setTerminalID()
     * @param \dgsoft\StructType\DgRequestorID $requestorID
     * @param \dgsoft\StructType\DgPosition $position
     * @param \dgsoft\StructType\DgBookingChannel $bookingChannel
     * @param string $agentSine
     * @param string $pseudoCityCode
     * @param string $iSOCountry
     * @param string $iSOCurrency
     * @param string $agentDutyCode
     * @param string $airlineVendorID
     * @param string $airportCode
     * @param string $firstDepartPoint
     * @param string $eRSP_UserID
     * @param string $terminalID
     */
    public function __construct(\dgsoft\StructType\DgRequestorID $requestorID = null, \dgsoft\StructType\DgPosition $position = null, \dgsoft\StructType\DgBookingChannel $bookingChannel = null, $agentSine = null, $pseudoCityCode = null, $iSOCountry = null, $iSOCurrency = null, $agentDutyCode = null, $airlineVendorID = null, $airportCode = null, $firstDepartPoint = null, $eRSP_UserID = null, $terminalID = null)
    {
        $this
            ->setRequestorID($requestorID)
            ->setPosition($position)
            ->setBookingChannel($bookingChannel)
            ->setAgentSine($agentSine)
            ->setPseudoCityCode($pseudoCityCode)
            ->setISOCountry($iSOCountry)
            ->setISOCurrency($iSOCurrency)
            ->setAgentDutyCode($agentDutyCode)
            ->setAirlineVendorID($airlineVendorID)
            ->setAirportCode($airportCode)
            ->setFirstDepartPoint($firstDepartPoint)
            ->setERSP_UserID($eRSP_UserID)
            ->setTerminalID($terminalID);
    }
    /**
     * Get RequestorID value
     * @return \dgsoft\StructType\DgRequestorID|null
     */
    public function getRequestorID()
    {
        return $this->RequestorID;
    }
    /**
     * Set RequestorID value
     * @param \dgsoft\StructType\DgRequestorID $requestorID
     * @return \dgsoft\StructType\DgSourceType
     */
    public function setRequestorID(\dgsoft\StructType\DgRequestorID $requestorID = null)
    {
        $this->RequestorID = $requestorID;
        return $this;
    }
    /**
     * Get Position value
     * @return \dgsoft\StructType\DgPosition|null
     */
    public function getPosition()
    {
        return $this->Position;
    }
    /**
     * Set Position value
     * @param \dgsoft\StructType\DgPosition $position
     * @return \dgsoft\StructType\DgSourceType
     */
    public function setPosition(\dgsoft\StructType\DgPosition $position = null)
    {
        $this->Position = $position;
        return $this;
    }
    /**
     * Get BookingChannel value
     * @return \dgsoft\StructType\DgBookingChannel|null
     */
    public function getBookingChannel()
    {
        return $this->BookingChannel;
    }
    /**
     * Set BookingChannel value
     * @param \dgsoft\StructType\DgBookingChannel $bookingChannel
     * @return \dgsoft\StructType\DgSourceType
     */
    public function setBookingChannel(\dgsoft\StructType\DgBookingChannel $bookingChannel = null)
    {
        $this->BookingChannel = $bookingChannel;
        return $this;
    }
    /**
     * Get AgentSine value
     * @return string|null
     */
    public function getAgentSine()
    {
        return $this->AgentSine;
    }
    /**
     * Set AgentSine value
     * @param string $agentSine
     * @return \dgsoft\StructType\DgSourceType
     */
    public function setAgentSine($agentSine = null)
    {
        // validation for constraint: string
        if (!is_null($agentSine) && !is_string($agentSine)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($agentSine)), __LINE__);
        }
        $this->AgentSine = $agentSine;
        return $this;
    }
    /**
     * Get PseudoCityCode value
     * @return string|null
     */
    public function getPseudoCityCode()
    {
        return $this->PseudoCityCode;
    }
    /**
     * Set PseudoCityCode value
     * @param string $pseudoCityCode
     * @return \dgsoft\StructType\DgSourceType
     */
    public function setPseudoCityCode($pseudoCityCode = null)
    {
        // validation for constraint: string
        if (!is_null($pseudoCityCode) && !is_string($pseudoCityCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($pseudoCityCode)), __LINE__);
        }
        $this->PseudoCityCode = $pseudoCityCode;
        return $this;
    }
    /**
     * Get ISOCountry value
     * @return string|null
     */
    public function getISOCountry()
    {
        return $this->ISOCountry;
    }
    /**
     * Set ISOCountry value
     * @param string $iSOCountry
     * @return \dgsoft\StructType\DgSourceType
     */
    public function setISOCountry($iSOCountry = null)
    {
        // validation for constraint: string
        if (!is_null($iSOCountry) && !is_string($iSOCountry)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($iSOCountry)), __LINE__);
        }
        $this->ISOCountry = $iSOCountry;
        return $this;
    }
    /**
     * Get ISOCurrency value
     * @return string|null
     */
    public function getISOCurrency()
    {
        return $this->ISOCurrency;
    }
    /**
     * Set ISOCurrency value
     * @param string $iSOCurrency
     * @return \dgsoft\StructType\DgSourceType
     */
    public function setISOCurrency($iSOCurrency = null)
    {
        // validation for constraint: string
        if (!is_null($iSOCurrency) && !is_string($iSOCurrency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($iSOCurrency)), __LINE__);
        }
        $this->ISOCurrency = $iSOCurrency;
        return $this;
    }
    /**
     * Get AgentDutyCode value
     * @return string|null
     */
    public function getAgentDutyCode()
    {
        return $this->AgentDutyCode;
    }
    /**
     * Set AgentDutyCode value
     * @param string $agentDutyCode
     * @return \dgsoft\StructType\DgSourceType
     */
    public function setAgentDutyCode($agentDutyCode = null)
    {
        // validation for constraint: string
        if (!is_null($agentDutyCode) && !is_string($agentDutyCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($agentDutyCode)), __LINE__);
        }
        $this->AgentDutyCode = $agentDutyCode;
        return $this;
    }
    /**
     * Get AirlineVendorID value
     * @return string|null
     */
    public function getAirlineVendorID()
    {
        return $this->AirlineVendorID;
    }
    /**
     * Set AirlineVendorID value
     * @param string $airlineVendorID
     * @return \dgsoft\StructType\DgSourceType
     */
    public function setAirlineVendorID($airlineVendorID = null)
    {
        // validation for constraint: string
        if (!is_null($airlineVendorID) && !is_string($airlineVendorID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($airlineVendorID)), __LINE__);
        }
        $this->AirlineVendorID = $airlineVendorID;
        return $this;
    }
    /**
     * Get AirportCode value
     * @return string|null
     */
    public function getAirportCode()
    {
        return $this->AirportCode;
    }
    /**
     * Set AirportCode value
     * @param string $airportCode
     * @return \dgsoft\StructType\DgSourceType
     */
    public function setAirportCode($airportCode = null)
    {
        // validation for constraint: string
        if (!is_null($airportCode) && !is_string($airportCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($airportCode)), __LINE__);
        }
        $this->AirportCode = $airportCode;
        return $this;
    }
    /**
     * Get FirstDepartPoint value
     * @return string|null
     */
    public function getFirstDepartPoint()
    {
        return $this->FirstDepartPoint;
    }
    /**
     * Set FirstDepartPoint value
     * @param string $firstDepartPoint
     * @return \dgsoft\StructType\DgSourceType
     */
    public function setFirstDepartPoint($firstDepartPoint = null)
    {
        // validation for constraint: string
        if (!is_null($firstDepartPoint) && !is_string($firstDepartPoint)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($firstDepartPoint)), __LINE__);
        }
        $this->FirstDepartPoint = $firstDepartPoint;
        return $this;
    }
    /**
     * Get ERSP_UserID value
     * @return string|null
     */
    public function getERSP_UserID()
    {
        return $this->ERSP_UserID;
    }
    /**
     * Set ERSP_UserID value
     * @param string $eRSP_UserID
     * @return \dgsoft\StructType\DgSourceType
     */
    public function setERSP_UserID($eRSP_UserID = null)
    {
        // validation for constraint: string
        if (!is_null($eRSP_UserID) && !is_string($eRSP_UserID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($eRSP_UserID)), __LINE__);
        }
        $this->ERSP_UserID = $eRSP_UserID;
        return $this;
    }
    /**
     * Get TerminalID value
     * @return string|null
     */
    public function getTerminalID()
    {
        return $this->TerminalID;
    }
    /**
     * Set TerminalID value
     * @param string $terminalID
     * @return \dgsoft\StructType\DgSourceType
     */
    public function setTerminalID($terminalID = null)
    {
        // validation for constraint: string
        if (!is_null($terminalID) && !is_string($terminalID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($terminalID)), __LINE__);
        }
        $this->TerminalID = $terminalID;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\StructType\DgSourceType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
