<?php

namespace dgsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ServiceFeeType StructType
 * @package Dg
 * @subpackage Structs
 */
class DgServiceFeeType extends AbstractStructBase
{
    /**
     * The Amount
     * Meta informations extracted from the WSDL
     * - use: required
     * @var float
     */
    public $Amount;
    /**
     * The PassengerTypeQuantity
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgPassengerTypeQuantityType
     */
    public $PassengerTypeQuantity;
    /**
     * The SurChargeAmount
     * @var float
     */
    public $SurChargeAmount;
    /**
     * The ExternalServiceFee
     * @var float
     */
    public $ExternalServiceFee;
    /**
     * The ItineraryIndex
     * @var int
     */
    public $ItineraryIndex;
    /**
     * The TotalForAllPax
     * @var bool
     */
    public $TotalForAllPax;
    /**
     * The MarkupFeeAmount
     * @var float
     */
    public $MarkupFeeAmount;
    /**
     * The ExtraSeatAmount
     * @var float
     */
    public $ExtraSeatAmount;
    /**
     * The CabinBaggageAmount
     * @var float
     */
    public $CabinBaggageAmount;
    /**
     * Constructor method for ServiceFeeType
     * @uses DgServiceFeeType::setAmount()
     * @uses DgServiceFeeType::setPassengerTypeQuantity()
     * @uses DgServiceFeeType::setSurChargeAmount()
     * @uses DgServiceFeeType::setExternalServiceFee()
     * @uses DgServiceFeeType::setItineraryIndex()
     * @uses DgServiceFeeType::setTotalForAllPax()
     * @uses DgServiceFeeType::setMarkupFeeAmount()
     * @uses DgServiceFeeType::setExtraSeatAmount()
     * @uses DgServiceFeeType::setCabinBaggageAmount()
     * @param float $amount
     * @param \dgsoft\StructType\DgPassengerTypeQuantityType $passengerTypeQuantity
     * @param float $surChargeAmount
     * @param float $externalServiceFee
     * @param int $itineraryIndex
     * @param bool $totalForAllPax
     * @param float $markupFeeAmount
     * @param float $extraSeatAmount
     * @param float $cabinBaggageAmount
     */
    public function __construct($amount = null, \dgsoft\StructType\DgPassengerTypeQuantityType $passengerTypeQuantity = null, $surChargeAmount = null, $externalServiceFee = null, $itineraryIndex = null, $totalForAllPax = null, $markupFeeAmount = null, $extraSeatAmount = null, $cabinBaggageAmount = null)
    {
        $this
            ->setAmount($amount)
            ->setPassengerTypeQuantity($passengerTypeQuantity)
            ->setSurChargeAmount($surChargeAmount)
            ->setExternalServiceFee($externalServiceFee)
            ->setItineraryIndex($itineraryIndex)
            ->setTotalForAllPax($totalForAllPax)
            ->setMarkupFeeAmount($markupFeeAmount)
            ->setExtraSeatAmount($extraSeatAmount)
            ->setCabinBaggageAmount($cabinBaggageAmount);
    }
    /**
     * Get Amount value
     * @return float
     */
    public function getAmount()
    {
        return $this->Amount;
    }
    /**
     * Set Amount value
     * @param float $amount
     * @return \dgsoft\StructType\DgServiceFeeType
     */
    public function setAmount($amount = null)
    {
        $this->Amount = $amount;
        return $this;
    }
    /**
     * Get PassengerTypeQuantity value
     * @return \dgsoft\StructType\DgPassengerTypeQuantityType|null
     */
    public function getPassengerTypeQuantity()
    {
        return $this->PassengerTypeQuantity;
    }
    /**
     * Set PassengerTypeQuantity value
     * @param \dgsoft\StructType\DgPassengerTypeQuantityType $passengerTypeQuantity
     * @return \dgsoft\StructType\DgServiceFeeType
     */
    public function setPassengerTypeQuantity(\dgsoft\StructType\DgPassengerTypeQuantityType $passengerTypeQuantity = null)
    {
        $this->PassengerTypeQuantity = $passengerTypeQuantity;
        return $this;
    }
    /**
     * Get SurChargeAmount value
     * @return float|null
     */
    public function getSurChargeAmount()
    {
        return $this->SurChargeAmount;
    }
    /**
     * Set SurChargeAmount value
     * @param float $surChargeAmount
     * @return \dgsoft\StructType\DgServiceFeeType
     */
    public function setSurChargeAmount($surChargeAmount = null)
    {
        $this->SurChargeAmount = $surChargeAmount;
        return $this;
    }
    /**
     * Get ExternalServiceFee value
     * @return float|null
     */
    public function getExternalServiceFee()
    {
        return $this->ExternalServiceFee;
    }
    /**
     * Set ExternalServiceFee value
     * @param float $externalServiceFee
     * @return \dgsoft\StructType\DgServiceFeeType
     */
    public function setExternalServiceFee($externalServiceFee = null)
    {
        $this->ExternalServiceFee = $externalServiceFee;
        return $this;
    }
    /**
     * Get ItineraryIndex value
     * @return int|null
     */
    public function getItineraryIndex()
    {
        return $this->ItineraryIndex;
    }
    /**
     * Set ItineraryIndex value
     * @param int $itineraryIndex
     * @return \dgsoft\StructType\DgServiceFeeType
     */
    public function setItineraryIndex($itineraryIndex = null)
    {
        // validation for constraint: int
        if (!is_null($itineraryIndex) && !is_numeric($itineraryIndex)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($itineraryIndex)), __LINE__);
        }
        $this->ItineraryIndex = $itineraryIndex;
        return $this;
    }
    /**
     * Get TotalForAllPax value
     * @return bool|null
     */
    public function getTotalForAllPax()
    {
        return $this->TotalForAllPax;
    }
    /**
     * Set TotalForAllPax value
     * @param bool $totalForAllPax
     * @return \dgsoft\StructType\DgServiceFeeType
     */
    public function setTotalForAllPax($totalForAllPax = null)
    {
        // validation for constraint: boolean
        if (!is_null($totalForAllPax) && !is_bool($totalForAllPax)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($totalForAllPax)), __LINE__);
        }
        $this->TotalForAllPax = $totalForAllPax;
        return $this;
    }
    /**
     * Get MarkupFeeAmount value
     * @return float|null
     */
    public function getMarkupFeeAmount()
    {
        return $this->MarkupFeeAmount;
    }
    /**
     * Set MarkupFeeAmount value
     * @param float $markupFeeAmount
     * @return \dgsoft\StructType\DgServiceFeeType
     */
    public function setMarkupFeeAmount($markupFeeAmount = null)
    {
        $this->MarkupFeeAmount = $markupFeeAmount;
        return $this;
    }
    /**
     * Get ExtraSeatAmount value
     * @return float|null
     */
    public function getExtraSeatAmount()
    {
        return $this->ExtraSeatAmount;
    }
    /**
     * Set ExtraSeatAmount value
     * @param float $extraSeatAmount
     * @return \dgsoft\StructType\DgServiceFeeType
     */
    public function setExtraSeatAmount($extraSeatAmount = null)
    {
        $this->ExtraSeatAmount = $extraSeatAmount;
        return $this;
    }
    /**
     * Get CabinBaggageAmount value
     * @return float|null
     */
    public function getCabinBaggageAmount()
    {
        return $this->CabinBaggageAmount;
    }
    /**
     * Set CabinBaggageAmount value
     * @param float $cabinBaggageAmount
     * @return \dgsoft\StructType\DgServiceFeeType
     */
    public function setCabinBaggageAmount($cabinBaggageAmount = null)
    {
        $this->CabinBaggageAmount = $cabinBaggageAmount;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\StructType\DgServiceFeeType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
