<?php

namespace dgsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Segment StructType
 * @package Dg
 * @subpackage Structs
 */
class DgSegment extends AbstractStructBase
{
    /**
     * The ItinSegNbr
     * @var int
     */
    public $ItinSegNbr;
    /**
     * The FirstItinSegNbr
     * @var int
     */
    public $FirstItinSegNbr;
    /**
     * The LastItinSegNbr
     * @var int
     */
    public $LastItinSegNbr;
    /**
     * Constructor method for Segment
     * @uses DgSegment::setItinSegNbr()
     * @uses DgSegment::setFirstItinSegNbr()
     * @uses DgSegment::setLastItinSegNbr()
     * @param int $itinSegNbr
     * @param int $firstItinSegNbr
     * @param int $lastItinSegNbr
     */
    public function __construct($itinSegNbr = null, $firstItinSegNbr = null, $lastItinSegNbr = null)
    {
        $this
            ->setItinSegNbr($itinSegNbr)
            ->setFirstItinSegNbr($firstItinSegNbr)
            ->setLastItinSegNbr($lastItinSegNbr);
    }
    /**
     * Get ItinSegNbr value
     * @return int|null
     */
    public function getItinSegNbr()
    {
        return $this->ItinSegNbr;
    }
    /**
     * Set ItinSegNbr value
     * @param int $itinSegNbr
     * @return \dgsoft\StructType\DgSegment
     */
    public function setItinSegNbr($itinSegNbr = null)
    {
        // validation for constraint: int
        if (!is_null($itinSegNbr) && !is_numeric($itinSegNbr)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($itinSegNbr)), __LINE__);
        }
        $this->ItinSegNbr = $itinSegNbr;
        return $this;
    }
    /**
     * Get FirstItinSegNbr value
     * @return int|null
     */
    public function getFirstItinSegNbr()
    {
        return $this->FirstItinSegNbr;
    }
    /**
     * Set FirstItinSegNbr value
     * @param int $firstItinSegNbr
     * @return \dgsoft\StructType\DgSegment
     */
    public function setFirstItinSegNbr($firstItinSegNbr = null)
    {
        // validation for constraint: int
        if (!is_null($firstItinSegNbr) && !is_numeric($firstItinSegNbr)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($firstItinSegNbr)), __LINE__);
        }
        $this->FirstItinSegNbr = $firstItinSegNbr;
        return $this;
    }
    /**
     * Get LastItinSegNbr value
     * @return int|null
     */
    public function getLastItinSegNbr()
    {
        return $this->LastItinSegNbr;
    }
    /**
     * Set LastItinSegNbr value
     * @param int $lastItinSegNbr
     * @return \dgsoft\StructType\DgSegment
     */
    public function setLastItinSegNbr($lastItinSegNbr = null)
    {
        // validation for constraint: int
        if (!is_null($lastItinSegNbr) && !is_numeric($lastItinSegNbr)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($lastItinSegNbr)), __LINE__);
        }
        $this->LastItinSegNbr = $lastItinSegNbr;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\StructType\DgSegment
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
