<?php

namespace dgsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SeatRequest StructType
 * @package Dg
 * @subpackage Structs
 */
class DgSeatRequest extends DgSeatRequestType
{
    /**
     * The TravelerRefNumberRPHList
     * @var string[]
     */
    public $TravelerRefNumberRPHList;
    /**
     * The FlightRefNumberRPHList
     * @var string[]
     */
    public $FlightRefNumberRPHList;
    /**
     * The PartialSeatingInd
     * @var bool
     */
    public $PartialSeatingInd;
    /**
     * Constructor method for SeatRequest
     * @uses DgSeatRequest::setTravelerRefNumberRPHList()
     * @uses DgSeatRequest::setFlightRefNumberRPHList()
     * @uses DgSeatRequest::setPartialSeatingInd()
     * @param string[] $travelerRefNumberRPHList
     * @param string[] $flightRefNumberRPHList
     * @param bool $partialSeatingInd
     */
    public function __construct(array $travelerRefNumberRPHList = array(), array $flightRefNumberRPHList = array(), $partialSeatingInd = null)
    {
        $this
            ->setTravelerRefNumberRPHList($travelerRefNumberRPHList)
            ->setFlightRefNumberRPHList($flightRefNumberRPHList)
            ->setPartialSeatingInd($partialSeatingInd);
    }
    /**
     * Get TravelerRefNumberRPHList value
     * @return string[]|null
     */
    public function getTravelerRefNumberRPHList()
    {
        return $this->TravelerRefNumberRPHList;
    }
    /**
     * Set TravelerRefNumberRPHList value
     * @throws \InvalidArgumentException
     * @param string[] $travelerRefNumberRPHList
     * @return \dgsoft\StructType\DgSeatRequest
     */
    public function setTravelerRefNumberRPHList(array $travelerRefNumberRPHList = array())
    {
        foreach ($travelerRefNumberRPHList as $seatRequestTravelerRefNumberRPHListItem) {
            // validation for constraint: itemType
            if (!is_string($seatRequestTravelerRefNumberRPHListItem)) {
                throw new \InvalidArgumentException(sprintf('The TravelerRefNumberRPHList property can only contain items of string, "%s" given', is_object($seatRequestTravelerRefNumberRPHListItem) ? get_class($seatRequestTravelerRefNumberRPHListItem) : gettype($seatRequestTravelerRefNumberRPHListItem)), __LINE__);
            }
        }
        $this->TravelerRefNumberRPHList = $travelerRefNumberRPHList;
        return $this;
    }
    /**
     * Add item to TravelerRefNumberRPHList value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \dgsoft\StructType\DgSeatRequest
     */
    public function addToTravelerRefNumberRPHList($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The TravelerRefNumberRPHList property can only contain items of string, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->TravelerRefNumberRPHList[] = $item;
        return $this;
    }
    /**
     * Get FlightRefNumberRPHList value
     * @return string[]|null
     */
    public function getFlightRefNumberRPHList()
    {
        return $this->FlightRefNumberRPHList;
    }
    /**
     * Set FlightRefNumberRPHList value
     * @throws \InvalidArgumentException
     * @param string[] $flightRefNumberRPHList
     * @return \dgsoft\StructType\DgSeatRequest
     */
    public function setFlightRefNumberRPHList(array $flightRefNumberRPHList = array())
    {
        foreach ($flightRefNumberRPHList as $seatRequestFlightRefNumberRPHListItem) {
            // validation for constraint: itemType
            if (!is_string($seatRequestFlightRefNumberRPHListItem)) {
                throw new \InvalidArgumentException(sprintf('The FlightRefNumberRPHList property can only contain items of string, "%s" given', is_object($seatRequestFlightRefNumberRPHListItem) ? get_class($seatRequestFlightRefNumberRPHListItem) : gettype($seatRequestFlightRefNumberRPHListItem)), __LINE__);
            }
        }
        $this->FlightRefNumberRPHList = $flightRefNumberRPHList;
        return $this;
    }
    /**
     * Add item to FlightRefNumberRPHList value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \dgsoft\StructType\DgSeatRequest
     */
    public function addToFlightRefNumberRPHList($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The FlightRefNumberRPHList property can only contain items of string, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->FlightRefNumberRPHList[] = $item;
        return $this;
    }
    /**
     * Get PartialSeatingInd value
     * @return bool|null
     */
    public function getPartialSeatingInd()
    {
        return $this->PartialSeatingInd;
    }
    /**
     * Set PartialSeatingInd value
     * @param bool $partialSeatingInd
     * @return \dgsoft\StructType\DgSeatRequest
     */
    public function setPartialSeatingInd($partialSeatingInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($partialSeatingInd) && !is_bool($partialSeatingInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($partialSeatingInd)), __LINE__);
        }
        $this->PartialSeatingInd = $partialSeatingInd;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\StructType\DgSeatRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
