<?php

namespace dgsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ScheduleChangeParameter StructType
 * @package Dg
 * @subpackage Structs
 */
class DgScheduleChangeParameter extends AbstractStructBase
{
    /**
     * The NewDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $NewDate;
    /**
     * The OldDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $OldDate;
    /**
     * The SegmentRef
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SegmentRef;
    /**
     * Constructor method for ScheduleChangeParameter
     * @uses DgScheduleChangeParameter::setNewDate()
     * @uses DgScheduleChangeParameter::setOldDate()
     * @uses DgScheduleChangeParameter::setSegmentRef()
     * @param string $newDate
     * @param string $oldDate
     * @param string $segmentRef
     */
    public function __construct($newDate = null, $oldDate = null, $segmentRef = null)
    {
        $this
            ->setNewDate($newDate)
            ->setOldDate($oldDate)
            ->setSegmentRef($segmentRef);
    }
    /**
     * Get NewDate value
     * @return string
     */
    public function getNewDate()
    {
        return $this->NewDate;
    }
    /**
     * Set NewDate value
     * @param string $newDate
     * @return \dgsoft\StructType\DgScheduleChangeParameter
     */
    public function setNewDate($newDate = null)
    {
        // validation for constraint: string
        if (!is_null($newDate) && !is_string($newDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($newDate)), __LINE__);
        }
        $this->NewDate = $newDate;
        return $this;
    }
    /**
     * Get OldDate value
     * @return string
     */
    public function getOldDate()
    {
        return $this->OldDate;
    }
    /**
     * Set OldDate value
     * @param string $oldDate
     * @return \dgsoft\StructType\DgScheduleChangeParameter
     */
    public function setOldDate($oldDate = null)
    {
        // validation for constraint: string
        if (!is_null($oldDate) && !is_string($oldDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($oldDate)), __LINE__);
        }
        $this->OldDate = $oldDate;
        return $this;
    }
    /**
     * Get SegmentRef value
     * @return string|null
     */
    public function getSegmentRef()
    {
        return $this->SegmentRef;
    }
    /**
     * Set SegmentRef value
     * @param string $segmentRef
     * @return \dgsoft\StructType\DgScheduleChangeParameter
     */
    public function setSegmentRef($segmentRef = null)
    {
        // validation for constraint: string
        if (!is_null($segmentRef) && !is_string($segmentRef)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($segmentRef)), __LINE__);
        }
        $this->SegmentRef = $segmentRef;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\StructType\DgScheduleChangeParameter
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
