<?php

namespace dgsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RuleLink StructType
 * @package Dg
 * @subpackage Structs
 */
class DgRuleLink extends AbstractStructBase
{
    /**
     * The ItineraryIndex
     * Meta informations extracted from the WSDL
     * - use: required
     * @var int
     */
    public $ItineraryIndex;
    /**
     * The Link
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Link;
    /**
     * Constructor method for RuleLink
     * @uses DgRuleLink::setItineraryIndex()
     * @uses DgRuleLink::setLink()
     * @param int $itineraryIndex
     * @param string $link
     */
    public function __construct($itineraryIndex = null, $link = null)
    {
        $this
            ->setItineraryIndex($itineraryIndex)
            ->setLink($link);
    }
    /**
     * Get ItineraryIndex value
     * @return int
     */
    public function getItineraryIndex()
    {
        return $this->ItineraryIndex;
    }
    /**
     * Set ItineraryIndex value
     * @param int $itineraryIndex
     * @return \dgsoft\StructType\DgRuleLink
     */
    public function setItineraryIndex($itineraryIndex = null)
    {
        // validation for constraint: int
        if (!is_null($itineraryIndex) && !is_numeric($itineraryIndex)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($itineraryIndex)), __LINE__);
        }
        $this->ItineraryIndex = $itineraryIndex;
        return $this;
    }
    /**
     * Get Link value
     * @return string|null
     */
    public function getLink()
    {
        return $this->Link;
    }
    /**
     * Set Link value
     * @param string $link
     * @return \dgsoft\StructType\DgRuleLink
     */
    public function setLink($link = null)
    {
        // validation for constraint: string
        if (!is_null($link) && !is_string($link)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($link)), __LINE__);
        }
        $this->Link = $link;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\StructType\DgRuleLink
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
