<?php

namespace dgsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RuleInfos StructType
 * @package Dg
 * @subpackage Structs
 */
class DgRuleInfos extends AbstractStructBase
{
    /**
     * The CategoryType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CategoryType;
    /**
     * The RuleText
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgRuleInfosDetails[]
     */
    public $RuleText;
    /**
     * Constructor method for RuleInfos
     * @uses DgRuleInfos::setCategoryType()
     * @uses DgRuleInfos::setRuleText()
     * @param string $categoryType
     * @param \dgsoft\StructType\DgRuleInfosDetails[] $ruleText
     */
    public function __construct($categoryType = null, array $ruleText = array())
    {
        $this
            ->setCategoryType($categoryType)
            ->setRuleText($ruleText);
    }
    /**
     * Get CategoryType value
     * @return string|null
     */
    public function getCategoryType()
    {
        return $this->CategoryType;
    }
    /**
     * Set CategoryType value
     * @param string $categoryType
     * @return \dgsoft\StructType\DgRuleInfos
     */
    public function setCategoryType($categoryType = null)
    {
        // validation for constraint: string
        if (!is_null($categoryType) && !is_string($categoryType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($categoryType)), __LINE__);
        }
        $this->CategoryType = $categoryType;
        return $this;
    }
    /**
     * Get RuleText value
     * @return \dgsoft\StructType\DgRuleInfosDetails[]|null
     */
    public function getRuleText()
    {
        return $this->RuleText;
    }
    /**
     * Set RuleText value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgRuleInfosDetails[] $ruleText
     * @return \dgsoft\StructType\DgRuleInfos
     */
    public function setRuleText(array $ruleText = array())
    {
        foreach ($ruleText as $ruleInfosRuleTextItem) {
            // validation for constraint: itemType
            if (!$ruleInfosRuleTextItem instanceof \dgsoft\StructType\DgRuleInfosDetails) {
                throw new \InvalidArgumentException(sprintf('The RuleText property can only contain items of \dgsoft\StructType\DgRuleInfosDetails, "%s" given', is_object($ruleInfosRuleTextItem) ? get_class($ruleInfosRuleTextItem) : gettype($ruleInfosRuleTextItem)), __LINE__);
            }
        }
        $this->RuleText = $ruleText;
        return $this;
    }
    /**
     * Add item to RuleText value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgRuleInfosDetails $item
     * @return \dgsoft\StructType\DgRuleInfos
     */
    public function addToRuleText(\dgsoft\StructType\DgRuleInfosDetails $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \dgsoft\StructType\DgRuleInfosDetails) {
            throw new \InvalidArgumentException(sprintf('The RuleText property can only contain items of \dgsoft\StructType\DgRuleInfosDetails, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->RuleText[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\StructType\DgRuleInfos
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
