<?php

namespace dgsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RoomTypeType StructType
 * @package Dg
 * @subpackage Structs
 */
class DgRoomTypeType extends AbstractStructBase
{
    /**
     * The RoomDescription
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgParagraphType
     */
    public $RoomDescription;
    /**
     * The AdditionalDetails
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\ArrayType\DgArrayOfAdditionalDetailType
     */
    public $AdditionalDetails;
    /**
     * The Amenities
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\ArrayType\DgArrayOfRoomAmenityPrefType
     */
    public $Amenities;
    /**
     * The TPA_Extensions
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgTPA_ExtensionsType
     */
    public $TPA_Extensions;
    /**
     * The NumberOfUnits
     * @var int
     */
    public $NumberOfUnits;
    /**
     * The IsRoom
     * @var bool
     */
    public $IsRoom;
    /**
     * The IsConverted
     * @var bool
     */
    public $IsConverted;
    /**
     * The IsAlternate
     * @var bool
     */
    public $IsAlternate;
    /**
     * The ReqdGuaranteeType
     * @var string
     */
    public $ReqdGuaranteeType;
    /**
     * The RoomType
     * @var string
     */
    public $RoomType;
    /**
     * The RoomTypeCode
     * @var string
     */
    public $RoomTypeCode;
    /**
     * The RoomCategory
     * @var string
     */
    public $RoomCategory;
    /**
     * The RoomID
     * @var string
     */
    public $RoomID;
    /**
     * The Floor
     * @var int
     */
    public $Floor;
    /**
     * The InvBlockCode
     * @var string
     */
    public $InvBlockCode;
    /**
     * The RoomLocationCode
     * @var string
     */
    public $RoomLocationCode;
    /**
     * The RoomViewCode
     * @var string
     */
    public $RoomViewCode;
    /**
     * The BedTypeCode
     * @var string[]
     */
    public $BedTypeCode;
    /**
     * The NonSmoking
     * @var bool
     */
    public $NonSmoking;
    /**
     * The Configuration
     * @var string
     */
    public $Configuration;
    /**
     * The SizeMeasurement
     * @var string
     */
    public $SizeMeasurement;
    /**
     * The Quantity
     * @var int
     */
    public $Quantity;
    /**
     * The Composite
     * @var bool
     */
    public $Composite;
    /**
     * The RoomClassificationCode
     * @var string
     */
    public $RoomClassificationCode;
    /**
     * The RoomArchitectureCode
     * @var string
     */
    public $RoomArchitectureCode;
    /**
     * Constructor method for RoomTypeType
     * @uses DgRoomTypeType::setRoomDescription()
     * @uses DgRoomTypeType::setAdditionalDetails()
     * @uses DgRoomTypeType::setAmenities()
     * @uses DgRoomTypeType::setTPA_Extensions()
     * @uses DgRoomTypeType::setNumberOfUnits()
     * @uses DgRoomTypeType::setIsRoom()
     * @uses DgRoomTypeType::setIsConverted()
     * @uses DgRoomTypeType::setIsAlternate()
     * @uses DgRoomTypeType::setReqdGuaranteeType()
     * @uses DgRoomTypeType::setRoomType()
     * @uses DgRoomTypeType::setRoomTypeCode()
     * @uses DgRoomTypeType::setRoomCategory()
     * @uses DgRoomTypeType::setRoomID()
     * @uses DgRoomTypeType::setFloor()
     * @uses DgRoomTypeType::setInvBlockCode()
     * @uses DgRoomTypeType::setRoomLocationCode()
     * @uses DgRoomTypeType::setRoomViewCode()
     * @uses DgRoomTypeType::setBedTypeCode()
     * @uses DgRoomTypeType::setNonSmoking()
     * @uses DgRoomTypeType::setConfiguration()
     * @uses DgRoomTypeType::setSizeMeasurement()
     * @uses DgRoomTypeType::setQuantity()
     * @uses DgRoomTypeType::setComposite()
     * @uses DgRoomTypeType::setRoomClassificationCode()
     * @uses DgRoomTypeType::setRoomArchitectureCode()
     * @param \dgsoft\StructType\DgParagraphType $roomDescription
     * @param \dgsoft\ArrayType\DgArrayOfAdditionalDetailType $additionalDetails
     * @param \dgsoft\ArrayType\DgArrayOfRoomAmenityPrefType $amenities
     * @param \dgsoft\StructType\DgTPA_ExtensionsType $tPA_Extensions
     * @param int $numberOfUnits
     * @param bool $isRoom
     * @param bool $isConverted
     * @param bool $isAlternate
     * @param string $reqdGuaranteeType
     * @param string $roomType
     * @param string $roomTypeCode
     * @param string $roomCategory
     * @param string $roomID
     * @param int $floor
     * @param string $invBlockCode
     * @param string $roomLocationCode
     * @param string $roomViewCode
     * @param string[] $bedTypeCode
     * @param bool $nonSmoking
     * @param string $configuration
     * @param string $sizeMeasurement
     * @param int $quantity
     * @param bool $composite
     * @param string $roomClassificationCode
     * @param string $roomArchitectureCode
     */
    public function __construct(\dgsoft\StructType\DgParagraphType $roomDescription = null, \dgsoft\ArrayType\DgArrayOfAdditionalDetailType $additionalDetails = null, \dgsoft\ArrayType\DgArrayOfRoomAmenityPrefType $amenities = null, \dgsoft\StructType\DgTPA_ExtensionsType $tPA_Extensions = null, $numberOfUnits = null, $isRoom = null, $isConverted = null, $isAlternate = null, $reqdGuaranteeType = null, $roomType = null, $roomTypeCode = null, $roomCategory = null, $roomID = null, $floor = null, $invBlockCode = null, $roomLocationCode = null, $roomViewCode = null, array $bedTypeCode = array(), $nonSmoking = null, $configuration = null, $sizeMeasurement = null, $quantity = null, $composite = null, $roomClassificationCode = null, $roomArchitectureCode = null)
    {
        $this
            ->setRoomDescription($roomDescription)
            ->setAdditionalDetails($additionalDetails)
            ->setAmenities($amenities)
            ->setTPA_Extensions($tPA_Extensions)
            ->setNumberOfUnits($numberOfUnits)
            ->setIsRoom($isRoom)
            ->setIsConverted($isConverted)
            ->setIsAlternate($isAlternate)
            ->setReqdGuaranteeType($reqdGuaranteeType)
            ->setRoomType($roomType)
            ->setRoomTypeCode($roomTypeCode)
            ->setRoomCategory($roomCategory)
            ->setRoomID($roomID)
            ->setFloor($floor)
            ->setInvBlockCode($invBlockCode)
            ->setRoomLocationCode($roomLocationCode)
            ->setRoomViewCode($roomViewCode)
            ->setBedTypeCode($bedTypeCode)
            ->setNonSmoking($nonSmoking)
            ->setConfiguration($configuration)
            ->setSizeMeasurement($sizeMeasurement)
            ->setQuantity($quantity)
            ->setComposite($composite)
            ->setRoomClassificationCode($roomClassificationCode)
            ->setRoomArchitectureCode($roomArchitectureCode);
    }
    /**
     * Get RoomDescription value
     * @return \dgsoft\StructType\DgParagraphType|null
     */
    public function getRoomDescription()
    {
        return $this->RoomDescription;
    }
    /**
     * Set RoomDescription value
     * @param \dgsoft\StructType\DgParagraphType $roomDescription
     * @return \dgsoft\StructType\DgRoomTypeType
     */
    public function setRoomDescription(\dgsoft\StructType\DgParagraphType $roomDescription = null)
    {
        $this->RoomDescription = $roomDescription;
        return $this;
    }
    /**
     * Get AdditionalDetails value
     * @return \dgsoft\ArrayType\DgArrayOfAdditionalDetailType|null
     */
    public function getAdditionalDetails()
    {
        return $this->AdditionalDetails;
    }
    /**
     * Set AdditionalDetails value
     * @param \dgsoft\ArrayType\DgArrayOfAdditionalDetailType $additionalDetails
     * @return \dgsoft\StructType\DgRoomTypeType
     */
    public function setAdditionalDetails(\dgsoft\ArrayType\DgArrayOfAdditionalDetailType $additionalDetails = null)
    {
        $this->AdditionalDetails = $additionalDetails;
        return $this;
    }
    /**
     * Get Amenities value
     * @return \dgsoft\ArrayType\DgArrayOfRoomAmenityPrefType|null
     */
    public function getAmenities()
    {
        return $this->Amenities;
    }
    /**
     * Set Amenities value
     * @param \dgsoft\ArrayType\DgArrayOfRoomAmenityPrefType $amenities
     * @return \dgsoft\StructType\DgRoomTypeType
     */
    public function setAmenities(\dgsoft\ArrayType\DgArrayOfRoomAmenityPrefType $amenities = null)
    {
        $this->Amenities = $amenities;
        return $this;
    }
    /**
     * Get TPA_Extensions value
     * @return \dgsoft\StructType\DgTPA_ExtensionsType|null
     */
    public function getTPA_Extensions()
    {
        return $this->TPA_Extensions;
    }
    /**
     * Set TPA_Extensions value
     * @param \dgsoft\StructType\DgTPA_ExtensionsType $tPA_Extensions
     * @return \dgsoft\StructType\DgRoomTypeType
     */
    public function setTPA_Extensions(\dgsoft\StructType\DgTPA_ExtensionsType $tPA_Extensions = null)
    {
        $this->TPA_Extensions = $tPA_Extensions;
        return $this;
    }
    /**
     * Get NumberOfUnits value
     * @return int|null
     */
    public function getNumberOfUnits()
    {
        return $this->NumberOfUnits;
    }
    /**
     * Set NumberOfUnits value
     * @param int $numberOfUnits
     * @return \dgsoft\StructType\DgRoomTypeType
     */
    public function setNumberOfUnits($numberOfUnits = null)
    {
        // validation for constraint: int
        if (!is_null($numberOfUnits) && !is_numeric($numberOfUnits)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($numberOfUnits)), __LINE__);
        }
        $this->NumberOfUnits = $numberOfUnits;
        return $this;
    }
    /**
     * Get IsRoom value
     * @return bool|null
     */
    public function getIsRoom()
    {
        return $this->IsRoom;
    }
    /**
     * Set IsRoom value
     * @param bool $isRoom
     * @return \dgsoft\StructType\DgRoomTypeType
     */
    public function setIsRoom($isRoom = null)
    {
        // validation for constraint: boolean
        if (!is_null($isRoom) && !is_bool($isRoom)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isRoom)), __LINE__);
        }
        $this->IsRoom = $isRoom;
        return $this;
    }
    /**
     * Get IsConverted value
     * @return bool|null
     */
    public function getIsConverted()
    {
        return $this->IsConverted;
    }
    /**
     * Set IsConverted value
     * @param bool $isConverted
     * @return \dgsoft\StructType\DgRoomTypeType
     */
    public function setIsConverted($isConverted = null)
    {
        // validation for constraint: boolean
        if (!is_null($isConverted) && !is_bool($isConverted)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isConverted)), __LINE__);
        }
        $this->IsConverted = $isConverted;
        return $this;
    }
    /**
     * Get IsAlternate value
     * @return bool|null
     */
    public function getIsAlternate()
    {
        return $this->IsAlternate;
    }
    /**
     * Set IsAlternate value
     * @param bool $isAlternate
     * @return \dgsoft\StructType\DgRoomTypeType
     */
    public function setIsAlternate($isAlternate = null)
    {
        // validation for constraint: boolean
        if (!is_null($isAlternate) && !is_bool($isAlternate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isAlternate)), __LINE__);
        }
        $this->IsAlternate = $isAlternate;
        return $this;
    }
    /**
     * Get ReqdGuaranteeType value
     * @return string|null
     */
    public function getReqdGuaranteeType()
    {
        return $this->ReqdGuaranteeType;
    }
    /**
     * Set ReqdGuaranteeType value
     * @param string $reqdGuaranteeType
     * @return \dgsoft\StructType\DgRoomTypeType
     */
    public function setReqdGuaranteeType($reqdGuaranteeType = null)
    {
        // validation for constraint: string
        if (!is_null($reqdGuaranteeType) && !is_string($reqdGuaranteeType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($reqdGuaranteeType)), __LINE__);
        }
        $this->ReqdGuaranteeType = $reqdGuaranteeType;
        return $this;
    }
    /**
     * Get RoomType value
     * @return string|null
     */
    public function getRoomType()
    {
        return $this->RoomType;
    }
    /**
     * Set RoomType value
     * @param string $roomType
     * @return \dgsoft\StructType\DgRoomTypeType
     */
    public function setRoomType($roomType = null)
    {
        // validation for constraint: string
        if (!is_null($roomType) && !is_string($roomType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($roomType)), __LINE__);
        }
        $this->RoomType = $roomType;
        return $this;
    }
    /**
     * Get RoomTypeCode value
     * @return string|null
     */
    public function getRoomTypeCode()
    {
        return $this->RoomTypeCode;
    }
    /**
     * Set RoomTypeCode value
     * @param string $roomTypeCode
     * @return \dgsoft\StructType\DgRoomTypeType
     */
    public function setRoomTypeCode($roomTypeCode = null)
    {
        // validation for constraint: string
        if (!is_null($roomTypeCode) && !is_string($roomTypeCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($roomTypeCode)), __LINE__);
        }
        $this->RoomTypeCode = $roomTypeCode;
        return $this;
    }
    /**
     * Get RoomCategory value
     * @return string|null
     */
    public function getRoomCategory()
    {
        return $this->RoomCategory;
    }
    /**
     * Set RoomCategory value
     * @param string $roomCategory
     * @return \dgsoft\StructType\DgRoomTypeType
     */
    public function setRoomCategory($roomCategory = null)
    {
        // validation for constraint: string
        if (!is_null($roomCategory) && !is_string($roomCategory)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($roomCategory)), __LINE__);
        }
        $this->RoomCategory = $roomCategory;
        return $this;
    }
    /**
     * Get RoomID value
     * @return string|null
     */
    public function getRoomID()
    {
        return $this->RoomID;
    }
    /**
     * Set RoomID value
     * @param string $roomID
     * @return \dgsoft\StructType\DgRoomTypeType
     */
    public function setRoomID($roomID = null)
    {
        // validation for constraint: string
        if (!is_null($roomID) && !is_string($roomID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($roomID)), __LINE__);
        }
        $this->RoomID = $roomID;
        return $this;
    }
    /**
     * Get Floor value
     * @return int|null
     */
    public function getFloor()
    {
        return $this->Floor;
    }
    /**
     * Set Floor value
     * @param int $floor
     * @return \dgsoft\StructType\DgRoomTypeType
     */
    public function setFloor($floor = null)
    {
        // validation for constraint: int
        if (!is_null($floor) && !is_numeric($floor)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($floor)), __LINE__);
        }
        $this->Floor = $floor;
        return $this;
    }
    /**
     * Get InvBlockCode value
     * @return string|null
     */
    public function getInvBlockCode()
    {
        return $this->InvBlockCode;
    }
    /**
     * Set InvBlockCode value
     * @param string $invBlockCode
     * @return \dgsoft\StructType\DgRoomTypeType
     */
    public function setInvBlockCode($invBlockCode = null)
    {
        // validation for constraint: string
        if (!is_null($invBlockCode) && !is_string($invBlockCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($invBlockCode)), __LINE__);
        }
        $this->InvBlockCode = $invBlockCode;
        return $this;
    }
    /**
     * Get RoomLocationCode value
     * @return string|null
     */
    public function getRoomLocationCode()
    {
        return $this->RoomLocationCode;
    }
    /**
     * Set RoomLocationCode value
     * @param string $roomLocationCode
     * @return \dgsoft\StructType\DgRoomTypeType
     */
    public function setRoomLocationCode($roomLocationCode = null)
    {
        // validation for constraint: string
        if (!is_null($roomLocationCode) && !is_string($roomLocationCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($roomLocationCode)), __LINE__);
        }
        $this->RoomLocationCode = $roomLocationCode;
        return $this;
    }
    /**
     * Get RoomViewCode value
     * @return string|null
     */
    public function getRoomViewCode()
    {
        return $this->RoomViewCode;
    }
    /**
     * Set RoomViewCode value
     * @param string $roomViewCode
     * @return \dgsoft\StructType\DgRoomTypeType
     */
    public function setRoomViewCode($roomViewCode = null)
    {
        // validation for constraint: string
        if (!is_null($roomViewCode) && !is_string($roomViewCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($roomViewCode)), __LINE__);
        }
        $this->RoomViewCode = $roomViewCode;
        return $this;
    }
    /**
     * Get BedTypeCode value
     * @return string[]|null
     */
    public function getBedTypeCode()
    {
        return $this->BedTypeCode;
    }
    /**
     * Set BedTypeCode value
     * @throws \InvalidArgumentException
     * @param string[] $bedTypeCode
     * @return \dgsoft\StructType\DgRoomTypeType
     */
    public function setBedTypeCode(array $bedTypeCode = array())
    {
        foreach ($bedTypeCode as $roomTypeTypeBedTypeCodeItem) {
            // validation for constraint: itemType
            if (!is_string($roomTypeTypeBedTypeCodeItem)) {
                throw new \InvalidArgumentException(sprintf('The BedTypeCode property can only contain items of string, "%s" given', is_object($roomTypeTypeBedTypeCodeItem) ? get_class($roomTypeTypeBedTypeCodeItem) : gettype($roomTypeTypeBedTypeCodeItem)), __LINE__);
            }
        }
        $this->BedTypeCode = $bedTypeCode;
        return $this;
    }
    /**
     * Add item to BedTypeCode value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \dgsoft\StructType\DgRoomTypeType
     */
    public function addToBedTypeCode($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The BedTypeCode property can only contain items of string, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->BedTypeCode[] = $item;
        return $this;
    }
    /**
     * Get NonSmoking value
     * @return bool|null
     */
    public function getNonSmoking()
    {
        return $this->NonSmoking;
    }
    /**
     * Set NonSmoking value
     * @param bool $nonSmoking
     * @return \dgsoft\StructType\DgRoomTypeType
     */
    public function setNonSmoking($nonSmoking = null)
    {
        // validation for constraint: boolean
        if (!is_null($nonSmoking) && !is_bool($nonSmoking)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($nonSmoking)), __LINE__);
        }
        $this->NonSmoking = $nonSmoking;
        return $this;
    }
    /**
     * Get Configuration value
     * @return string|null
     */
    public function getConfiguration()
    {
        return $this->Configuration;
    }
    /**
     * Set Configuration value
     * @param string $configuration
     * @return \dgsoft\StructType\DgRoomTypeType
     */
    public function setConfiguration($configuration = null)
    {
        // validation for constraint: string
        if (!is_null($configuration) && !is_string($configuration)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($configuration)), __LINE__);
        }
        $this->Configuration = $configuration;
        return $this;
    }
    /**
     * Get SizeMeasurement value
     * @return string|null
     */
    public function getSizeMeasurement()
    {
        return $this->SizeMeasurement;
    }
    /**
     * Set SizeMeasurement value
     * @param string $sizeMeasurement
     * @return \dgsoft\StructType\DgRoomTypeType
     */
    public function setSizeMeasurement($sizeMeasurement = null)
    {
        // validation for constraint: string
        if (!is_null($sizeMeasurement) && !is_string($sizeMeasurement)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($sizeMeasurement)), __LINE__);
        }
        $this->SizeMeasurement = $sizeMeasurement;
        return $this;
    }
    /**
     * Get Quantity value
     * @return int|null
     */
    public function getQuantity()
    {
        return $this->Quantity;
    }
    /**
     * Set Quantity value
     * @param int $quantity
     * @return \dgsoft\StructType\DgRoomTypeType
     */
    public function setQuantity($quantity = null)
    {
        // validation for constraint: int
        if (!is_null($quantity) && !is_numeric($quantity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($quantity)), __LINE__);
        }
        $this->Quantity = $quantity;
        return $this;
    }
    /**
     * Get Composite value
     * @return bool|null
     */
    public function getComposite()
    {
        return $this->Composite;
    }
    /**
     * Set Composite value
     * @param bool $composite
     * @return \dgsoft\StructType\DgRoomTypeType
     */
    public function setComposite($composite = null)
    {
        // validation for constraint: boolean
        if (!is_null($composite) && !is_bool($composite)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($composite)), __LINE__);
        }
        $this->Composite = $composite;
        return $this;
    }
    /**
     * Get RoomClassificationCode value
     * @return string|null
     */
    public function getRoomClassificationCode()
    {
        return $this->RoomClassificationCode;
    }
    /**
     * Set RoomClassificationCode value
     * @param string $roomClassificationCode
     * @return \dgsoft\StructType\DgRoomTypeType
     */
    public function setRoomClassificationCode($roomClassificationCode = null)
    {
        // validation for constraint: string
        if (!is_null($roomClassificationCode) && !is_string($roomClassificationCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($roomClassificationCode)), __LINE__);
        }
        $this->RoomClassificationCode = $roomClassificationCode;
        return $this;
    }
    /**
     * Get RoomArchitectureCode value
     * @return string|null
     */
    public function getRoomArchitectureCode()
    {
        return $this->RoomArchitectureCode;
    }
    /**
     * Set RoomArchitectureCode value
     * @param string $roomArchitectureCode
     * @return \dgsoft\StructType\DgRoomTypeType
     */
    public function setRoomArchitectureCode($roomArchitectureCode = null)
    {
        // validation for constraint: string
        if (!is_null($roomArchitectureCode) && !is_string($roomArchitectureCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($roomArchitectureCode)), __LINE__);
        }
        $this->RoomArchitectureCode = $roomArchitectureCode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\StructType\DgRoomTypeType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
