<?php

namespace dgsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RoomStayType StructType
 * @package Dg
 * @subpackage Structs
 */
class DgRoomStayType extends AbstractStructBase
{
    /**
     * The RoomTypes
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\ArrayType\DgArrayOfRoomTypeType
     */
    public $RoomTypes;
    /**
     * The RatePlans
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\ArrayType\DgArrayOfRatePlanType
     */
    public $RatePlans;
    /**
     * The RoomRates
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgRoomRates
     */
    public $RoomRates;
    /**
     * The GuestCounts
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgGuestCountType
     */
    public $GuestCounts;
    /**
     * The TimeSpan
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgDateTimeSpanType
     */
    public $TimeSpan;
    /**
     * The Guarantee
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $Guarantee;
    /**
     * The DepositPayments
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\ArrayType\DgArrayOfRequiredPaymentsTypeGuaranteePayment
     */
    public $DepositPayments;
    /**
     * The CancelPenalties
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgCancelPenaltiesType
     */
    public $CancelPenalties;
    /**
     * The Discount
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgDiscountType
     */
    public $Discount;
    /**
     * The Total
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgTotalType
     */
    public $Total;
    /**
     * The BasicPropertyInfo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgBasicPropertyInfoType
     */
    public $BasicPropertyInfo;
    /**
     * The ServiceFees
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgServiceFeesType
     */
    public $ServiceFees;
    /**
     * The TPA_Extensions
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgTPA_ExtensionsType
     */
    public $TPA_Extensions;
    /**
     * The MarketCode
     * @var string
     */
    public $MarketCode;
    /**
     * The SourceOfBusiness
     * @var string
     */
    public $SourceOfBusiness;
    /**
     * The DiscountCode
     * @var string
     */
    public $DiscountCode;
    /**
     * The PromotionCode
     * @var string
     */
    public $PromotionCode;
    /**
     * The PromotionVendorCode
     * @var string[]
     */
    public $PromotionVendorCode;
    /**
     * The RoomStayStatus
     * @var string
     */
    public $RoomStayStatus;
    /**
     * The WarningRPH
     * @var string[]
     */
    public $WarningRPH;
    /**
     * Constructor method for RoomStayType
     * @uses DgRoomStayType::setRoomTypes()
     * @uses DgRoomStayType::setRatePlans()
     * @uses DgRoomStayType::setRoomRates()
     * @uses DgRoomStayType::setGuestCounts()
     * @uses DgRoomStayType::setTimeSpan()
     * @uses DgRoomStayType::setGuarantee()
     * @uses DgRoomStayType::setDepositPayments()
     * @uses DgRoomStayType::setCancelPenalties()
     * @uses DgRoomStayType::setDiscount()
     * @uses DgRoomStayType::setTotal()
     * @uses DgRoomStayType::setBasicPropertyInfo()
     * @uses DgRoomStayType::setServiceFees()
     * @uses DgRoomStayType::setTPA_Extensions()
     * @uses DgRoomStayType::setMarketCode()
     * @uses DgRoomStayType::setSourceOfBusiness()
     * @uses DgRoomStayType::setDiscountCode()
     * @uses DgRoomStayType::setPromotionCode()
     * @uses DgRoomStayType::setPromotionVendorCode()
     * @uses DgRoomStayType::setRoomStayStatus()
     * @uses DgRoomStayType::setWarningRPH()
     * @param \dgsoft\ArrayType\DgArrayOfRoomTypeType $roomTypes
     * @param \dgsoft\ArrayType\DgArrayOfRatePlanType $ratePlans
     * @param \dgsoft\StructType\DgRoomRates $roomRates
     * @param \dgsoft\StructType\DgGuestCountType $guestCounts
     * @param \dgsoft\StructType\DgDateTimeSpanType $timeSpan
     * @param string[] $guarantee
     * @param \dgsoft\ArrayType\DgArrayOfRequiredPaymentsTypeGuaranteePayment $depositPayments
     * @param \dgsoft\StructType\DgCancelPenaltiesType $cancelPenalties
     * @param \dgsoft\StructType\DgDiscountType $discount
     * @param \dgsoft\StructType\DgTotalType $total
     * @param \dgsoft\StructType\DgBasicPropertyInfoType $basicPropertyInfo
     * @param \dgsoft\StructType\DgServiceFeesType $serviceFees
     * @param \dgsoft\StructType\DgTPA_ExtensionsType $tPA_Extensions
     * @param string $marketCode
     * @param string $sourceOfBusiness
     * @param string $discountCode
     * @param string $promotionCode
     * @param string[] $promotionVendorCode
     * @param string $roomStayStatus
     * @param string[] $warningRPH
     */
    public function __construct(\dgsoft\ArrayType\DgArrayOfRoomTypeType $roomTypes = null, \dgsoft\ArrayType\DgArrayOfRatePlanType $ratePlans = null, \dgsoft\StructType\DgRoomRates $roomRates = null, \dgsoft\StructType\DgGuestCountType $guestCounts = null, \dgsoft\StructType\DgDateTimeSpanType $timeSpan = null, array $guarantee = array(), \dgsoft\ArrayType\DgArrayOfRequiredPaymentsTypeGuaranteePayment $depositPayments = null, \dgsoft\StructType\DgCancelPenaltiesType $cancelPenalties = null, \dgsoft\StructType\DgDiscountType $discount = null, \dgsoft\StructType\DgTotalType $total = null, \dgsoft\StructType\DgBasicPropertyInfoType $basicPropertyInfo = null, \dgsoft\StructType\DgServiceFeesType $serviceFees = null, \dgsoft\StructType\DgTPA_ExtensionsType $tPA_Extensions = null, $marketCode = null, $sourceOfBusiness = null, $discountCode = null, $promotionCode = null, array $promotionVendorCode = array(), $roomStayStatus = null, array $warningRPH = array())
    {
        $this
            ->setRoomTypes($roomTypes)
            ->setRatePlans($ratePlans)
            ->setRoomRates($roomRates)
            ->setGuestCounts($guestCounts)
            ->setTimeSpan($timeSpan)
            ->setGuarantee($guarantee)
            ->setDepositPayments($depositPayments)
            ->setCancelPenalties($cancelPenalties)
            ->setDiscount($discount)
            ->setTotal($total)
            ->setBasicPropertyInfo($basicPropertyInfo)
            ->setServiceFees($serviceFees)
            ->setTPA_Extensions($tPA_Extensions)
            ->setMarketCode($marketCode)
            ->setSourceOfBusiness($sourceOfBusiness)
            ->setDiscountCode($discountCode)
            ->setPromotionCode($promotionCode)
            ->setPromotionVendorCode($promotionVendorCode)
            ->setRoomStayStatus($roomStayStatus)
            ->setWarningRPH($warningRPH);
    }
    /**
     * Get RoomTypes value
     * @return \dgsoft\ArrayType\DgArrayOfRoomTypeType|null
     */
    public function getRoomTypes()
    {
        return $this->RoomTypes;
    }
    /**
     * Set RoomTypes value
     * @param \dgsoft\ArrayType\DgArrayOfRoomTypeType $roomTypes
     * @return \dgsoft\StructType\DgRoomStayType
     */
    public function setRoomTypes(\dgsoft\ArrayType\DgArrayOfRoomTypeType $roomTypes = null)
    {
        $this->RoomTypes = $roomTypes;
        return $this;
    }
    /**
     * Get RatePlans value
     * @return \dgsoft\ArrayType\DgArrayOfRatePlanType|null
     */
    public function getRatePlans()
    {
        return $this->RatePlans;
    }
    /**
     * Set RatePlans value
     * @param \dgsoft\ArrayType\DgArrayOfRatePlanType $ratePlans
     * @return \dgsoft\StructType\DgRoomStayType
     */
    public function setRatePlans(\dgsoft\ArrayType\DgArrayOfRatePlanType $ratePlans = null)
    {
        $this->RatePlans = $ratePlans;
        return $this;
    }
    /**
     * Get RoomRates value
     * @return \dgsoft\StructType\DgRoomRates|null
     */
    public function getRoomRates()
    {
        return $this->RoomRates;
    }
    /**
     * Set RoomRates value
     * @param \dgsoft\StructType\DgRoomRates $roomRates
     * @return \dgsoft\StructType\DgRoomStayType
     */
    public function setRoomRates(\dgsoft\StructType\DgRoomRates $roomRates = null)
    {
        $this->RoomRates = $roomRates;
        return $this;
    }
    /**
     * Get GuestCounts value
     * @return \dgsoft\StructType\DgGuestCountType|null
     */
    public function getGuestCounts()
    {
        return $this->GuestCounts;
    }
    /**
     * Set GuestCounts value
     * @param \dgsoft\StructType\DgGuestCountType $guestCounts
     * @return \dgsoft\StructType\DgRoomStayType
     */
    public function setGuestCounts(\dgsoft\StructType\DgGuestCountType $guestCounts = null)
    {
        $this->GuestCounts = $guestCounts;
        return $this;
    }
    /**
     * Get TimeSpan value
     * @return \dgsoft\StructType\DgDateTimeSpanType|null
     */
    public function getTimeSpan()
    {
        return $this->TimeSpan;
    }
    /**
     * Set TimeSpan value
     * @param \dgsoft\StructType\DgDateTimeSpanType $timeSpan
     * @return \dgsoft\StructType\DgRoomStayType
     */
    public function setTimeSpan(\dgsoft\StructType\DgDateTimeSpanType $timeSpan = null)
    {
        $this->TimeSpan = $timeSpan;
        return $this;
    }
    /**
     * Get Guarantee value
     * @return string[]|null
     */
    public function getGuarantee()
    {
        return $this->Guarantee;
    }
    /**
     * Set Guarantee value
     * @uses \dgsoft\EnumType\DgGuaranteeType::valueIsValid()
     * @uses \dgsoft\EnumType\DgGuaranteeType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string[] $guarantee
     * @return \dgsoft\StructType\DgRoomStayType
     */
    public function setGuarantee(array $guarantee = array())
    {
        $invalidValues = array();
        foreach ($guarantee as $roomStayTypeGuaranteeItem) {
            if (!\dgsoft\EnumType\DgGuaranteeType::valueIsValid($roomStayTypeGuaranteeItem)) {
                $invalidValues[] = var_export($roomStayTypeGuaranteeItem, true);
            }
        }
        if (!empty($invalidValues)) {
            throw new \InvalidArgumentException(sprintf('Value(s) "%s" is/are invalid, please use one of: %s', implode(', ', $invalidValues), implode(', ', \dgsoft\EnumType\DgGuaranteeType::getValidValues())), __LINE__);
        }
        $this->Guarantee = $guarantee;
        return $this;
    }
    /**
     * Add item to Guarantee value
     * @uses \dgsoft\EnumType\DgGuaranteeType::valueIsValid()
     * @uses \dgsoft\EnumType\DgGuaranteeType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \dgsoft\StructType\DgRoomStayType
     */
    public function addToGuarantee($item)
    {
        // validation for constraint: enumeration
        if (!\dgsoft\EnumType\DgGuaranteeType::valueIsValid($item)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $item, implode(', ', \dgsoft\EnumType\DgGuaranteeType::getValidValues())), __LINE__);
        }
        $this->Guarantee[] = $item;
        return $this;
    }
    /**
     * Get DepositPayments value
     * @return \dgsoft\ArrayType\DgArrayOfRequiredPaymentsTypeGuaranteePayment|null
     */
    public function getDepositPayments()
    {
        return $this->DepositPayments;
    }
    /**
     * Set DepositPayments value
     * @param \dgsoft\ArrayType\DgArrayOfRequiredPaymentsTypeGuaranteePayment $depositPayments
     * @return \dgsoft\StructType\DgRoomStayType
     */
    public function setDepositPayments(\dgsoft\ArrayType\DgArrayOfRequiredPaymentsTypeGuaranteePayment $depositPayments = null)
    {
        $this->DepositPayments = $depositPayments;
        return $this;
    }
    /**
     * Get CancelPenalties value
     * @return \dgsoft\StructType\DgCancelPenaltiesType|null
     */
    public function getCancelPenalties()
    {
        return $this->CancelPenalties;
    }
    /**
     * Set CancelPenalties value
     * @param \dgsoft\StructType\DgCancelPenaltiesType $cancelPenalties
     * @return \dgsoft\StructType\DgRoomStayType
     */
    public function setCancelPenalties(\dgsoft\StructType\DgCancelPenaltiesType $cancelPenalties = null)
    {
        $this->CancelPenalties = $cancelPenalties;
        return $this;
    }
    /**
     * Get Discount value
     * @return \dgsoft\StructType\DgDiscountType|null
     */
    public function getDiscount()
    {
        return $this->Discount;
    }
    /**
     * Set Discount value
     * @param \dgsoft\StructType\DgDiscountType $discount
     * @return \dgsoft\StructType\DgRoomStayType
     */
    public function setDiscount(\dgsoft\StructType\DgDiscountType $discount = null)
    {
        $this->Discount = $discount;
        return $this;
    }
    /**
     * Get Total value
     * @return \dgsoft\StructType\DgTotalType|null
     */
    public function getTotal()
    {
        return $this->Total;
    }
    /**
     * Set Total value
     * @param \dgsoft\StructType\DgTotalType $total
     * @return \dgsoft\StructType\DgRoomStayType
     */
    public function setTotal(\dgsoft\StructType\DgTotalType $total = null)
    {
        $this->Total = $total;
        return $this;
    }
    /**
     * Get BasicPropertyInfo value
     * @return \dgsoft\StructType\DgBasicPropertyInfoType|null
     */
    public function getBasicPropertyInfo()
    {
        return $this->BasicPropertyInfo;
    }
    /**
     * Set BasicPropertyInfo value
     * @param \dgsoft\StructType\DgBasicPropertyInfoType $basicPropertyInfo
     * @return \dgsoft\StructType\DgRoomStayType
     */
    public function setBasicPropertyInfo(\dgsoft\StructType\DgBasicPropertyInfoType $basicPropertyInfo = null)
    {
        $this->BasicPropertyInfo = $basicPropertyInfo;
        return $this;
    }
    /**
     * Get ServiceFees value
     * @return \dgsoft\StructType\DgServiceFeesType|null
     */
    public function getServiceFees()
    {
        return $this->ServiceFees;
    }
    /**
     * Set ServiceFees value
     * @param \dgsoft\StructType\DgServiceFeesType $serviceFees
     * @return \dgsoft\StructType\DgRoomStayType
     */
    public function setServiceFees(\dgsoft\StructType\DgServiceFeesType $serviceFees = null)
    {
        $this->ServiceFees = $serviceFees;
        return $this;
    }
    /**
     * Get TPA_Extensions value
     * @return \dgsoft\StructType\DgTPA_ExtensionsType|null
     */
    public function getTPA_Extensions()
    {
        return $this->TPA_Extensions;
    }
    /**
     * Set TPA_Extensions value
     * @param \dgsoft\StructType\DgTPA_ExtensionsType $tPA_Extensions
     * @return \dgsoft\StructType\DgRoomStayType
     */
    public function setTPA_Extensions(\dgsoft\StructType\DgTPA_ExtensionsType $tPA_Extensions = null)
    {
        $this->TPA_Extensions = $tPA_Extensions;
        return $this;
    }
    /**
     * Get MarketCode value
     * @return string|null
     */
    public function getMarketCode()
    {
        return $this->MarketCode;
    }
    /**
     * Set MarketCode value
     * @param string $marketCode
     * @return \dgsoft\StructType\DgRoomStayType
     */
    public function setMarketCode($marketCode = null)
    {
        // validation for constraint: string
        if (!is_null($marketCode) && !is_string($marketCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($marketCode)), __LINE__);
        }
        $this->MarketCode = $marketCode;
        return $this;
    }
    /**
     * Get SourceOfBusiness value
     * @return string|null
     */
    public function getSourceOfBusiness()
    {
        return $this->SourceOfBusiness;
    }
    /**
     * Set SourceOfBusiness value
     * @param string $sourceOfBusiness
     * @return \dgsoft\StructType\DgRoomStayType
     */
    public function setSourceOfBusiness($sourceOfBusiness = null)
    {
        // validation for constraint: string
        if (!is_null($sourceOfBusiness) && !is_string($sourceOfBusiness)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($sourceOfBusiness)), __LINE__);
        }
        $this->SourceOfBusiness = $sourceOfBusiness;
        return $this;
    }
    /**
     * Get DiscountCode value
     * @return string|null
     */
    public function getDiscountCode()
    {
        return $this->DiscountCode;
    }
    /**
     * Set DiscountCode value
     * @param string $discountCode
     * @return \dgsoft\StructType\DgRoomStayType
     */
    public function setDiscountCode($discountCode = null)
    {
        // validation for constraint: string
        if (!is_null($discountCode) && !is_string($discountCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($discountCode)), __LINE__);
        }
        $this->DiscountCode = $discountCode;
        return $this;
    }
    /**
     * Get PromotionCode value
     * @return string|null
     */
    public function getPromotionCode()
    {
        return $this->PromotionCode;
    }
    /**
     * Set PromotionCode value
     * @param string $promotionCode
     * @return \dgsoft\StructType\DgRoomStayType
     */
    public function setPromotionCode($promotionCode = null)
    {
        // validation for constraint: string
        if (!is_null($promotionCode) && !is_string($promotionCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($promotionCode)), __LINE__);
        }
        $this->PromotionCode = $promotionCode;
        return $this;
    }
    /**
     * Get PromotionVendorCode value
     * @return string[]|null
     */
    public function getPromotionVendorCode()
    {
        return $this->PromotionVendorCode;
    }
    /**
     * Set PromotionVendorCode value
     * @throws \InvalidArgumentException
     * @param string[] $promotionVendorCode
     * @return \dgsoft\StructType\DgRoomStayType
     */
    public function setPromotionVendorCode(array $promotionVendorCode = array())
    {
        foreach ($promotionVendorCode as $roomStayTypePromotionVendorCodeItem) {
            // validation for constraint: itemType
            if (!is_string($roomStayTypePromotionVendorCodeItem)) {
                throw new \InvalidArgumentException(sprintf('The PromotionVendorCode property can only contain items of string, "%s" given', is_object($roomStayTypePromotionVendorCodeItem) ? get_class($roomStayTypePromotionVendorCodeItem) : gettype($roomStayTypePromotionVendorCodeItem)), __LINE__);
            }
        }
        $this->PromotionVendorCode = $promotionVendorCode;
        return $this;
    }
    /**
     * Add item to PromotionVendorCode value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \dgsoft\StructType\DgRoomStayType
     */
    public function addToPromotionVendorCode($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The PromotionVendorCode property can only contain items of string, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->PromotionVendorCode[] = $item;
        return $this;
    }
    /**
     * Get RoomStayStatus value
     * @return string|null
     */
    public function getRoomStayStatus()
    {
        return $this->RoomStayStatus;
    }
    /**
     * Set RoomStayStatus value
     * @param string $roomStayStatus
     * @return \dgsoft\StructType\DgRoomStayType
     */
    public function setRoomStayStatus($roomStayStatus = null)
    {
        // validation for constraint: string
        if (!is_null($roomStayStatus) && !is_string($roomStayStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($roomStayStatus)), __LINE__);
        }
        $this->RoomStayStatus = $roomStayStatus;
        return $this;
    }
    /**
     * Get WarningRPH value
     * @return string[]|null
     */
    public function getWarningRPH()
    {
        return $this->WarningRPH;
    }
    /**
     * Set WarningRPH value
     * @throws \InvalidArgumentException
     * @param string[] $warningRPH
     * @return \dgsoft\StructType\DgRoomStayType
     */
    public function setWarningRPH(array $warningRPH = array())
    {
        foreach ($warningRPH as $roomStayTypeWarningRPHItem) {
            // validation for constraint: itemType
            if (!is_string($roomStayTypeWarningRPHItem)) {
                throw new \InvalidArgumentException(sprintf('The WarningRPH property can only contain items of string, "%s" given', is_object($roomStayTypeWarningRPHItem) ? get_class($roomStayTypeWarningRPHItem) : gettype($roomStayTypeWarningRPHItem)), __LINE__);
            }
        }
        $this->WarningRPH = $warningRPH;
        return $this;
    }
    /**
     * Add item to WarningRPH value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \dgsoft\StructType\DgRoomStayType
     */
    public function addToWarningRPH($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The WarningRPH property can only contain items of string, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->WarningRPH[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\StructType\DgRoomStayType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
