<?php

namespace dgsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RoomStayCandidateType StructType
 * @package Dg
 * @subpackage Structs
 */
class DgRoomStayCandidateType extends AbstractStructBase
{
    /**
     * The GuestCounts
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgGuestCountType
     */
    public $GuestCounts;
    /**
     * The RoomAmenity
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgRoomAmenityPrefType[]
     */
    public $RoomAmenity;
    /**
     * The RoomType
     * @var string
     */
    public $RoomType;
    /**
     * The RoomTypeCode
     * @var string
     */
    public $RoomTypeCode;
    /**
     * The RoomCategory
     * @var string
     */
    public $RoomCategory;
    /**
     * The RoomID
     * @var string
     */
    public $RoomID;
    /**
     * The Floor
     * @var int
     */
    public $Floor;
    /**
     * The InvBlockCode
     * @var string
     */
    public $InvBlockCode;
    /**
     * The RoomLocationCode
     * @var string
     */
    public $RoomLocationCode;
    /**
     * The RoomViewCode
     * @var string
     */
    public $RoomViewCode;
    /**
     * The BedTypeCode
     * @var string[]
     */
    public $BedTypeCode;
    /**
     * The NonSmoking
     * @var bool
     */
    public $NonSmoking;
    /**
     * The Configuration
     * @var string
     */
    public $Configuration;
    /**
     * The SizeMeasurement
     * @var string
     */
    public $SizeMeasurement;
    /**
     * The Quantity
     * @var int
     */
    public $Quantity;
    /**
     * The Composite
     * @var bool
     */
    public $Composite;
    /**
     * The RoomClassificationCode
     * @var string
     */
    public $RoomClassificationCode;
    /**
     * The RoomArchitectureCode
     * @var string
     */
    public $RoomArchitectureCode;
    /**
     * The RPH
     * @var string
     */
    public $RPH;
    /**
     * The RatePlanCandidateRPH
     * @var string
     */
    public $RatePlanCandidateRPH;
    /**
     * The BookingCode
     * @var string
     */
    public $BookingCode;
    /**
     * The EffectiveDate
     * @var string
     */
    public $EffectiveDate;
    /**
     * The ExpireDate
     * @var string
     */
    public $ExpireDate;
    /**
     * Constructor method for RoomStayCandidateType
     * @uses DgRoomStayCandidateType::setGuestCounts()
     * @uses DgRoomStayCandidateType::setRoomAmenity()
     * @uses DgRoomStayCandidateType::setRoomType()
     * @uses DgRoomStayCandidateType::setRoomTypeCode()
     * @uses DgRoomStayCandidateType::setRoomCategory()
     * @uses DgRoomStayCandidateType::setRoomID()
     * @uses DgRoomStayCandidateType::setFloor()
     * @uses DgRoomStayCandidateType::setInvBlockCode()
     * @uses DgRoomStayCandidateType::setRoomLocationCode()
     * @uses DgRoomStayCandidateType::setRoomViewCode()
     * @uses DgRoomStayCandidateType::setBedTypeCode()
     * @uses DgRoomStayCandidateType::setNonSmoking()
     * @uses DgRoomStayCandidateType::setConfiguration()
     * @uses DgRoomStayCandidateType::setSizeMeasurement()
     * @uses DgRoomStayCandidateType::setQuantity()
     * @uses DgRoomStayCandidateType::setComposite()
     * @uses DgRoomStayCandidateType::setRoomClassificationCode()
     * @uses DgRoomStayCandidateType::setRoomArchitectureCode()
     * @uses DgRoomStayCandidateType::setRPH()
     * @uses DgRoomStayCandidateType::setRatePlanCandidateRPH()
     * @uses DgRoomStayCandidateType::setBookingCode()
     * @uses DgRoomStayCandidateType::setEffectiveDate()
     * @uses DgRoomStayCandidateType::setExpireDate()
     * @param \dgsoft\StructType\DgGuestCountType $guestCounts
     * @param \dgsoft\StructType\DgRoomAmenityPrefType[] $roomAmenity
     * @param string $roomType
     * @param string $roomTypeCode
     * @param string $roomCategory
     * @param string $roomID
     * @param int $floor
     * @param string $invBlockCode
     * @param string $roomLocationCode
     * @param string $roomViewCode
     * @param string[] $bedTypeCode
     * @param bool $nonSmoking
     * @param string $configuration
     * @param string $sizeMeasurement
     * @param int $quantity
     * @param bool $composite
     * @param string $roomClassificationCode
     * @param string $roomArchitectureCode
     * @param string $rPH
     * @param string $ratePlanCandidateRPH
     * @param string $bookingCode
     * @param string $effectiveDate
     * @param string $expireDate
     */
    public function __construct(\dgsoft\StructType\DgGuestCountType $guestCounts = null, array $roomAmenity = array(), $roomType = null, $roomTypeCode = null, $roomCategory = null, $roomID = null, $floor = null, $invBlockCode = null, $roomLocationCode = null, $roomViewCode = null, array $bedTypeCode = array(), $nonSmoking = null, $configuration = null, $sizeMeasurement = null, $quantity = null, $composite = null, $roomClassificationCode = null, $roomArchitectureCode = null, $rPH = null, $ratePlanCandidateRPH = null, $bookingCode = null, $effectiveDate = null, $expireDate = null)
    {
        $this
            ->setGuestCounts($guestCounts)
            ->setRoomAmenity($roomAmenity)
            ->setRoomType($roomType)
            ->setRoomTypeCode($roomTypeCode)
            ->setRoomCategory($roomCategory)
            ->setRoomID($roomID)
            ->setFloor($floor)
            ->setInvBlockCode($invBlockCode)
            ->setRoomLocationCode($roomLocationCode)
            ->setRoomViewCode($roomViewCode)
            ->setBedTypeCode($bedTypeCode)
            ->setNonSmoking($nonSmoking)
            ->setConfiguration($configuration)
            ->setSizeMeasurement($sizeMeasurement)
            ->setQuantity($quantity)
            ->setComposite($composite)
            ->setRoomClassificationCode($roomClassificationCode)
            ->setRoomArchitectureCode($roomArchitectureCode)
            ->setRPH($rPH)
            ->setRatePlanCandidateRPH($ratePlanCandidateRPH)
            ->setBookingCode($bookingCode)
            ->setEffectiveDate($effectiveDate)
            ->setExpireDate($expireDate);
    }
    /**
     * Get GuestCounts value
     * @return \dgsoft\StructType\DgGuestCountType|null
     */
    public function getGuestCounts()
    {
        return $this->GuestCounts;
    }
    /**
     * Set GuestCounts value
     * @param \dgsoft\StructType\DgGuestCountType $guestCounts
     * @return \dgsoft\StructType\DgRoomStayCandidateType
     */
    public function setGuestCounts(\dgsoft\StructType\DgGuestCountType $guestCounts = null)
    {
        $this->GuestCounts = $guestCounts;
        return $this;
    }
    /**
     * Get RoomAmenity value
     * @return \dgsoft\StructType\DgRoomAmenityPrefType[]|null
     */
    public function getRoomAmenity()
    {
        return $this->RoomAmenity;
    }
    /**
     * Set RoomAmenity value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgRoomAmenityPrefType[] $roomAmenity
     * @return \dgsoft\StructType\DgRoomStayCandidateType
     */
    public function setRoomAmenity(array $roomAmenity = array())
    {
        foreach ($roomAmenity as $roomStayCandidateTypeRoomAmenityItem) {
            // validation for constraint: itemType
            if (!$roomStayCandidateTypeRoomAmenityItem instanceof \dgsoft\StructType\DgRoomAmenityPrefType) {
                throw new \InvalidArgumentException(sprintf('The RoomAmenity property can only contain items of \dgsoft\StructType\DgRoomAmenityPrefType, "%s" given', is_object($roomStayCandidateTypeRoomAmenityItem) ? get_class($roomStayCandidateTypeRoomAmenityItem) : gettype($roomStayCandidateTypeRoomAmenityItem)), __LINE__);
            }
        }
        $this->RoomAmenity = $roomAmenity;
        return $this;
    }
    /**
     * Add item to RoomAmenity value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgRoomAmenityPrefType $item
     * @return \dgsoft\StructType\DgRoomStayCandidateType
     */
    public function addToRoomAmenity(\dgsoft\StructType\DgRoomAmenityPrefType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \dgsoft\StructType\DgRoomAmenityPrefType) {
            throw new \InvalidArgumentException(sprintf('The RoomAmenity property can only contain items of \dgsoft\StructType\DgRoomAmenityPrefType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->RoomAmenity[] = $item;
        return $this;
    }
    /**
     * Get RoomType value
     * @return string|null
     */
    public function getRoomType()
    {
        return $this->RoomType;
    }
    /**
     * Set RoomType value
     * @param string $roomType
     * @return \dgsoft\StructType\DgRoomStayCandidateType
     */
    public function setRoomType($roomType = null)
    {
        // validation for constraint: string
        if (!is_null($roomType) && !is_string($roomType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($roomType)), __LINE__);
        }
        $this->RoomType = $roomType;
        return $this;
    }
    /**
     * Get RoomTypeCode value
     * @return string|null
     */
    public function getRoomTypeCode()
    {
        return $this->RoomTypeCode;
    }
    /**
     * Set RoomTypeCode value
     * @param string $roomTypeCode
     * @return \dgsoft\StructType\DgRoomStayCandidateType
     */
    public function setRoomTypeCode($roomTypeCode = null)
    {
        // validation for constraint: string
        if (!is_null($roomTypeCode) && !is_string($roomTypeCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($roomTypeCode)), __LINE__);
        }
        $this->RoomTypeCode = $roomTypeCode;
        return $this;
    }
    /**
     * Get RoomCategory value
     * @return string|null
     */
    public function getRoomCategory()
    {
        return $this->RoomCategory;
    }
    /**
     * Set RoomCategory value
     * @param string $roomCategory
     * @return \dgsoft\StructType\DgRoomStayCandidateType
     */
    public function setRoomCategory($roomCategory = null)
    {
        // validation for constraint: string
        if (!is_null($roomCategory) && !is_string($roomCategory)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($roomCategory)), __LINE__);
        }
        $this->RoomCategory = $roomCategory;
        return $this;
    }
    /**
     * Get RoomID value
     * @return string|null
     */
    public function getRoomID()
    {
        return $this->RoomID;
    }
    /**
     * Set RoomID value
     * @param string $roomID
     * @return \dgsoft\StructType\DgRoomStayCandidateType
     */
    public function setRoomID($roomID = null)
    {
        // validation for constraint: string
        if (!is_null($roomID) && !is_string($roomID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($roomID)), __LINE__);
        }
        $this->RoomID = $roomID;
        return $this;
    }
    /**
     * Get Floor value
     * @return int|null
     */
    public function getFloor()
    {
        return $this->Floor;
    }
    /**
     * Set Floor value
     * @param int $floor
     * @return \dgsoft\StructType\DgRoomStayCandidateType
     */
    public function setFloor($floor = null)
    {
        // validation for constraint: int
        if (!is_null($floor) && !is_numeric($floor)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($floor)), __LINE__);
        }
        $this->Floor = $floor;
        return $this;
    }
    /**
     * Get InvBlockCode value
     * @return string|null
     */
    public function getInvBlockCode()
    {
        return $this->InvBlockCode;
    }
    /**
     * Set InvBlockCode value
     * @param string $invBlockCode
     * @return \dgsoft\StructType\DgRoomStayCandidateType
     */
    public function setInvBlockCode($invBlockCode = null)
    {
        // validation for constraint: string
        if (!is_null($invBlockCode) && !is_string($invBlockCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($invBlockCode)), __LINE__);
        }
        $this->InvBlockCode = $invBlockCode;
        return $this;
    }
    /**
     * Get RoomLocationCode value
     * @return string|null
     */
    public function getRoomLocationCode()
    {
        return $this->RoomLocationCode;
    }
    /**
     * Set RoomLocationCode value
     * @param string $roomLocationCode
     * @return \dgsoft\StructType\DgRoomStayCandidateType
     */
    public function setRoomLocationCode($roomLocationCode = null)
    {
        // validation for constraint: string
        if (!is_null($roomLocationCode) && !is_string($roomLocationCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($roomLocationCode)), __LINE__);
        }
        $this->RoomLocationCode = $roomLocationCode;
        return $this;
    }
    /**
     * Get RoomViewCode value
     * @return string|null
     */
    public function getRoomViewCode()
    {
        return $this->RoomViewCode;
    }
    /**
     * Set RoomViewCode value
     * @param string $roomViewCode
     * @return \dgsoft\StructType\DgRoomStayCandidateType
     */
    public function setRoomViewCode($roomViewCode = null)
    {
        // validation for constraint: string
        if (!is_null($roomViewCode) && !is_string($roomViewCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($roomViewCode)), __LINE__);
        }
        $this->RoomViewCode = $roomViewCode;
        return $this;
    }
    /**
     * Get BedTypeCode value
     * @return string[]|null
     */
    public function getBedTypeCode()
    {
        return $this->BedTypeCode;
    }
    /**
     * Set BedTypeCode value
     * @throws \InvalidArgumentException
     * @param string[] $bedTypeCode
     * @return \dgsoft\StructType\DgRoomStayCandidateType
     */
    public function setBedTypeCode(array $bedTypeCode = array())
    {
        foreach ($bedTypeCode as $roomStayCandidateTypeBedTypeCodeItem) {
            // validation for constraint: itemType
            if (!is_string($roomStayCandidateTypeBedTypeCodeItem)) {
                throw new \InvalidArgumentException(sprintf('The BedTypeCode property can only contain items of string, "%s" given', is_object($roomStayCandidateTypeBedTypeCodeItem) ? get_class($roomStayCandidateTypeBedTypeCodeItem) : gettype($roomStayCandidateTypeBedTypeCodeItem)), __LINE__);
            }
        }
        $this->BedTypeCode = $bedTypeCode;
        return $this;
    }
    /**
     * Add item to BedTypeCode value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \dgsoft\StructType\DgRoomStayCandidateType
     */
    public function addToBedTypeCode($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The BedTypeCode property can only contain items of string, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->BedTypeCode[] = $item;
        return $this;
    }
    /**
     * Get NonSmoking value
     * @return bool|null
     */
    public function getNonSmoking()
    {
        return $this->NonSmoking;
    }
    /**
     * Set NonSmoking value
     * @param bool $nonSmoking
     * @return \dgsoft\StructType\DgRoomStayCandidateType
     */
    public function setNonSmoking($nonSmoking = null)
    {
        // validation for constraint: boolean
        if (!is_null($nonSmoking) && !is_bool($nonSmoking)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($nonSmoking)), __LINE__);
        }
        $this->NonSmoking = $nonSmoking;
        return $this;
    }
    /**
     * Get Configuration value
     * @return string|null
     */
    public function getConfiguration()
    {
        return $this->Configuration;
    }
    /**
     * Set Configuration value
     * @param string $configuration
     * @return \dgsoft\StructType\DgRoomStayCandidateType
     */
    public function setConfiguration($configuration = null)
    {
        // validation for constraint: string
        if (!is_null($configuration) && !is_string($configuration)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($configuration)), __LINE__);
        }
        $this->Configuration = $configuration;
        return $this;
    }
    /**
     * Get SizeMeasurement value
     * @return string|null
     */
    public function getSizeMeasurement()
    {
        return $this->SizeMeasurement;
    }
    /**
     * Set SizeMeasurement value
     * @param string $sizeMeasurement
     * @return \dgsoft\StructType\DgRoomStayCandidateType
     */
    public function setSizeMeasurement($sizeMeasurement = null)
    {
        // validation for constraint: string
        if (!is_null($sizeMeasurement) && !is_string($sizeMeasurement)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($sizeMeasurement)), __LINE__);
        }
        $this->SizeMeasurement = $sizeMeasurement;
        return $this;
    }
    /**
     * Get Quantity value
     * @return int|null
     */
    public function getQuantity()
    {
        return $this->Quantity;
    }
    /**
     * Set Quantity value
     * @param int $quantity
     * @return \dgsoft\StructType\DgRoomStayCandidateType
     */
    public function setQuantity($quantity = null)
    {
        // validation for constraint: int
        if (!is_null($quantity) && !is_numeric($quantity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($quantity)), __LINE__);
        }
        $this->Quantity = $quantity;
        return $this;
    }
    /**
     * Get Composite value
     * @return bool|null
     */
    public function getComposite()
    {
        return $this->Composite;
    }
    /**
     * Set Composite value
     * @param bool $composite
     * @return \dgsoft\StructType\DgRoomStayCandidateType
     */
    public function setComposite($composite = null)
    {
        // validation for constraint: boolean
        if (!is_null($composite) && !is_bool($composite)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($composite)), __LINE__);
        }
        $this->Composite = $composite;
        return $this;
    }
    /**
     * Get RoomClassificationCode value
     * @return string|null
     */
    public function getRoomClassificationCode()
    {
        return $this->RoomClassificationCode;
    }
    /**
     * Set RoomClassificationCode value
     * @param string $roomClassificationCode
     * @return \dgsoft\StructType\DgRoomStayCandidateType
     */
    public function setRoomClassificationCode($roomClassificationCode = null)
    {
        // validation for constraint: string
        if (!is_null($roomClassificationCode) && !is_string($roomClassificationCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($roomClassificationCode)), __LINE__);
        }
        $this->RoomClassificationCode = $roomClassificationCode;
        return $this;
    }
    /**
     * Get RoomArchitectureCode value
     * @return string|null
     */
    public function getRoomArchitectureCode()
    {
        return $this->RoomArchitectureCode;
    }
    /**
     * Set RoomArchitectureCode value
     * @param string $roomArchitectureCode
     * @return \dgsoft\StructType\DgRoomStayCandidateType
     */
    public function setRoomArchitectureCode($roomArchitectureCode = null)
    {
        // validation for constraint: string
        if (!is_null($roomArchitectureCode) && !is_string($roomArchitectureCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($roomArchitectureCode)), __LINE__);
        }
        $this->RoomArchitectureCode = $roomArchitectureCode;
        return $this;
    }
    /**
     * Get RPH value
     * @return string|null
     */
    public function getRPH()
    {
        return $this->RPH;
    }
    /**
     * Set RPH value
     * @param string $rPH
     * @return \dgsoft\StructType\DgRoomStayCandidateType
     */
    public function setRPH($rPH = null)
    {
        // validation for constraint: string
        if (!is_null($rPH) && !is_string($rPH)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($rPH)), __LINE__);
        }
        $this->RPH = $rPH;
        return $this;
    }
    /**
     * Get RatePlanCandidateRPH value
     * @return string|null
     */
    public function getRatePlanCandidateRPH()
    {
        return $this->RatePlanCandidateRPH;
    }
    /**
     * Set RatePlanCandidateRPH value
     * @param string $ratePlanCandidateRPH
     * @return \dgsoft\StructType\DgRoomStayCandidateType
     */
    public function setRatePlanCandidateRPH($ratePlanCandidateRPH = null)
    {
        // validation for constraint: string
        if (!is_null($ratePlanCandidateRPH) && !is_string($ratePlanCandidateRPH)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($ratePlanCandidateRPH)), __LINE__);
        }
        $this->RatePlanCandidateRPH = $ratePlanCandidateRPH;
        return $this;
    }
    /**
     * Get BookingCode value
     * @return string|null
     */
    public function getBookingCode()
    {
        return $this->BookingCode;
    }
    /**
     * Set BookingCode value
     * @param string $bookingCode
     * @return \dgsoft\StructType\DgRoomStayCandidateType
     */
    public function setBookingCode($bookingCode = null)
    {
        // validation for constraint: string
        if (!is_null($bookingCode) && !is_string($bookingCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($bookingCode)), __LINE__);
        }
        $this->BookingCode = $bookingCode;
        return $this;
    }
    /**
     * Get EffectiveDate value
     * @return string|null
     */
    public function getEffectiveDate()
    {
        return $this->EffectiveDate;
    }
    /**
     * Set EffectiveDate value
     * @param string $effectiveDate
     * @return \dgsoft\StructType\DgRoomStayCandidateType
     */
    public function setEffectiveDate($effectiveDate = null)
    {
        // validation for constraint: string
        if (!is_null($effectiveDate) && !is_string($effectiveDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($effectiveDate)), __LINE__);
        }
        $this->EffectiveDate = $effectiveDate;
        return $this;
    }
    /**
     * Get ExpireDate value
     * @return string|null
     */
    public function getExpireDate()
    {
        return $this->ExpireDate;
    }
    /**
     * Set ExpireDate value
     * @param string $expireDate
     * @return \dgsoft\StructType\DgRoomStayCandidateType
     */
    public function setExpireDate($expireDate = null)
    {
        // validation for constraint: string
        if (!is_null($expireDate) && !is_string($expireDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($expireDate)), __LINE__);
        }
        $this->ExpireDate = $expireDate;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\StructType\DgRoomStayCandidateType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
