<?php

namespace dgsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RestrictionStatus StructType
 * @package Dg
 * @subpackage Structs
 */
class DgRestrictionStatus extends AbstractStructBase
{
    /**
     * The Restriction
     * @var string
     */
    public $Restriction;
    /**
     * The Status
     * @var string
     */
    public $Status;
    /**
     * The SellThroughOpenIndicator
     * @var bool
     */
    public $SellThroughOpenIndicator;
    /**
     * Constructor method for RestrictionStatus
     * @uses DgRestrictionStatus::setRestriction()
     * @uses DgRestrictionStatus::setStatus()
     * @uses DgRestrictionStatus::setSellThroughOpenIndicator()
     * @param string $restriction
     * @param string $status
     * @param bool $sellThroughOpenIndicator
     */
    public function __construct($restriction = null, $status = null, $sellThroughOpenIndicator = null)
    {
        $this
            ->setRestriction($restriction)
            ->setStatus($status)
            ->setSellThroughOpenIndicator($sellThroughOpenIndicator);
    }
    /**
     * Get Restriction value
     * @return string|null
     */
    public function getRestriction()
    {
        return $this->Restriction;
    }
    /**
     * Set Restriction value
     * @param string $restriction
     * @return \dgsoft\StructType\DgRestrictionStatus
     */
    public function setRestriction($restriction = null)
    {
        // validation for constraint: string
        if (!is_null($restriction) && !is_string($restriction)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($restriction)), __LINE__);
        }
        $this->Restriction = $restriction;
        return $this;
    }
    /**
     * Get Status value
     * @return string|null
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @uses \dgsoft\EnumType\DgAvailabilityStatusType::valueIsValid()
     * @uses \dgsoft\EnumType\DgAvailabilityStatusType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $status
     * @return \dgsoft\StructType\DgRestrictionStatus
     */
    public function setStatus($status = null)
    {
        // validation for constraint: enumeration
        if (!\dgsoft\EnumType\DgAvailabilityStatusType::valueIsValid($status)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $status, implode(', ', \dgsoft\EnumType\DgAvailabilityStatusType::getValidValues())), __LINE__);
        }
        $this->Status = $status;
        return $this;
    }
    /**
     * Get SellThroughOpenIndicator value
     * @return bool|null
     */
    public function getSellThroughOpenIndicator()
    {
        return $this->SellThroughOpenIndicator;
    }
    /**
     * Set SellThroughOpenIndicator value
     * @param bool $sellThroughOpenIndicator
     * @return \dgsoft\StructType\DgRestrictionStatus
     */
    public function setSellThroughOpenIndicator($sellThroughOpenIndicator = null)
    {
        // validation for constraint: boolean
        if (!is_null($sellThroughOpenIndicator) && !is_bool($sellThroughOpenIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($sellThroughOpenIndicator)), __LINE__);
        }
        $this->SellThroughOpenIndicator = $sellThroughOpenIndicator;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\StructType\DgRestrictionStatus
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
