<?php

namespace dgsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ResCommonDetailType StructType
 * @package Dg
 * @subpackage Structs
 */
class DgResCommonDetailType extends AbstractStructBase
{
    /**
     * The GuestCounts
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgGuestCountType
     */
    public $GuestCounts;
    /**
     * The TimeSpan
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgDateTimeSpanType
     */
    public $TimeSpan;
    /**
     * The ResGuestRPHs
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\ArrayType\DgArrayOfResGuestRPHsTypeResGuestRPH
     */
    public $ResGuestRPHs;
    /**
     * The Memberships
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\ArrayType\DgArrayOfMembershipTypeMembership
     */
    public $Memberships;
    /**
     * The Comments
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\ArrayType\DgArrayOfCommentTypeComment
     */
    public $Comments;
    /**
     * The SpecialRequests
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\ArrayType\DgArrayOfSpecialRequestTypeSpecialRequest
     */
    public $SpecialRequests;
    /**
     * The Guarantee
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Guarantee;
    /**
     * The DepositPayments
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\ArrayType\DgArrayOfRequiredPaymentsTypeGuaranteePayment
     */
    public $DepositPayments;
    /**
     * The CancelPenalties
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgCancelPenaltiesType
     */
    public $CancelPenalties;
    /**
     * The Fees
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\ArrayType\DgArrayOfFeeType
     */
    public $Fees;
    /**
     * The Total
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgTotalType
     */
    public $Total;
    /**
     * Constructor method for ResCommonDetailType
     * @uses DgResCommonDetailType::setGuestCounts()
     * @uses DgResCommonDetailType::setTimeSpan()
     * @uses DgResCommonDetailType::setResGuestRPHs()
     * @uses DgResCommonDetailType::setMemberships()
     * @uses DgResCommonDetailType::setComments()
     * @uses DgResCommonDetailType::setSpecialRequests()
     * @uses DgResCommonDetailType::setGuarantee()
     * @uses DgResCommonDetailType::setDepositPayments()
     * @uses DgResCommonDetailType::setCancelPenalties()
     * @uses DgResCommonDetailType::setFees()
     * @uses DgResCommonDetailType::setTotal()
     * @param \dgsoft\StructType\DgGuestCountType $guestCounts
     * @param \dgsoft\StructType\DgDateTimeSpanType $timeSpan
     * @param \dgsoft\ArrayType\DgArrayOfResGuestRPHsTypeResGuestRPH $resGuestRPHs
     * @param \dgsoft\ArrayType\DgArrayOfMembershipTypeMembership $memberships
     * @param \dgsoft\ArrayType\DgArrayOfCommentTypeComment $comments
     * @param \dgsoft\ArrayType\DgArrayOfSpecialRequestTypeSpecialRequest $specialRequests
     * @param string $guarantee
     * @param \dgsoft\ArrayType\DgArrayOfRequiredPaymentsTypeGuaranteePayment $depositPayments
     * @param \dgsoft\StructType\DgCancelPenaltiesType $cancelPenalties
     * @param \dgsoft\ArrayType\DgArrayOfFeeType $fees
     * @param \dgsoft\StructType\DgTotalType $total
     */
    public function __construct(\dgsoft\StructType\DgGuestCountType $guestCounts = null, \dgsoft\StructType\DgDateTimeSpanType $timeSpan = null, \dgsoft\ArrayType\DgArrayOfResGuestRPHsTypeResGuestRPH $resGuestRPHs = null, \dgsoft\ArrayType\DgArrayOfMembershipTypeMembership $memberships = null, \dgsoft\ArrayType\DgArrayOfCommentTypeComment $comments = null, \dgsoft\ArrayType\DgArrayOfSpecialRequestTypeSpecialRequest $specialRequests = null, $guarantee = null, \dgsoft\ArrayType\DgArrayOfRequiredPaymentsTypeGuaranteePayment $depositPayments = null, \dgsoft\StructType\DgCancelPenaltiesType $cancelPenalties = null, \dgsoft\ArrayType\DgArrayOfFeeType $fees = null, \dgsoft\StructType\DgTotalType $total = null)
    {
        $this
            ->setGuestCounts($guestCounts)
            ->setTimeSpan($timeSpan)
            ->setResGuestRPHs($resGuestRPHs)
            ->setMemberships($memberships)
            ->setComments($comments)
            ->setSpecialRequests($specialRequests)
            ->setGuarantee($guarantee)
            ->setDepositPayments($depositPayments)
            ->setCancelPenalties($cancelPenalties)
            ->setFees($fees)
            ->setTotal($total);
    }
    /**
     * Get GuestCounts value
     * @return \dgsoft\StructType\DgGuestCountType|null
     */
    public function getGuestCounts()
    {
        return $this->GuestCounts;
    }
    /**
     * Set GuestCounts value
     * @param \dgsoft\StructType\DgGuestCountType $guestCounts
     * @return \dgsoft\StructType\DgResCommonDetailType
     */
    public function setGuestCounts(\dgsoft\StructType\DgGuestCountType $guestCounts = null)
    {
        $this->GuestCounts = $guestCounts;
        return $this;
    }
    /**
     * Get TimeSpan value
     * @return \dgsoft\StructType\DgDateTimeSpanType|null
     */
    public function getTimeSpan()
    {
        return $this->TimeSpan;
    }
    /**
     * Set TimeSpan value
     * @param \dgsoft\StructType\DgDateTimeSpanType $timeSpan
     * @return \dgsoft\StructType\DgResCommonDetailType
     */
    public function setTimeSpan(\dgsoft\StructType\DgDateTimeSpanType $timeSpan = null)
    {
        $this->TimeSpan = $timeSpan;
        return $this;
    }
    /**
     * Get ResGuestRPHs value
     * @return \dgsoft\ArrayType\DgArrayOfResGuestRPHsTypeResGuestRPH|null
     */
    public function getResGuestRPHs()
    {
        return $this->ResGuestRPHs;
    }
    /**
     * Set ResGuestRPHs value
     * @param \dgsoft\ArrayType\DgArrayOfResGuestRPHsTypeResGuestRPH $resGuestRPHs
     * @return \dgsoft\StructType\DgResCommonDetailType
     */
    public function setResGuestRPHs(\dgsoft\ArrayType\DgArrayOfResGuestRPHsTypeResGuestRPH $resGuestRPHs = null)
    {
        $this->ResGuestRPHs = $resGuestRPHs;
        return $this;
    }
    /**
     * Get Memberships value
     * @return \dgsoft\ArrayType\DgArrayOfMembershipTypeMembership|null
     */
    public function getMemberships()
    {
        return $this->Memberships;
    }
    /**
     * Set Memberships value
     * @param \dgsoft\ArrayType\DgArrayOfMembershipTypeMembership $memberships
     * @return \dgsoft\StructType\DgResCommonDetailType
     */
    public function setMemberships(\dgsoft\ArrayType\DgArrayOfMembershipTypeMembership $memberships = null)
    {
        $this->Memberships = $memberships;
        return $this;
    }
    /**
     * Get Comments value
     * @return \dgsoft\ArrayType\DgArrayOfCommentTypeComment|null
     */
    public function getComments()
    {
        return $this->Comments;
    }
    /**
     * Set Comments value
     * @param \dgsoft\ArrayType\DgArrayOfCommentTypeComment $comments
     * @return \dgsoft\StructType\DgResCommonDetailType
     */
    public function setComments(\dgsoft\ArrayType\DgArrayOfCommentTypeComment $comments = null)
    {
        $this->Comments = $comments;
        return $this;
    }
    /**
     * Get SpecialRequests value
     * @return \dgsoft\ArrayType\DgArrayOfSpecialRequestTypeSpecialRequest|null
     */
    public function getSpecialRequests()
    {
        return $this->SpecialRequests;
    }
    /**
     * Set SpecialRequests value
     * @param \dgsoft\ArrayType\DgArrayOfSpecialRequestTypeSpecialRequest $specialRequests
     * @return \dgsoft\StructType\DgResCommonDetailType
     */
    public function setSpecialRequests(\dgsoft\ArrayType\DgArrayOfSpecialRequestTypeSpecialRequest $specialRequests = null)
    {
        $this->SpecialRequests = $specialRequests;
        return $this;
    }
    /**
     * Get Guarantee value
     * @return string|null
     */
    public function getGuarantee()
    {
        return $this->Guarantee;
    }
    /**
     * Set Guarantee value
     * @uses \dgsoft\EnumType\DgGuaranteeType::valueIsValid()
     * @uses \dgsoft\EnumType\DgGuaranteeType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $guarantee
     * @return \dgsoft\StructType\DgResCommonDetailType
     */
    public function setGuarantee($guarantee = null)
    {
        // validation for constraint: enumeration
        if (!\dgsoft\EnumType\DgGuaranteeType::valueIsValid($guarantee)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $guarantee, implode(', ', \dgsoft\EnumType\DgGuaranteeType::getValidValues())), __LINE__);
        }
        $this->Guarantee = $guarantee;
        return $this;
    }
    /**
     * Get DepositPayments value
     * @return \dgsoft\ArrayType\DgArrayOfRequiredPaymentsTypeGuaranteePayment|null
     */
    public function getDepositPayments()
    {
        return $this->DepositPayments;
    }
    /**
     * Set DepositPayments value
     * @param \dgsoft\ArrayType\DgArrayOfRequiredPaymentsTypeGuaranteePayment $depositPayments
     * @return \dgsoft\StructType\DgResCommonDetailType
     */
    public function setDepositPayments(\dgsoft\ArrayType\DgArrayOfRequiredPaymentsTypeGuaranteePayment $depositPayments = null)
    {
        $this->DepositPayments = $depositPayments;
        return $this;
    }
    /**
     * Get CancelPenalties value
     * @return \dgsoft\StructType\DgCancelPenaltiesType|null
     */
    public function getCancelPenalties()
    {
        return $this->CancelPenalties;
    }
    /**
     * Set CancelPenalties value
     * @param \dgsoft\StructType\DgCancelPenaltiesType $cancelPenalties
     * @return \dgsoft\StructType\DgResCommonDetailType
     */
    public function setCancelPenalties(\dgsoft\StructType\DgCancelPenaltiesType $cancelPenalties = null)
    {
        $this->CancelPenalties = $cancelPenalties;
        return $this;
    }
    /**
     * Get Fees value
     * @return \dgsoft\ArrayType\DgArrayOfFeeType|null
     */
    public function getFees()
    {
        return $this->Fees;
    }
    /**
     * Set Fees value
     * @param \dgsoft\ArrayType\DgArrayOfFeeType $fees
     * @return \dgsoft\StructType\DgResCommonDetailType
     */
    public function setFees(\dgsoft\ArrayType\DgArrayOfFeeType $fees = null)
    {
        $this->Fees = $fees;
        return $this;
    }
    /**
     * Get Total value
     * @return \dgsoft\StructType\DgTotalType|null
     */
    public function getTotal()
    {
        return $this->Total;
    }
    /**
     * Set Total value
     * @param \dgsoft\StructType\DgTotalType $total
     * @return \dgsoft\StructType\DgResCommonDetailType
     */
    public function setTotal(\dgsoft\StructType\DgTotalType $total = null)
    {
        $this->Total = $total;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\StructType\DgResCommonDetailType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
