<?php

namespace dgsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RequiredParametersRQ StructType
 * @package Dg
 * @subpackage Structs
 */
class DgRequiredParametersRQ extends AbstractStructBase
{
    /**
     * The RecommendationID
     * Meta informations extracted from the WSDL
     * - use: required
     * @var int
     */
    public $RecommendationID;
    /**
     * The CombinationID
     * Meta informations extracted from the WSDL
     * - use: required
     * @var int
     */
    public $CombinationID;
    /**
     * The IsOneWayCombinable
     * @var bool
     */
    public $IsOneWayCombinable;
    /**
     * The CCType
     * @var string
     */
    public $CCType;
    /**
     * Constructor method for RequiredParametersRQ
     * @uses DgRequiredParametersRQ::setRecommendationID()
     * @uses DgRequiredParametersRQ::setCombinationID()
     * @uses DgRequiredParametersRQ::setIsOneWayCombinable()
     * @uses DgRequiredParametersRQ::setCCType()
     * @param int $recommendationID
     * @param int $combinationID
     * @param bool $isOneWayCombinable
     * @param string $cCType
     */
    public function __construct($recommendationID = null, $combinationID = null, $isOneWayCombinable = null, $cCType = null)
    {
        $this
            ->setRecommendationID($recommendationID)
            ->setCombinationID($combinationID)
            ->setIsOneWayCombinable($isOneWayCombinable)
            ->setCCType($cCType);
    }
    /**
     * Get RecommendationID value
     * @return int
     */
    public function getRecommendationID()
    {
        return $this->RecommendationID;
    }
    /**
     * Set RecommendationID value
     * @param int $recommendationID
     * @return \dgsoft\StructType\DgRequiredParametersRQ
     */
    public function setRecommendationID($recommendationID = null)
    {
        // validation for constraint: int
        if (!is_null($recommendationID) && !is_numeric($recommendationID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($recommendationID)), __LINE__);
        }
        $this->RecommendationID = $recommendationID;
        return $this;
    }
    /**
     * Get CombinationID value
     * @return int
     */
    public function getCombinationID()
    {
        return $this->CombinationID;
    }
    /**
     * Set CombinationID value
     * @param int $combinationID
     * @return \dgsoft\StructType\DgRequiredParametersRQ
     */
    public function setCombinationID($combinationID = null)
    {
        // validation for constraint: int
        if (!is_null($combinationID) && !is_numeric($combinationID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($combinationID)), __LINE__);
        }
        $this->CombinationID = $combinationID;
        return $this;
    }
    /**
     * Get IsOneWayCombinable value
     * @return bool|null
     */
    public function getIsOneWayCombinable()
    {
        return $this->IsOneWayCombinable;
    }
    /**
     * Set IsOneWayCombinable value
     * @param bool $isOneWayCombinable
     * @return \dgsoft\StructType\DgRequiredParametersRQ
     */
    public function setIsOneWayCombinable($isOneWayCombinable = null)
    {
        // validation for constraint: boolean
        if (!is_null($isOneWayCombinable) && !is_bool($isOneWayCombinable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isOneWayCombinable)), __LINE__);
        }
        $this->IsOneWayCombinable = $isOneWayCombinable;
        return $this;
    }
    /**
     * Get CCType value
     * @return string|null
     */
    public function getCCType()
    {
        return $this->CCType;
    }
    /**
     * Set CCType value
     * @param string $cCType
     * @return \dgsoft\StructType\DgRequiredParametersRQ
     */
    public function setCCType($cCType = null)
    {
        // validation for constraint: string
        if (!is_null($cCType) && !is_string($cCType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($cCType)), __LINE__);
        }
        $this->CCType = $cCType;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\StructType\DgRequiredParametersRQ
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
