<?php

namespace dgsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RelativePositionType StructType
 * @package Dg
 * @subpackage Structs
 */
class DgRelativePositionType extends DgTransportationsType
{
    /**
     * The Direction
     * @var string
     */
    public $Direction;
    /**
     * The Distance
     * @var string
     */
    public $Distance;
    /**
     * The DistanceUnitName
     * @var string
     */
    public $DistanceUnitName;
    /**
     * The UnitOfMeasureCode
     * @var string
     */
    public $UnitOfMeasureCode;
    /**
     * The Nearest
     * @var bool
     */
    public $Nearest;
    /**
     * The IndexPointCode
     * @var string
     */
    public $IndexPointCode;
    /**
     * The Name
     * @var string
     */
    public $Name;
    /**
     * The PrimaryIndicator
     * @var bool
     */
    public $PrimaryIndicator;
    /**
     * The ToFrom
     * @var string
     */
    public $ToFrom;
    /**
     * The ApproximateDistanceInd
     * @var bool
     */
    public $ApproximateDistanceInd;
    /**
     * Constructor method for RelativePositionType
     * @uses DgRelativePositionType::setDirection()
     * @uses DgRelativePositionType::setDistance()
     * @uses DgRelativePositionType::setDistanceUnitName()
     * @uses DgRelativePositionType::setUnitOfMeasureCode()
     * @uses DgRelativePositionType::setNearest()
     * @uses DgRelativePositionType::setIndexPointCode()
     * @uses DgRelativePositionType::setName()
     * @uses DgRelativePositionType::setPrimaryIndicator()
     * @uses DgRelativePositionType::setToFrom()
     * @uses DgRelativePositionType::setApproximateDistanceInd()
     * @param string $direction
     * @param string $distance
     * @param string $distanceUnitName
     * @param string $unitOfMeasureCode
     * @param bool $nearest
     * @param string $indexPointCode
     * @param string $name
     * @param bool $primaryIndicator
     * @param string $toFrom
     * @param bool $approximateDistanceInd
     */
    public function __construct($direction = null, $distance = null, $distanceUnitName = null, $unitOfMeasureCode = null, $nearest = null, $indexPointCode = null, $name = null, $primaryIndicator = null, $toFrom = null, $approximateDistanceInd = null)
    {
        $this
            ->setDirection($direction)
            ->setDistance($distance)
            ->setDistanceUnitName($distanceUnitName)
            ->setUnitOfMeasureCode($unitOfMeasureCode)
            ->setNearest($nearest)
            ->setIndexPointCode($indexPointCode)
            ->setName($name)
            ->setPrimaryIndicator($primaryIndicator)
            ->setToFrom($toFrom)
            ->setApproximateDistanceInd($approximateDistanceInd);
    }
    /**
     * Get Direction value
     * @return string|null
     */
    public function getDirection()
    {
        return $this->Direction;
    }
    /**
     * Set Direction value
     * @param string $direction
     * @return \dgsoft\StructType\DgRelativePositionType
     */
    public function setDirection($direction = null)
    {
        // validation for constraint: string
        if (!is_null($direction) && !is_string($direction)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($direction)), __LINE__);
        }
        $this->Direction = $direction;
        return $this;
    }
    /**
     * Get Distance value
     * @return string|null
     */
    public function getDistance()
    {
        return $this->Distance;
    }
    /**
     * Set Distance value
     * @param string $distance
     * @return \dgsoft\StructType\DgRelativePositionType
     */
    public function setDistance($distance = null)
    {
        // validation for constraint: string
        if (!is_null($distance) && !is_string($distance)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($distance)), __LINE__);
        }
        $this->Distance = $distance;
        return $this;
    }
    /**
     * Get DistanceUnitName value
     * @return string|null
     */
    public function getDistanceUnitName()
    {
        return $this->DistanceUnitName;
    }
    /**
     * Set DistanceUnitName value
     * @uses \dgsoft\EnumType\DgDistanceUnitNameType::valueIsValid()
     * @uses \dgsoft\EnumType\DgDistanceUnitNameType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $distanceUnitName
     * @return \dgsoft\StructType\DgRelativePositionType
     */
    public function setDistanceUnitName($distanceUnitName = null)
    {
        // validation for constraint: enumeration
        if (!\dgsoft\EnumType\DgDistanceUnitNameType::valueIsValid($distanceUnitName)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $distanceUnitName, implode(', ', \dgsoft\EnumType\DgDistanceUnitNameType::getValidValues())), __LINE__);
        }
        $this->DistanceUnitName = $distanceUnitName;
        return $this;
    }
    /**
     * Get UnitOfMeasureCode value
     * @return string|null
     */
    public function getUnitOfMeasureCode()
    {
        return $this->UnitOfMeasureCode;
    }
    /**
     * Set UnitOfMeasureCode value
     * @param string $unitOfMeasureCode
     * @return \dgsoft\StructType\DgRelativePositionType
     */
    public function setUnitOfMeasureCode($unitOfMeasureCode = null)
    {
        // validation for constraint: string
        if (!is_null($unitOfMeasureCode) && !is_string($unitOfMeasureCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($unitOfMeasureCode)), __LINE__);
        }
        $this->UnitOfMeasureCode = $unitOfMeasureCode;
        return $this;
    }
    /**
     * Get Nearest value
     * @return bool|null
     */
    public function getNearest()
    {
        return $this->Nearest;
    }
    /**
     * Set Nearest value
     * @param bool $nearest
     * @return \dgsoft\StructType\DgRelativePositionType
     */
    public function setNearest($nearest = null)
    {
        // validation for constraint: boolean
        if (!is_null($nearest) && !is_bool($nearest)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($nearest)), __LINE__);
        }
        $this->Nearest = $nearest;
        return $this;
    }
    /**
     * Get IndexPointCode value
     * @return string|null
     */
    public function getIndexPointCode()
    {
        return $this->IndexPointCode;
    }
    /**
     * Set IndexPointCode value
     * @param string $indexPointCode
     * @return \dgsoft\StructType\DgRelativePositionType
     */
    public function setIndexPointCode($indexPointCode = null)
    {
        // validation for constraint: string
        if (!is_null($indexPointCode) && !is_string($indexPointCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($indexPointCode)), __LINE__);
        }
        $this->IndexPointCode = $indexPointCode;
        return $this;
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \dgsoft\StructType\DgRelativePositionType
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->Name = $name;
        return $this;
    }
    /**
     * Get PrimaryIndicator value
     * @return bool|null
     */
    public function getPrimaryIndicator()
    {
        return $this->PrimaryIndicator;
    }
    /**
     * Set PrimaryIndicator value
     * @param bool $primaryIndicator
     * @return \dgsoft\StructType\DgRelativePositionType
     */
    public function setPrimaryIndicator($primaryIndicator = null)
    {
        // validation for constraint: boolean
        if (!is_null($primaryIndicator) && !is_bool($primaryIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($primaryIndicator)), __LINE__);
        }
        $this->PrimaryIndicator = $primaryIndicator;
        return $this;
    }
    /**
     * Get ToFrom value
     * @return string|null
     */
    public function getToFrom()
    {
        return $this->ToFrom;
    }
    /**
     * Set ToFrom value
     * @param string $toFrom
     * @return \dgsoft\StructType\DgRelativePositionType
     */
    public function setToFrom($toFrom = null)
    {
        // validation for constraint: string
        if (!is_null($toFrom) && !is_string($toFrom)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($toFrom)), __LINE__);
        }
        $this->ToFrom = $toFrom;
        return $this;
    }
    /**
     * Get ApproximateDistanceInd value
     * @return bool|null
     */
    public function getApproximateDistanceInd()
    {
        return $this->ApproximateDistanceInd;
    }
    /**
     * Set ApproximateDistanceInd value
     * @param bool $approximateDistanceInd
     * @return \dgsoft\StructType\DgRelativePositionType
     */
    public function setApproximateDistanceInd($approximateDistanceInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($approximateDistanceInd) && !is_bool($approximateDistanceInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($approximateDistanceInd)), __LINE__);
        }
        $this->ApproximateDistanceInd = $approximateDistanceInd;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\StructType\DgRelativePositionType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
