<?php

namespace dgsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RebookOption StructType
 * @package Dg
 * @subpackage Structs
 */
class DgRebookOption extends AbstractStructBase
{
    /**
     * The FlightSegmentRPH
     * @var string
     */
    public $FlightSegmentRPH;
    /**
     * The ResBookDesigCode
     * @var string
     */
    public $ResBookDesigCode;
    /**
     * Constructor method for RebookOption
     * @uses DgRebookOption::setFlightSegmentRPH()
     * @uses DgRebookOption::setResBookDesigCode()
     * @param string $flightSegmentRPH
     * @param string $resBookDesigCode
     */
    public function __construct($flightSegmentRPH = null, $resBookDesigCode = null)
    {
        $this
            ->setFlightSegmentRPH($flightSegmentRPH)
            ->setResBookDesigCode($resBookDesigCode);
    }
    /**
     * Get FlightSegmentRPH value
     * @return string|null
     */
    public function getFlightSegmentRPH()
    {
        return $this->FlightSegmentRPH;
    }
    /**
     * Set FlightSegmentRPH value
     * @param string $flightSegmentRPH
     * @return \dgsoft\StructType\DgRebookOption
     */
    public function setFlightSegmentRPH($flightSegmentRPH = null)
    {
        // validation for constraint: string
        if (!is_null($flightSegmentRPH) && !is_string($flightSegmentRPH)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($flightSegmentRPH)), __LINE__);
        }
        $this->FlightSegmentRPH = $flightSegmentRPH;
        return $this;
    }
    /**
     * Get ResBookDesigCode value
     * @return string|null
     */
    public function getResBookDesigCode()
    {
        return $this->ResBookDesigCode;
    }
    /**
     * Set ResBookDesigCode value
     * @param string $resBookDesigCode
     * @return \dgsoft\StructType\DgRebookOption
     */
    public function setResBookDesigCode($resBookDesigCode = null)
    {
        // validation for constraint: string
        if (!is_null($resBookDesigCode) && !is_string($resBookDesigCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($resBookDesigCode)), __LINE__);
        }
        $this->ResBookDesigCode = $resBookDesigCode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\StructType\DgRebookOption
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
